/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.entry.vending;

import com.google.gson.annotations.Expose;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.vending.Product;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class ProductEntry {
    private static final Random RANDOM = new Random();
    @Expose
    public String id;
    @Expose
    public String tag;
    @Expose
    public String nbt;
    @Expose
    public int amountMin;
    @Expose
    public int amountMax;

    public ProductEntry() {
    }

    public ProductEntry(Item item) {
        this(item, 1, null);
    }

    public ProductEntry(ItemStack stack) {
        this(stack.m_41720_(), stack.m_41613_(), stack.m_41783_());
    }

    public ProductEntry(Item item, int amount, @Nullable CompoundTag nbt) {
        this(item, amount, amount, nbt);
    }

    public ProductEntry(Item item, int amountMin, int amountMax, @Nullable CompoundTag nbt) {
        this.id = Objects.requireNonNull(item.getRegistryName()).toString();
        this.nbt = nbt == null ? null : nbt.toString();
        this.amountMin = amountMin;
        this.amountMax = amountMax;
    }

    public Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.id));
    }

    public int generateAmount() {
        return MathUtilities.getRandomInt(this.amountMin, this.amountMax);
    }

    public CompoundTag getNBT() {
        if (this.nbt == null) {
            return null;
        }
        try {
            return TagParser.m_129359_((String)this.nbt);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Product toProduct() {
        return new Product(this.getItem(), this.generateAmount(), this.getNBT());
    }

    public ItemStack generateItemStack() {
        Item item = null;
        if (this.tag != null && !this.tag.isEmpty()) {
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)this.tag);
            if (resourceLocation != null) {
                Optional optionalItem;
                TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)resourceLocation);
                ITagManager itemTags = ForgeRegistries.ITEMS.tags();
                System.out.println(itemTags.getTagNames().collect(Collectors.toList()));
                if (itemTags != null && itemTags.isKnownTagName(tagKey) && (optionalItem = itemTags.getTag(tagKey).getRandomElement(RANDOM)).isPresent()) {
                    item = (Item)optionalItem.get();
                }
            }
        } else {
            item = this.getItem();
        }
        ItemStack itemStack = new ItemStack((ItemLike)item, this.generateAmount());
        CompoundTag tag = this.getNBT();
        if (tag != null && !tag.m_128456_()) {
            itemStack.m_41751_(tag);
        }
        return itemStack;
    }
}

