/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.IntRollRangeEntry;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.FloatAttributeGenerator;
import iskallia.vault.gear.attribute.custom.RandomGodVaultModifierAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectAvoidanceListGearAttribute;
import iskallia.vault.init.ModGearAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public class VaultCharmTierConfig
extends Config {
    @Expose
    private final Map<VaultGod, VaultGearTierConfig.AttributeGroup> godModifiers = new LinkedHashMap<VaultGod, VaultGearTierConfig.AttributeGroup>();
    @Expose
    private HashMap<VaultGearRarity, Integer> uses = new HashMap();

    public VaultGearTierConfig.AttributeGroup getModifierGroup(VaultGod god) {
        return this.godModifiers.get((Object)god);
    }

    @Override
    public String getName() {
        return "gear_modifiers/vault_charm";
    }

    @Nullable
    public Object getTierConfig(VaultGod god, VaultGearModifier<?> modifier) {
        for (VaultGearTierConfig.ModifierTier<?> modTier : this.getAllTiers(god, modifier.getModifierIdentifier())) {
            if (modTier.getModifierTier() != modifier.getRolledTier()) continue;
            return modTier.getModifierConfiguration();
        }
        return null;
    }

    public List<Tuple<VaultGod, VaultGearTierConfig.ModifierTierGroup>> getGroupsFulfilling(Predicate<VaultGearTierConfig.ModifierTierGroup> filter) {
        ArrayList<Tuple<VaultGod, VaultGearTierConfig.ModifierTierGroup>> configs = new ArrayList<Tuple<VaultGod, VaultGearTierConfig.ModifierTierGroup>>();
        for (Map.Entry<VaultGod, VaultGearTierConfig.AttributeGroup> entry : this.godModifiers.entrySet()) {
            for (VaultGearTierConfig.ModifierTierGroup group : entry.getValue()) {
                if (!filter.test(group)) continue;
                configs.add((Tuple<VaultGod, VaultGearTierConfig.ModifierTierGroup>)new Tuple((Object)entry.getKey(), (Object)group));
            }
        }
        return configs;
    }

    @Nonnull
    public VaultGearTierConfig.ModifierConfigRange getTierConfigRange(VaultGod god, VaultGearModifier<?> modifier, int level) {
        Object tier;
        VaultGearTierConfig.ModifierTierGroup tierGroup;
        Object currentTierCfg = null;
        VaultGearTierConfig.ModifierTier min = null;
        VaultGearTierConfig.ModifierTier max = null;
        if (modifier.hasAnyCategoryMatching(VaultGearModifier.AffixCategory::onlyDisplayCurrentTierInformation) && (tierGroup = this.getTierGroup(god, modifier.getModifierIdentifier())) != null && (tier = tierGroup.getModifierForTier(modifier.getRolledTier())) != null) {
            Object t = ((VaultGearTierConfig.ModifierTier)tier).getModifierConfiguration();
            return new VaultGearTierConfig.ModifierConfigRange(t, Lists.newArrayList((Object[])new Object[]{t}), t, t);
        }
        ArrayList<Object> tiers = new ArrayList<Object>();
        for (VaultGearTierConfig.ModifierTier modifierTier : this.getAllTiers(god, modifier.getModifierIdentifier())) {
            if (modifierTier.getMinLevel() > level || modifierTier.getMaxLevel() != -1 && modifierTier.getMaxLevel() < level) continue;
            tiers.add(modifierTier.getModifierConfiguration());
            if (modifierTier.getModifierTier() == modifier.getRolledTier()) {
                currentTierCfg = modifierTier.getModifierConfiguration();
            }
            if (min == null || modifierTier.getMinLevel() < min.getMinLevel()) {
                min = modifierTier;
            }
            if (max != null && modifierTier.getMinLevel() <= max.getMinLevel() && max.getMaxLevel() != -1) continue;
            max = modifierTier;
        }
        Object minCfg = min == null ? null : min.getModifierConfiguration();
        Object var9_11 = max == null ? null : max.getModifierConfiguration();
        return new VaultGearTierConfig.ModifierConfigRange(currentTierCfg, tiers, minCfg, var9_11);
    }

    public Optional<VaultGearTierConfig.ModifierOutcome<?>> getConfiguredModifierTier(VaultGod god, ResourceLocation identifier, int modifierTier) {
        if (!this.godModifiers.containsKey((Object)god)) {
            return Optional.empty();
        }
        VaultGearTierConfig.ModifierTierGroup group = this.getTierGroup(god, identifier);
        if (group != null) {
            for (VaultGearTierConfig.ModifierTier tier : group) {
                if (tier.getModifierTier() != modifierTier) continue;
                return Optional.of(new VaultGearTierConfig.ModifierOutcome(tier, group));
            }
        }
        return Optional.empty();
    }

    public Optional<VaultGearModifier<?>> createModifier(VaultGod god, ResourceLocation identifier, int modifierTier, Random random) {
        return this.getConfiguredModifierTier(god, identifier, modifierTier).map(outcome -> outcome.makeModifier(random));
    }

    public List<VaultGearTierConfig.ModifierTier<?>> getAllTiers(VaultGod god, @Nullable ResourceLocation identifier) {
        VaultGearTierConfig.ModifierTierGroup group = this.getTierGroup(god, identifier);
        if (group != null) {
            return Collections.unmodifiableList(group);
        }
        return Collections.emptyList();
    }

    @Nullable
    public VaultGearModifier<?> generateModifier(VaultGod god, ResourceLocation identifier, int level, Random random) {
        VaultGearTierConfig.ModifierTierGroup group = this.getTierGroup(god, identifier);
        if (group != null) {
            WeightedList outcomes = new WeightedList();
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new VaultGearTierConfig.ModifierOutcome(tier, group), tier.getWeight()));
            return outcomes.getRandom().map(modifierOutcome -> modifierOutcome.makeModifier(random)).orElse(null);
        }
        return null;
    }

    @Nullable
    public VaultGearTierConfig.ModifierTierGroup getTierGroup(VaultGod god, @Nullable ResourceLocation identifier) {
        VaultGearTierConfig.AttributeGroup attributePool = this.godModifiers.get((Object)god);
        if (attributePool == null) {
            return null;
        }
        for (VaultGearTierConfig.ModifierTierGroup group : attributePool) {
            if (!group.getIdentifier().equals((Object)identifier)) continue;
            return group;
        }
        return null;
    }

    public Optional<VaultGearModifier<?>> getRandomModifier(VaultGod god, int level, Random random) {
        VaultGearTierConfig.AttributeGroup attributePool = this.godModifiers.get((Object)god);
        if (attributePool == null || attributePool.isEmpty()) {
            return Optional.empty();
        }
        WeightedList outcomes = new WeightedList();
        attributePool.forEach(group -> group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new VaultGearTierConfig.ModifierOutcome(tier, (VaultGearTierConfig.ModifierTierGroup)group), tier.getWeight())));
        return outcomes.getRandom().map(modifierOutcome -> modifierOutcome.makeModifier(random));
    }

    @Override
    protected void reset() {
        this.godModifiers.clear();
        VaultGearTierConfig.AttributeGroup idonaModifiers = new VaultGearTierConfig.AttributeGroup();
        VaultGearTierConfig.ModifierTierGroup idonaDamageGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.DAMAGE_INCREASE, "IdonaAttackDamage", "idona_damage");
        idonaDamageGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(0.5f, 2.5f, 0.5f)));
        VaultGearTierConfig.ModifierTierGroup idonaAbilityPowerGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.ABILITY_POWER_PERCENT, "IdonaAbilityPower", "idona_ability_power");
        idonaAbilityPowerGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(0.25f, 0.75f, 0.25f)));
        VaultGearTierConfig.ModifierTierGroup idonaSoulGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.SOUL_QUANTITY, "IdonaSoulChance", "idona_soul_chance");
        idonaSoulGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(1.0f, 4.0f, 1.0f)));
        idonaModifiers.add(idonaDamageGroup);
        idonaModifiers.add(idonaAbilityPowerGroup);
        idonaModifiers.add(idonaSoulGroup);
        this.godModifiers.put(VaultGod.IDONA, idonaModifiers);
        VaultGearTierConfig.AttributeGroup tenosModifiers = new VaultGearTierConfig.AttributeGroup();
        VaultGearTierConfig.ModifierTierGroup tenosManaRegenGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.MANA_REGEN_ADDITIVE_PERCENTILE, "TenosManaRegen", "tenos_mana_regen");
        tenosManaRegenGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(2.0f, 6.0f, 1.0f)));
        VaultGearTierConfig.ModifierTierGroup tenosManaGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.MANA_ADDITIVE_PERCENTILE, "TenosMana", "tenos_mana");
        tenosManaGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(0.25f, 0.75f, 0.25f)));
        VaultGearTierConfig.ModifierTierGroup tenosAoEGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.AREA_OF_EFFECT, "TenosAreaOfEffect", "tenos_aoe");
        tenosAoEGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(0.25f, 0.75f, 0.25f)));
        VaultGearTierConfig.ModifierTierGroup tenosModifierGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.RANDOM_VAULT_GOD_MODIFIER, "TenosVaultModifierGroup", "tenos_totemic");
        tenosModifierGroup.add(new VaultGearTierConfig.ModifierTier<RandomGodVaultModifierAttribute.Config>(0, 10, new RandomGodVaultModifierAttribute.Config(VaultMod.id("kill_totem"), 1, new IntRollRangeEntry(120, 120, 1), VaultGod.TENOS)));
        tenosModifiers.add(tenosManaRegenGroup);
        tenosModifiers.add(tenosManaGroup);
        tenosModifiers.add(tenosAoEGroup);
        tenosModifiers.add(tenosModifierGroup);
        this.godModifiers.put(VaultGod.TENOS, tenosModifiers);
        VaultGearTierConfig.AttributeGroup velaraModifiers = new VaultGearTierConfig.AttributeGroup();
        VaultGearTierConfig.ModifierTierGroup velaraHealthGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.HEALTH_PERCENTILE, "VelaraHealth", "velara_health");
        velaraHealthGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(0.25f, 0.75f, 0.25f)));
        VaultGearTierConfig.ModifierTierGroup velaraHealingGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.HEALING_EFFECTIVENESS, "VelaraHealing", "velara_healing");
        velaraHealingGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(0.25f, 0.75f, 0.25f)));
        VaultGearTierConfig.ModifierTierGroup velaraEffectAvoidGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.EFFECT_LIST_AVOIDANCE, "VelaraEffectAvoid", "velara_effect_avoid");
        velaraEffectAvoidGroup.add(new VaultGearTierConfig.ModifierTier<EffectAvoidanceListGearAttribute.Config>(0, 10, new EffectAvoidanceListGearAttribute.Config(List.of(new ResourceLocation("poison"), new ResourceLocation("wither"), new ResourceLocation("levitation"), new ResourceLocation("slowness"), new ResourceLocation("blindness"), new ResourceLocation("hunger"), VaultMod.id("bleed"), VaultMod.id("chilled"), VaultMod.id("corruption")), "the_vault.gear_attribute.effect_avoidance.avoidance.bad_effects", 0.25f, 0.75f, 0.25f)));
        velaraModifiers.add(velaraHealthGroup);
        velaraModifiers.add(velaraHealingGroup);
        velaraModifiers.add(velaraEffectAvoidGroup);
        this.godModifiers.put(VaultGod.VELARA, velaraModifiers);
        VaultGearTierConfig.AttributeGroup wendarrModifiers = new VaultGearTierConfig.AttributeGroup();
        VaultGearTierConfig.ModifierTierGroup wendarrCDRGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.COOLDOWN_REDUCTION, "WendarrCDR", "wendarr_cdr");
        wendarrCDRGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(0.25f, 0.75f, 0.25f)));
        VaultGearTierConfig.ModifierTierGroup wendarrEffectDurationGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.EFFECT_DURATION, "WendarrEffectDuration", "wendarr_effect_duration");
        wendarrEffectDurationGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(0.25f, 0.75f, 0.25f)));
        VaultGearTierConfig.ModifierTierGroup wendarrMovementSpeedGroup = new VaultGearTierConfig.ModifierTierGroup(ModGearAttributes.MOVEMENT_SPEED, "WendarrMovementSpeed", "wendarr_movement_speed");
        wendarrMovementSpeedGroup.add(new VaultGearTierConfig.ModifierTier<FloatAttributeGenerator.Range>(0, 10, new FloatAttributeGenerator.Range(0.5f, 1.0f, 0.1f)));
        wendarrModifiers.add(wendarrCDRGroup);
        wendarrModifiers.add(wendarrEffectDurationGroup);
        wendarrModifiers.add(wendarrMovementSpeedGroup);
        this.godModifiers.put(VaultGod.WENDARR, wendarrModifiers);
        this.uses = new HashMap();
    }

    @Override
    protected boolean isValid() {
        HashSet<ResourceLocation> foundIdentifiers = new HashSet<ResourceLocation>();
        for (VaultGearTierConfig.AttributeGroup group : this.godModifiers.values()) {
            for (VaultGearTierConfig.ModifierTierGroup tierGroup : group) {
                if (foundIdentifiers.add(tierGroup.getIdentifier())) continue;
                throw new IllegalArgumentException("Invalid God Charm configuration - duplicate identifier found: %s".formatted(tierGroup.getIdentifier().toString()));
            }
        }
        return true;
    }
}

