/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.config.FloatAttributeGenerator;
import iskallia.vault.gear.attribute.config.PairAttributeGenerator;
import iskallia.vault.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;

public class VaultEtchingConfig
extends Config {
    @Expose
    public Map<ResourceLocation, EtchingEntry> ETCHINGS = new LinkedHashMap<ResourceLocation, EtchingEntry>();
    @Expose
    private Map<String, Set<VaultGearType>> groups = new LinkedHashMap<String, Set<VaultGearType>>();

    @Override
    public String getName() {
        return "gear/etchings";
    }

    @Nullable
    public EtchingEntry getEtchingConfig(ResourceLocation id) {
        return this.ETCHINGS.get(id);
    }

    public List<EtchingEntry> getEtchingConfigs() {
        return new ArrayList<EtchingEntry>(this.ETCHINGS.values());
    }

    public Set<ResourceLocation> getEtchingIds() {
        return this.ETCHINGS.keySet();
    }

    public Set<VaultGearType> getGroup(String name) {
        return this.groups.getOrDefault(name, Collections.emptySet());
    }

    public Set<String> getGroupNames() {
        return this.groups.keySet();
    }

    @Override
    protected void reset() {
        this.groups.clear();
        this.groups.put("Defensive", EnumSet.of(VaultGearType.HELMET, VaultGearType.CHESTPLATE, VaultGearType.LEGGINGS, VaultGearType.BOOTS));
        this.groups.put("Offensive", EnumSet.of(VaultGearType.SWORD, VaultGearType.AXE));
        this.groups.put("Utility", EnumSet.of(VaultGearType.WAND, VaultGearType.FOCUS, VaultGearType.SHIELD));
        this.ETCHINGS.clear();
        VaultGearAttributeRegistry.getRegistry().forEach(attr -> {
            ResourceLocation id = attr.getRegistryName();
            if (id == null || !id.m_135815_().startsWith("etching_")) {
                return;
            }
            EtchingEntry entry = new EtchingEntry(id.m_135815_(), "", 0xFFFFFF);
            entry.typeGroups.add("Offensive");
            entry.attributes = new VaultGearTierConfig.AttributeGroup();
            VaultGearTierConfig.ModifierTierGroup group = new VaultGearTierConfig.ModifierTierGroup((VaultGearAttribute<?>)((Object)attr), "EtchingGroup", id.m_135815_());
            if (id.equals((Object)VaultMod.id("etching_glacial_shatter_explosion"))) {
                group.add(0, new VaultGearTierConfig.ModifierTier<PairAttributeGenerator.Config2<FloatAttributeGenerator.Range, FloatAttributeGenerator.Range>>(0, 100, new PairAttributeGenerator.Config2<FloatAttributeGenerator.Range, FloatAttributeGenerator.Range>(new FloatAttributeGenerator.Range(0.0f, 0.0f), new FloatAttributeGenerator.Range(0.0f, 0.0f), "percentAD", "range")));
            }
            entry.attributes.add(group);
            this.ETCHINGS.put(id, entry);
        });
    }

    public static class EtchingEntry {
        @Expose
        private String name;
        @Expose
        private String description;
        @Expose
        private int color;
        @Expose
        private List<String> typeGroups = new ArrayList<String>();
        @Expose
        private VaultGearTierConfig.AttributeGroup attributes = new VaultGearTierConfig.AttributeGroup();
        @Expose
        @Nullable
        private String itemOverlay;

        public EtchingEntry(String name, String description, int color) {
            this.name = name;
            this.description = description;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getColor() {
            return this.color;
        }

        public List<String> getTypeGroups() {
            return this.typeGroups;
        }

        public VaultGearTierConfig.AttributeGroup getAttributes() {
            return this.attributes;
        }

        public TextColor getComponentColor() {
            return TextColor.m_131266_((int)this.color);
        }

        public MutableComponent getColoredDescription() {
            return TextUtil.applyColorTags(this.description);
        }

        @Nullable
        public String getItemOverlay() {
            return this.itemOverlay;
        }
    }
}

