/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.FloatLevelEntryList;
import iskallia.vault.config.entry.MultipleGearAttributeRollOutputEntry;
import iskallia.vault.config.entry.MultipleRollOutputEntry;
import iskallia.vault.config.gear.VaultGearTypeConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.SidedHelper;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class VaultGearCraftingConfig
extends Config {
    private static final Map<Integer, Integer> proficiencyCaps = new HashMap<Integer, Integer>();
    @Expose
    private String defaultCraftedPool;
    @Expose
    private final FloatLevelEntryList<ProficiencyStep> proficiencyPools = new FloatLevelEntryList();

    @Override
    public String getName() {
        return "gear%sgear_crafting".formatted(File.separator);
    }

    public VaultGearTypeConfig.RollType getDefaultCraftedPool() {
        return ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPool(this.defaultCraftedPool).orElse(ModConfigs.VAULT_GEAR_TYPE_CONFIG.getDefaultRoll());
    }

    public Optional<ProficiencyStep> getProficiencyStep(float proficiencyDegree) {
        return this.proficiencyPools.getForValue(proficiencyDegree);
    }

    public List<ProficiencyStep> getProficiencySteps() {
        return Collections.unmodifiableList(this.proficiencyPools);
    }

    @Override
    protected void reset() {
        this.defaultCraftedPool = "Scrappy";
        this.proficiencyPools.clear();
        this.proficiencyPools.add(new ProficiencyStep("Tier 0", "Normal", 0.0f, "Scrappy", 65280, 1.0f, List.of(new MultipleGearAttributeRollOutputEntry(MultipleRollOutputEntry.OutcomeBias.BEST, 1, "the_vault:base_durability")), 1.0f, 4, 0.1f, new ResourceLocation("the_vault:base_soulbound"), List.of(VaultMod.id("base_living"))));
    }

    @Override
    protected void onLoad(@Nullable Config oldConfigInstance) {
        super.onLoad(oldConfigInstance);
        VaultGearCraftingConfig.rebuildProficiencyCaps();
    }

    public static void rebuildProficiencyCaps() {
        proficiencyCaps.clear();
        for (int level = 1; level <= 100; ++level) {
            double absProficiencyCapAtLevel = 2.71E-8 * Math.pow(level, 6.49) + (double)(25 * level);
            proficiencyCaps.put(level, (int)Math.round(absProficiencyCapAtLevel));
        }
    }

    public static int getProficiencyCap(int level) {
        return proficiencyCaps.getOrDefault(level, 1);
    }

    public static float calculateRelativeProficiency(int absoluteProficiency, Player player) {
        return VaultGearCraftingConfig.calculateRelativeProficiency(absoluteProficiency, SidedHelper.getVaultLevel(player));
    }

    public static float calculateRelativeProficiency(int absoluteProficiency, int playerLevel) {
        int proficiencyCap = VaultGearCraftingConfig.getProficiencyCap(playerLevel);
        if (absoluteProficiency >= proficiencyCap) {
            return 1.0f;
        }
        return Mth.m_14036_((float)((float)absoluteProficiency / (float)proficiencyCap), (float)0.0f, (float)1.0f);
    }

    public static class ProficiencyStep
    implements FloatLevelEntryList.FloatLevelEntry {
        @Expose
        private String proficiencyName;
        @Expose
        private String durabilityOutcomeName;
        @Expose
        private float minProficiency;
        @Expose
        private String pool;
        @Expose
        private int color;
        @Expose
        private float craftingPotentialMultiplier;
        @Expose
        private List<MultipleGearAttributeRollOutputEntry> gearRollOutcomeModifiers;
        @Expose
        private float greaterModifierChance;
        @Expose
        private int maximumRepairSlots;
        @Expose
        private float soulboundChance;
        @Expose
        private ResourceLocation soulboundModifierId;
        @Expose
        private List<ResourceLocation> notAllowedModifiers;

        public ProficiencyStep(String proficiencyName, String durabilityOutcomeName, float minProficiency, String pool, int color, float craftingPotentialMultiplier, List<MultipleGearAttributeRollOutputEntry> gearRollOutcomeModifiers, float greaterModifierChance, int maximumRepairSlots, float soulboundChance, ResourceLocation soulboundModifierId, List<ResourceLocation> notAllowedModifiers) {
            this.proficiencyName = proficiencyName;
            this.durabilityOutcomeName = durabilityOutcomeName;
            this.minProficiency = minProficiency;
            this.pool = pool;
            this.color = color;
            this.craftingPotentialMultiplier = craftingPotentialMultiplier;
            this.gearRollOutcomeModifiers = gearRollOutcomeModifiers;
            this.greaterModifierChance = greaterModifierChance;
            this.maximumRepairSlots = maximumRepairSlots;
            this.soulboundChance = soulboundChance;
            this.soulboundModifierId = soulboundModifierId;
            this.notAllowedModifiers = notAllowedModifiers;
        }

        public String getProficiencyName() {
            return this.proficiencyName;
        }

        public String getDurabilityOutcomeName() {
            return this.durabilityOutcomeName;
        }

        public float getMinProficiency() {
            return this.minProficiency;
        }

        public String getPool() {
            return this.pool;
        }

        public int getColor() {
            return this.color;
        }

        public float getCraftingPotentialMultiplier() {
            return this.craftingPotentialMultiplier;
        }

        public List<MultipleGearAttributeRollOutputEntry> getGearRollOutcomeModifiers() {
            return this.gearRollOutcomeModifiers;
        }

        public float getGreaterModifierChance() {
            return this.greaterModifierChance;
        }

        public int getMaximumRepairSlots() {
            return this.maximumRepairSlots;
        }

        public float getSoulboundChance() {
            return this.soulboundChance;
        }

        public ResourceLocation getSoulboundModifierId() {
            return this.soulboundModifierId;
        }

        public List<ResourceLocation> getNotAllowedModifiers() {
            return this.notAllowedModifiers;
        }

        public boolean isModifierAllowedConfig(ResourceLocation modifierId) {
            if (this.notAllowedModifiers == null || this.notAllowedModifiers.isEmpty()) {
                return true;
            }
            return !this.notAllowedModifiers.contains(modifierId);
        }

        public static boolean isModifierAllowed(ItemStack stack, ResourceLocation modifierId) {
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("CraftingRestrictions")) {
                return true;
            }
            CompoundTag craftingTag = stack.m_41737_("CraftingRestrictions");
            if (!craftingTag.m_128471_("HasRestrictions")) {
                return true;
            }
            if (!craftingTag.m_128425_("DisallowedModifiers", 9)) {
                return true;
            }
            ListTag disallowedList = craftingTag.m_128437_("DisallowedModifiers", 8);
            for (int i = 0; i < disallowedList.size(); ++i) {
                if (!disallowedList.m_128778_(i).equals(modifierId.toString())) continue;
                return false;
            }
            return true;
        }

        @Override
        public float getMinValue() {
            return this.getMinProficiency();
        }
    }
}

