/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.util.data.WeightedList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public class VaultGearTagConfig
extends Config {
    @Expose
    private final Map<String, ModTagGroup> tags = new LinkedHashMap<String, ModTagGroup>();

    @Override
    public String getName() {
        return "gear%sgear_tags".formatted(File.separator);
    }

    @Nullable
    public ModTagGroup getGroupTag(String tag) {
        return this.tags.get(tag);
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags.keySet());
    }

    @Nullable
    public String getRandomTag() {
        WeightedList tags = new WeightedList();
        this.tags.forEach((tag, groupCfg) -> tags.add(tag, groupCfg.getWeight()));
        return (String)tags.getRandom(rand);
    }

    @Nullable
    public ModTagGroup getTagContaining(String tag) {
        return this.tags.values().stream().filter(groupCfg -> groupCfg.getTags().contains(tag)).findFirst().orElse(null);
    }

    public String getTagNameContaining(String tag) {
        ModTagGroup group = this.getTagContaining(tag);
        if (group == null) {
            return null;
        }
        WeightedList<String> tags = new WeightedList<String>();
        for (Map.Entry<String, ModTagGroup> entry : this.tags.entrySet()) {
            if (!entry.getValue().equals(group)) continue;
            tags.add(entry.getKey(), entry.getValue().getWeight());
        }
        return (String)tags.getRandom(rand);
    }

    @Override
    protected void reset() {
        this.tags.clear();
        this.tags.put("Armor", new ModTagGroup("Armor", 4766456, List.of(VaultGearModifier.AffixType.PREFIX)).addTag("ModArmor"));
    }

    public static class ModTagGroup {
        @Expose
        private List<String> tags = new ArrayList<String>();
        @Expose
        private String display;
        @Expose
        private int color;
        @Expose
        private int weight = 10;
        @Expose
        private List<VaultGearModifier.AffixType> affixType;

        public ModTagGroup(String display, int color, List<VaultGearModifier.AffixType> affixType) {
            this.display = display;
            this.color = color;
            this.affixType = affixType;
        }

        public ModTagGroup addTag(String modGroup) {
            this.tags.add(modGroup);
            return this;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public String getDisplayName() {
            return this.display;
        }

        public int getColor() {
            return this.color;
        }

        public int getWeight() {
            return this.weight;
        }

        public Component getDisplayComponent() {
            return new TextComponent(this.getDisplayName()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)this.getColor())));
        }

        public List<VaultGearModifier.AffixType> getAffixType() {
            return this.affixType;
        }

        public String getJoinedAffix() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.affixType.size(); ++i) {
                VaultGearModifier.AffixType type = this.affixType.get(i);
                sb.append(type.getSingular());
                if (i >= this.affixType.size() - 1) continue;
                sb.append("/");
            }
            return sb.toString();
        }
    }
}

