/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.BooleanFlagGenerator;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.config.DoubleAttributeGenerator;
import iskallia.vault.gear.attribute.config.IntegerAttributeGenerator;
import iskallia.vault.gear.attribute.config.PairAttributeGenerator;
import iskallia.vault.gear.attribute.config.ThroupleAttributeGenerator;
import iskallia.vault.gear.attribute.config.WeightedListAttributeGenerator;
import iskallia.vault.gear.attribute.custom.effect.EffectAvoidanceGearAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectCloudAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectGearAttribute;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.ObjectUtils;

public class VaultGearTierConfig
extends Config {
    public static final String NO_LEGENDARY_TAG = "noLegendary";
    public static final String RESILIENT_FOCUS_REROLL = "resilientFocusTarget";
    public static final ResourceLocation UNIQUE_ITEM = VaultMod.id("unique");
    private ResourceLocation key;
    @Expose
    private final Map<ModifierAffixTagGroup, AttributeGroup> modifierGroup = new LinkedHashMap<ModifierAffixTagGroup, AttributeGroup>();

    public static Map<ResourceLocation, VaultGearTierConfig> registerConfigs() {
        HashMap<ResourceLocation, VaultGearTierConfig> gearConfig = new HashMap<ResourceLocation, VaultGearTierConfig>();
        Stream.of(ModItems.HELMET, ModItems.CHESTPLATE, ModItems.LEGGINGS, ModItems.BOOTS, ModItems.SWORD, ModItems.AXE, ModItems.SHIELD, ModItems.IDOL_BENEVOLENT, ModItems.IDOL_MALEVOLENCE, ModItems.IDOL_OMNISCIENT, ModItems.IDOL_TIMEKEEPER, ModItems.JEWEL, ModItems.MAGNET, ModItems.WAND, ModItems.FOCUS, ModItems.VOID_STONE, ModItems.VAULT_NECKLACE).map(rec$ -> ((ForgeRegistryEntry)rec$).getRegistryName()).forEach(key -> gearConfig.put((ResourceLocation)key, (VaultGearTierConfig)new VaultGearTierConfig((ResourceLocation)key).readConfig()));
        gearConfig.put(UNIQUE_ITEM, (VaultGearTierConfig)new VaultGearTierConfig(UNIQUE_ITEM).readConfig());
        return gearConfig;
    }

    public static Optional<VaultGearTierConfig> getConfig(ItemStack stack) {
        if (!stack.m_41619_() && GearDataCache.of(stack).getRarity() == VaultGearRarity.UNIQUE) {
            return VaultGearTierConfig.getConfig(UNIQUE_ITEM);
        }
        return VaultGearTierConfig.getConfig(stack.m_41720_().getRegistryName());
    }

    static Optional<VaultGearTierConfig> getConfig(ResourceLocation key) {
        return Optional.ofNullable(ModConfigs.VAULT_GEAR_CONFIG.get(key));
    }

    public VaultGearTierConfig(ResourceLocation key) {
        this.key = key;
    }

    public AttributeGroup getModifierGroup(ModifierAffixTagGroup affixTagGroup) {
        return this.modifierGroup.get((Object)affixTagGroup);
    }

    @Override
    public String getName() {
        return "gear_modifiers%s%s".formatted(File.separator, this.key.m_135815_());
    }

    @Nullable
    public Object getTierConfig(VaultGearModifier<?> modifier) {
        for (ModifierTier<?> modTier : this.getAllTiers(modifier.getModifierIdentifier())) {
            if (modTier.getModifierTier() != modifier.getRolledTier()) continue;
            return modTier.getModifierConfiguration();
        }
        return null;
    }

    @Nullable
    @Deprecated(forRemoval=true)
    public ModifierAffixTagGroup getAffixGroup(ModifierTierGroup group) {
        return group.getTargetAffixTagGroup();
    }

    public List<Tuple<ModifierAffixTagGroup, ModifierTierGroup>> getGenericGroupsWithModifierGroup(String group) {
        return this.getGenericGroupsFulfilling(tierGroup -> tierGroup.getModifierGroup().equals(group));
    }

    public List<Tuple<ModifierAffixTagGroup, ModifierTierGroup>> getGenericGroupsWithModifierTag(String modTag) {
        return this.getGenericGroupsFulfilling(group -> group.getTags().contains(modTag));
    }

    public List<Tuple<ModifierAffixTagGroup, ModifierTierGroup>> getGenericGroupsFulfilling(Predicate<ModifierTierGroup> filter) {
        ArrayList<Tuple<ModifierAffixTagGroup, ModifierTierGroup>> configs = new ArrayList<Tuple<ModifierAffixTagGroup, ModifierTierGroup>>();
        for (Map.Entry<ModifierAffixTagGroup, AttributeGroup> entry : this.modifierGroup.entrySet()) {
            if (!entry.getKey().isGenericGroup()) continue;
            for (ModifierTierGroup group : entry.getValue()) {
                if (!filter.test(group)) continue;
                configs.add((Tuple<ModifierAffixTagGroup, ModifierTierGroup>)new Tuple((Object)entry.getKey(), (Object)group));
            }
        }
        return configs;
    }

    public List<Tuple<ModifierAffixTagGroup, ModifierTierGroup>> getAnyGroupsFulfilling(Predicate<ModifierTierGroup> filter) {
        ArrayList<Tuple<ModifierAffixTagGroup, ModifierTierGroup>> configs = new ArrayList<Tuple<ModifierAffixTagGroup, ModifierTierGroup>>();
        for (Map.Entry<ModifierAffixTagGroup, AttributeGroup> entry : this.modifierGroup.entrySet()) {
            for (ModifierTierGroup group : entry.getValue()) {
                if (!filter.test(group)) continue;
                configs.add((Tuple<ModifierAffixTagGroup, ModifierTierGroup>)new Tuple((Object)entry.getKey(), (Object)group));
            }
        }
        return configs;
    }

    @Nonnull
    public ModifierConfigRange getTierConfigRange(VaultGearModifier<?> modifier, int level) {
        Object tier;
        ModifierTierGroup tierGroup;
        Object currentTierCfg = null;
        ModifierTier min = null;
        ModifierTier max = null;
        if (modifier.hasAnyCategoryMatching(VaultGearModifier.AffixCategory::onlyDisplayCurrentTierInformation) && (tierGroup = this.getTierGroup(modifier.getModifierIdentifier())) != null && (tier = tierGroup.getModifierForTier(modifier.getRolledTier())) != null) {
            Object t = ((ModifierTier)tier).getModifierConfiguration();
            return new ModifierConfigRange(t, Lists.newArrayList((Object[])new Object[]{t}), t, t);
        }
        ArrayList<Object> tiers = new ArrayList<Object>();
        for (ModifierTier modifierTier : this.getAllTiers(modifier.getModifierIdentifier())) {
            if (modifierTier.getMinLevel() > level || modifierTier.getMaxLevel() != -1 && modifierTier.getMaxLevel() < level) continue;
            tiers.add(modifierTier.getModifierConfiguration());
            if (modifierTier.getModifierTier() == modifier.getRolledTier()) {
                currentTierCfg = modifierTier.getModifierConfiguration();
            }
            if (min == null || modifierTier.getMinLevel() < min.getMinLevel()) {
                min = modifierTier;
            }
            if (max != null && modifierTier.getMinLevel() <= max.getMinLevel() && max.getMaxLevel() != -1) continue;
            max = modifierTier;
        }
        Object minCfg = min == null ? null : min.getModifierConfiguration();
        Object var8_10 = max == null ? null : max.getModifierConfiguration();
        return new ModifierConfigRange(currentTierCfg, tiers, minCfg, var8_10);
    }

    public Optional<ModifierOutcome<?>> getConfiguredModifierTier(ModifierAffixTagGroup affixTagGroup, ResourceLocation identifier, int modifierTier) {
        if (!this.modifierGroup.containsKey((Object)affixTagGroup)) {
            return Optional.empty();
        }
        ModifierTierGroup group = this.getTierGroup(identifier);
        if (group != null) {
            for (ModifierTier tier : group) {
                if (tier.getModifierTier() != modifierTier) continue;
                return Optional.of(new ModifierOutcome(tier, group));
            }
        }
        return Optional.empty();
    }

    public Optional<VaultGearModifier<?>> createModifier(ModifierAffixTagGroup affixTagGroup, ResourceLocation identifier, int modifierTier, Random random) {
        return this.getConfiguredModifierTier(affixTagGroup, identifier, modifierTier).map(outcome -> outcome.makeModifier(random));
    }

    public List<ModifierTier<?>> getAllTiers(@Nullable ResourceLocation identifier) {
        ModifierTierGroup group = this.getTierGroup(identifier);
        if (group != null) {
            return Collections.unmodifiableList(group);
        }
        return Collections.emptyList();
    }

    @Nullable
    public VaultGearModifier<?> generateModifier(ResourceLocation identifier, int level, Random random) {
        ModifierTierGroup group = this.getTierGroup(identifier);
        if (group != null) {
            WeightedList outcomes = new WeightedList();
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new ModifierOutcome(tier, group), tier.getWeight()));
            return outcomes.getRandom().map(modifierOutcome -> modifierOutcome.makeModifier(random)).orElse(null);
        }
        return null;
    }

    @Nullable
    public VaultGearModifier<?> maxAndIncreaseTier(VaultGearModifier.AffixType type, VaultGearModifier<?> modifier, int level, int tierIncrease, Random random) {
        AttributeGroup attributeGroup = this.modifierGroup.get((Object)ModifierAffixTagGroup.ofAffixType(type));
        if (attributeGroup == null || attributeGroup.isEmpty()) {
            return null;
        }
        ModifierTierGroup tierGroup = this.getTierGroup(modifier.getModifierIdentifier());
        if (tierGroup == null) {
            return null;
        }
        ModifierTier<?> foundTier = tierGroup.getHighestForLevel(level);
        if (foundTier == null) {
            return null;
        }
        int index = Math.min(foundTier.getModifierTier() + tierIncrease, tierGroup.size() - 1);
        return ((ModifierTier)tierGroup.get(index)).makeModifier(tierGroup, random);
    }

    @Nullable
    public ModifierTierGroup getTierGroup(@Nullable ResourceLocation identifier) {
        for (AttributeGroup attributePool : this.modifierGroup.values()) {
            for (ModifierTierGroup group : attributePool) {
                if (!group.identifier.equals((Object)identifier)) continue;
                return group;
            }
        }
        return null;
    }

    public List<VaultGearModifier<?>> generateBaseAttributes(int level, Random random) {
        return this.fullyGenerateAllModifiersOf(ModifierAffixTagGroup.BASE_ATTRIBUTES, level, random);
    }

    public List<VaultGearModifier<?>> generateImplicits(int level, Random random) {
        return this.fullyGenerateAllModifiersOf(ModifierAffixTagGroup.IMPLICIT, level, random);
    }

    private List<VaultGearModifier<?>> fullyGenerateAllModifiersOf(ModifierAffixTagGroup affixTagGroup, int level, Random random) {
        AttributeGroup attributePool = this.modifierGroup.get((Object)affixTagGroup);
        if (attributePool == null || attributePool.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap groupOutcomes = new HashMap();
        attributePool.forEach(group -> {
            String modGrp = Strings.isNullOrEmpty((String)group.getModifierGroup()) ? group.getIdentifier().toString() : group.getModifierGroup();
            group.getModifiersForLevel(level).forEach(tier -> groupOutcomes.computeIfAbsent(modGrp, s -> new WeightedList()).add(new ModifierOutcome(tier, (ModifierTierGroup)group), tier.getWeight()));
        });
        ArrayList modifiers = new ArrayList();
        groupOutcomes.values().forEach(outcomes -> outcomes.getRandom(random).map(outcome -> outcome.makeModifier(random)).ifPresent(modifiers::add));
        return modifiers;
    }

    public Optional<VaultGearModifier<?>> getRandomModifier(VaultGearModifier.AffixType type, int level, Random random, Set<String> excludedModGroups) {
        return this.getRandomModifier(ModifierAffixTagGroup.ofAffixType(type), level, random, excludedModGroups);
    }

    public Optional<VaultGearModifier<?>> getRandomModifier(ModifierAffixTagGroup affixTagGroup, int level, Random random, Set<String> excludedModGroups) {
        AttributeGroup attributePool = this.modifierGroup.get((Object)affixTagGroup);
        if (attributePool == null || attributePool.isEmpty()) {
            return Optional.empty();
        }
        WeightedList outcomes = new WeightedList();
        attributePool.forEach(group -> {
            if (!group.modifierGroup.isEmpty() && excludedModGroups.contains(group.modifierGroup)) {
                return;
            }
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new ModifierOutcome(tier, (ModifierTierGroup)group), tier.getWeight()));
        });
        return outcomes.getRandom().map(modifierOutcome -> modifierOutcome.makeModifier(random));
    }

    @Override
    protected void reset() {
        this.modifierGroup.clear();
        AttributeGroup implicits = new AttributeGroup();
        this.modifierGroup.put(ModifierAffixTagGroup.IMPLICIT, implicits);
        ModifierTierGroup armorTierGroup = new ModifierTierGroup(ModGearAttributes.ARMOR, "ModArmor", "armor");
        armorTierGroup.add(new ModifierTier<IntegerAttributeGenerator.Range>(0, 10, new IntegerAttributeGenerator.Range(1, 2, 1)));
        armorTierGroup.add(new ModifierTier<IntegerAttributeGenerator.Range>(15, 10, new IntegerAttributeGenerator.Range(1, 2, 1)));
        armorTierGroup.add(new ModifierTier<IntegerAttributeGenerator.Range>(25, 10, new IntegerAttributeGenerator.Range(1, 2, 1)));
        ModifierTierGroup attackDamageTierGroup = new ModifierTierGroup(ModGearAttributes.ATTACK_DAMAGE, "ModAttackDamage", "attackdamage");
        attackDamageTierGroup.add(new ModifierTier<DoubleAttributeGenerator.Range>(0, 20, new DoubleAttributeGenerator.Range(1.0, 1.5)));
        attackDamageTierGroup.add(new ModifierTier<DoubleAttributeGenerator.Range>(10, 18, new DoubleAttributeGenerator.Range(1.6, 2.0)));
        attackDamageTierGroup.add(new ModifierTier<DoubleAttributeGenerator.Range>(20, 15, new DoubleAttributeGenerator.Range(2.1, 2.5)));
        ModifierTierGroup effectAvoidTierGroup = new ModifierTierGroup(ModGearAttributes.EFFECT_AVOIDANCE, "ModPoisonAvoidance", "poisonavoidance");
        effectAvoidTierGroup.add(new ModifierTier<EffectAvoidanceGearAttribute.Config>(0, 10, new EffectAvoidanceGearAttribute.Config(MobEffects.f_19614_, 0.1f, 0.2f)));
        effectAvoidTierGroup.add(new ModifierTier<EffectAvoidanceGearAttribute.Config>(15, 10, new EffectAvoidanceGearAttribute.Config(MobEffects.f_19614_, 0.21f, 0.3f)));
        AttributeGroup prefixes = new AttributeGroup();
        prefixes.add(armorTierGroup);
        prefixes.add(attackDamageTierGroup);
        prefixes.add(effectAvoidTierGroup);
        this.modifierGroup.put(ModifierAffixTagGroup.PREFIX, prefixes);
        EffectCloudAttribute.CloudConfig config = new EffectCloudAttribute.CloudConfig("Healing", Potions.f_43623_.getRegistryName(), 40, 4.0f, Color.RED.getRGB(), true, 0.05f);
        config.setAdditionalEffect(new EffectCloudAttribute.CloudEffectConfig(MobEffects.f_19601_.getRegistryName(), 20, 0));
        ModifierTierGroup effectCloudGroup = new ModifierTierGroup(ModGearAttributes.EFFECT_CLOUD, "ModRegenCloud", "regencloud");
        effectCloudGroup.add(new ModifierTier<EffectCloudAttribute.CloudConfig>(0, 10, config));
        ModifierTierGroup effectGroup = new ModifierTierGroup(ModGearAttributes.EFFECT, "ModFireEffect", "fireeffect");
        effectGroup.add(new ModifierTier<EffectGearAttribute.Config>(15, 10, new EffectGearAttribute.Config(MobEffects.f_19607_, 0)));
        ModifierTierGroup fireImmunityGroup = new ModifierTierGroup(ModGearAttributes.IS_FIRE_IMMUNE, "ModFireImmunity", "fireimmunity");
        fireImmunityGroup.add(new ModifierTier<BooleanFlagGenerator.BooleanFlag>(0, 10, new BooleanFlagGenerator.BooleanFlag(true)));
        ModifierTierGroup soulboundGroup = new ModifierTierGroup(ModGearAttributes.SOULBOUND, "ModSoulbound", "soulbound");
        soulboundGroup.add(new ModifierTier<BooleanFlagGenerator.BooleanFlag>(0, 10, new BooleanFlagGenerator.BooleanFlag(true)));
        AttributeGroup suffixes = new AttributeGroup();
        suffixes.add(effectCloudGroup);
        suffixes.add(effectGroup);
        suffixes.add(fireImmunityGroup);
        suffixes.add(soulboundGroup);
        this.modifierGroup.put(ModifierAffixTagGroup.SUFFIX, suffixes);
    }

    @Override
    protected boolean isValid() {
        HashSet<ResourceLocation> foundIdentifiers = new HashSet<ResourceLocation>();
        for (AttributeGroup group : this.modifierGroup.values()) {
            for (ModifierTierGroup tierGroup : group) {
                if (foundIdentifiers.add(tierGroup.identifier)) continue;
                throw new IllegalArgumentException("Invalid Gear configuration (%s) - duplicate identifier found: %s".formatted(this.getName(), tierGroup.identifier.toString()));
            }
        }
        return true;
    }

    @Override
    protected void onLoad(@Nullable Config oldConfigInstance) {
        super.onLoad(oldConfigInstance);
        if (oldConfigInstance instanceof VaultGearTierConfig) {
            VaultGearTierConfig cfg = (VaultGearTierConfig)oldConfigInstance;
            this.key = cfg.key;
        }
        this.modifierGroup.forEach((group, attrGroup) -> attrGroup.forEach(modTierGroup -> {
            modTierGroup.targetAffixTagGroup = group;
        }));
    }

    public static class AttributeGroup
    extends ArrayList<ModifierTierGroup> {

        public static class Serializer
        implements JsonDeserializer<AttributeGroup>,
        JsonSerializer<AttributeGroup> {
            public AttributeGroup deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonArray array = json.getAsJsonArray();
                AttributeGroup attributeGroup = new AttributeGroup();
                array.forEach(tierGroupElement -> {
                    JsonObject tierGroupObject = tierGroupElement.getAsJsonObject();
                    ResourceLocation attributeKey = new ResourceLocation(tierGroupObject.get("attribute").getAsString());
                    VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(attributeKey);
                    if (attribute == null) {
                        throw new JsonParseException("Unknown Modifier %s".formatted(attributeKey));
                    }
                    ResourceLocation identifier = new ResourceLocation(tierGroupObject.get("identifier").getAsString());
                    ModifierTierGroup group = new ModifierTierGroup(attributeKey, tierGroupObject.get("group").getAsString(), identifier);
                    if (tierGroupObject.has("tags")) {
                        group.tags.addAll((Collection)context.deserialize(tierGroupObject.get("tags"), List.class));
                    }
                    JsonArray groupArray = tierGroupObject.getAsJsonArray("tiers");
                    for (int i = 0; i < groupArray.size(); ++i) {
                        JsonObject tierObject = groupArray.get(i).getAsJsonObject();
                        int minLevel = tierObject.get("minLevel").getAsInt();
                        int maxLevel = tierObject.has("maxLevel") ? tierObject.get("maxLevel").getAsInt() : -1;
                        int weight = tierObject.get("weight").getAsInt();
                        ModifierTier tier = new ModifierTier(minLevel, weight);
                        tier.modifierTier = i;
                        tier.maxLevel = maxLevel;
                        Class<?> configClass = attribute.getGenerator().getConfigurationObjectClass();
                        if (configClass != null) {
                            if (tierObject.get("value") instanceof JsonObject) {
                                Object patt21387$temp;
                                Object patt21004$temp;
                                JsonObject configObject = tierObject.getAsJsonObject("value");
                                tier.modifierConfiguration = context.deserialize((JsonElement)configObject, configClass);
                                Object patt20675$temp = tier.modifierConfiguration;
                                if (patt20675$temp instanceof PairAttributeGenerator.Config2) {
                                    PairAttributeGenerator.Config2 cfg = (PairAttributeGenerator.Config2)patt20675$temp;
                                    ConfigurableAttributeGenerator<?, ?> patt20795$temp = attribute.getGenerator();
                                    if (patt20795$temp instanceof PairAttributeGenerator) {
                                        PairAttributeGenerator pairGen = (PairAttributeGenerator)patt20795$temp;
                                        cfg.init(pairGen);
                                    }
                                }
                                if ((patt21004$temp = tier.modifierConfiguration) instanceof ThroupleAttributeGenerator.Config) {
                                    ThroupleAttributeGenerator.Config cfg3 = (ThroupleAttributeGenerator.Config)patt21004$temp;
                                    ConfigurableAttributeGenerator<?, ?> patt21122$temp = attribute.getGenerator();
                                    if (patt21122$temp instanceof ThroupleAttributeGenerator) {
                                        ThroupleAttributeGenerator thrGen = (ThroupleAttributeGenerator)patt21122$temp;
                                        cfg3.init(thrGen);
                                    }
                                }
                                if ((patt21387$temp = tier.modifierConfiguration) instanceof ConfigurableAttributeGenerator.CustomTierConfig) {
                                    ConfigurableAttributeGenerator.CustomTierConfig customCfg = (ConfigurableAttributeGenerator.CustomTierConfig)patt21387$temp;
                                    customCfg.deserializeAdditional(configObject, context);
                                }
                            } else if (tierObject.get("value") instanceof JsonArray) {
                                JsonArray configArray = tierObject.getAsJsonArray("value");
                                if (configClass == WeightedListAttributeGenerator.Config.class) {
                                    JsonObject obj = new JsonObject();
                                    obj.add("strings", (JsonElement)configArray);
                                    tier.modifierConfiguration = context.deserialize((JsonElement)obj, WeightedListAttributeGenerator.Config.class);
                                } else {
                                    throw new JsonParseException("Expected a single configuration object or a weighted list for attribute %s".formatted(attributeKey));
                                }
                            }
                        }
                        group.add(tier);
                    }
                    attributeGroup.add(group);
                });
                return attributeGroup;
            }

            public JsonElement serialize(AttributeGroup src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray array = new JsonArray();
                src.forEach(group -> {
                    VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(group.attribute);
                    if (attribute == null) {
                        return;
                    }
                    JsonObject groupObject = new JsonObject();
                    groupObject.addProperty("attribute", group.attribute.toString());
                    groupObject.addProperty("group", group.modifierGroup);
                    groupObject.addProperty("identifier", group.identifier.toString());
                    groupObject.add("tags", context.serialize(group.tags, List.class));
                    JsonArray groupArray = new JsonArray();
                    group.forEach(modifierTier -> {
                        JsonObject tierObject = new JsonObject();
                        tierObject.addProperty("minLevel", (Number)modifierTier.getMinLevel());
                        tierObject.addProperty("maxLevel", (Number)modifierTier.getMaxLevel());
                        tierObject.addProperty("weight", (Number)modifierTier.getWeight());
                        if (attribute.getGenerator().getConfigurationObjectClass() != null) {
                            Object configuration = modifierTier.getModifierConfiguration();
                            JsonObject configObject = context.serialize(configuration).getAsJsonObject();
                            if (configuration instanceof PairAttributeGenerator.Config2) {
                                PairAttributeGenerator.Config2 cfg = (PairAttributeGenerator.Config2)configuration;
                                ConfigurableAttributeGenerator patt24445$temp = attribute.getGenerator();
                                if (patt24445$temp instanceof PairAttributeGenerator) {
                                    PairAttributeGenerator pairGen = (PairAttributeGenerator)patt24445$temp;
                                    cfg.init(pairGen);
                                }
                            }
                            if (configuration instanceof ThroupleAttributeGenerator.Config) {
                                ThroupleAttributeGenerator.Config cfg3 = (ThroupleAttributeGenerator.Config)configuration;
                                ConfigurableAttributeGenerator patt24761$temp = attribute.getGenerator();
                                if (patt24761$temp instanceof ThroupleAttributeGenerator) {
                                    ThroupleAttributeGenerator thrGen = (ThroupleAttributeGenerator)patt24761$temp;
                                    cfg3.init(thrGen);
                                }
                            }
                            if (configuration instanceof ConfigurableAttributeGenerator.CustomTierConfig) {
                                ConfigurableAttributeGenerator.CustomTierConfig customCfg = (ConfigurableAttributeGenerator.CustomTierConfig)configuration;
                                customCfg.serializeAdditional(configObject, context);
                            }
                            tierObject.add("value", (JsonElement)configObject);
                        }
                        groupArray.add((JsonElement)tierObject);
                    });
                    groupObject.add("tiers", (JsonElement)groupArray);
                    array.add((JsonElement)groupObject);
                });
                return array;
            }
        }
    }

    public static class ModifierTier<T> {
        private final int minLevel;
        private int maxLevel = -1;
        private final int weight;
        private int modifierTier = -1;
        private T modifierConfiguration;

        public ModifierTier(int minLevel, int weight) {
            this(minLevel, weight, null);
        }

        public ModifierTier(int minLevel, int weight, T defaultConfig) {
            this.minLevel = minLevel;
            this.weight = weight;
            this.modifierConfiguration = defaultConfig;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getModifierTier() {
            return this.modifierTier;
        }

        public T getModifierConfiguration() {
            return this.modifierConfiguration;
        }

        public <C> VaultGearModifier<C> makeModifier(ModifierTierGroup tierGroup, Random random) {
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(tierGroup.getAttribute());
            ConfigurableAttributeGenerator<?, ?> generator = attribute.getGenerator();
            Object value = generator.generateRandomValue(this.getModifierConfiguration(), random);
            VaultGearModifier modifier = new VaultGearModifier(attribute, value);
            modifier.setRolledTier(this.getModifierTier());
            modifier.setModifierGroup((String)ObjectUtils.firstNonNull((Object[])new String[]{tierGroup.modifierGroup, ""}));
            modifier.setModifierIdentifier(tierGroup.identifier);
            return modifier;
        }
    }

    public static class ModifierTierGroup
    extends ArrayList<ModifierTier<?>> {
        private final ResourceLocation attribute;
        private final String modifierGroup;
        private final ResourceLocation identifier;
        private final List<String> tags = new ArrayList<String>();
        private ModifierAffixTagGroup targetAffixTagGroup = null;

        public ModifierTierGroup(VaultGearAttribute<?> attribute, String modifierGroup, String identifierStr) {
            this(attribute.getRegistryName(), modifierGroup, VaultMod.id(identifierStr));
        }

        public ModifierTierGroup(ResourceLocation attribute, String modifierGroup, ResourceLocation identifier) {
            this.attribute = attribute;
            this.modifierGroup = modifierGroup;
            this.identifier = identifier;
        }

        public List<ModifierTier<?>> getModifiersForLevel(int level) {
            ArrayList list = new ArrayList();
            for (ModifierTier tier : this) {
                if (tier.getMinLevel() > level || tier.getMaxLevel() != -1 && level > tier.getMaxLevel()) continue;
                list.add(tier);
            }
            return list;
        }

        @Nullable
        public ModifierTier<?> getHighestForLevel(int level) {
            ModifierTier highest = null;
            for (ModifierTier tier : this) {
                if (tier.getMinLevel() > level || highest != null && highest.getMinLevel() >= tier.getMinLevel()) continue;
                highest = tier;
            }
            return highest;
        }

        @Nullable
        public ModifierTier<?> getModifierForTier(int tier) {
            for (ModifierTier modifierTier : this) {
                if (modifierTier.modifierTier != tier) continue;
                return modifierTier;
            }
            return null;
        }

        public ResourceLocation getAttribute() {
            return this.attribute;
        }

        public String getModifierGroup() {
            return this.modifierGroup;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public ResourceLocation getIdentifier() {
            return this.identifier;
        }

        public ModifierAffixTagGroup getTargetAffixTagGroup() {
            return this.targetAffixTagGroup;
        }
    }

    public static enum ModifierAffixTagGroup {
        BASE_ATTRIBUTES(null, AttributeGearData::addAttribute),
        IMPLICIT(VaultGearModifier.AffixType.IMPLICIT, ModifierAffixTagGroup.withTarget(VaultGearModifier.AffixType.IMPLICIT)),
        PREFIX(VaultGearModifier.AffixType.PREFIX, ModifierAffixTagGroup.withTarget(VaultGearModifier.AffixType.PREFIX)),
        SUFFIX(VaultGearModifier.AffixType.SUFFIX, ModifierAffixTagGroup.withTarget(VaultGearModifier.AffixType.SUFFIX)),
        ABILITY_ENHANCEMENT(VaultGearModifier.AffixType.IMPLICIT, ModifierAffixTagGroup.withTarget(VaultGearModifier.AffixType.IMPLICIT)),
        CRAFTED_PREFIX(VaultGearModifier.AffixType.PREFIX, ModifierAffixTagGroup.withTarget(VaultGearModifier.AffixType.PREFIX)),
        CRAFTED_SUFFIX(VaultGearModifier.AffixType.SUFFIX, ModifierAffixTagGroup.withTarget(VaultGearModifier.AffixType.SUFFIX)),
        CORRUPTED_IMPLICIT(VaultGearModifier.AffixType.IMPLICIT, ModifierAffixTagGroup.withTarget(VaultGearModifier.AffixType.IMPLICIT));

        @Nullable
        private final VaultGearModifier.AffixType targetAffixType;
        private final BiPredicate<VaultGearData, VaultGearModifier<?>> applyFn;

        private ModifierAffixTagGroup(VaultGearModifier.AffixType targetAffixType, BiPredicate<VaultGearData, VaultGearModifier<?>> apply) {
            this.targetAffixType = targetAffixType;
            this.applyFn = apply;
        }

        private static BiPredicate<VaultGearData, VaultGearModifier<?>> withTarget(VaultGearModifier.AffixType type) {
            return (data, mod) -> data.addModifier(type, (VaultGearModifier<?>)mod);
        }

        @Nullable
        public VaultGearModifier.AffixType getTargetAffixType() {
            return this.targetAffixType;
        }

        public boolean addModifier(VaultGearData data, VaultGearModifier<?> modifier) {
            return this.applyFn.test(data, modifier);
        }

        public boolean isGenericGroup() {
            return this == IMPLICIT || this == PREFIX || this == SUFFIX;
        }

        @Nonnull
        public static ModifierAffixTagGroup ofAffixType(VaultGearModifier.AffixType type) {
            switch (type) {
                case IMPLICIT: {
                    return IMPLICIT;
                }
                case PREFIX: {
                    return PREFIX;
                }
                case SUFFIX: {
                    return SUFFIX;
                }
            }
            throw new IllegalArgumentException("Unknown AffixType: " + type.name());
        }
    }

    public record ModifierConfigRange(@Nullable Object tierConfig, @Nullable List<Object> allTierConfigs, @Nullable Object minAvailableConfig, @Nullable Object maxAvailableConfig) {
        public static ModifierConfigRange empty() {
            return new ModifierConfigRange(null, null, null, null);
        }
    }

    public record ModifierOutcome<C>(ModifierTier<C> tier, ModifierTierGroup tierGroup) {
        public <T> VaultGearModifier<T> makeModifier(Random random) {
            return this.tier().makeModifier(this.tierGroup(), random);
        }
    }
}

