/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class VaultGearTypePoolConfig
extends Config {
    @Expose
    private final Map<String, LevelEntryList<RollTypeLevel>> pooledOutcomes = new HashMap<String, LevelEntryList<RollTypeLevel>>();

    @Override
    public String getName() {
        return "gear%sgear_roll_type_pools".formatted(File.separator);
    }

    @Nullable
    public String getGearRollType(String pool, int playerLevel, RandomSource random) {
        List rollTypeConfigs = this.pooledOutcomes.get(pool);
        if (rollTypeConfigs == null) {
            return null;
        }
        RollTypeLevel level = this.getForLevel(rollTypeConfigs, playerLevel);
        if (level == null) {
            return null;
        }
        return level.rollTypeOutcomes.getRandom(random).orElse(null);
    }

    @Override
    protected void reset() {
        this.pooledOutcomes.clear();
        RollTypeLevel rollTypeLevel = new RollTypeLevel(0, new WeightedList<String>().add("Scrappy", 1));
        LevelEntryList list = new LevelEntryList();
        list.add(rollTypeLevel);
        this.pooledOutcomes.put("Scaling", list);
    }

    @Nullable
    public RollTypeLevel getForLevel(List<RollTypeLevel> levels, int level) {
        for (int i = 0; i < levels.size(); ++i) {
            if (level < levels.get((int)i).level) {
                if (i == 0) break;
                return levels.get(i - 1);
            }
            if (i != levels.size() - 1) continue;
            return levels.get(i);
        }
        return null;
    }

    public static class RollTypeLevel
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final WeightedList<String> rollTypeOutcomes;

        public RollTypeLevel(int level, WeightedList<String> rollTypeOutcomes) {
            this.level = level;
            this.rollTypeOutcomes = rollTypeOutcomes;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

