/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.gear;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientDiscoveredEntriesData;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.ItemEntry;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.crafting.ModifierWorkbenchHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.DiscoveredWorkbenchModifiersData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class VaultGearWorkbenchConfig
extends Config {
    @Expose
    private final List<ItemEntry> costRemoveCraftedModifiers = new ArrayList<ItemEntry>();
    @Expose
    private final Map<VaultGearModifier.AffixType, List<CraftableModifierConfig>> craftableModifiers = new LinkedHashMap<VaultGearModifier.AffixType, List<CraftableModifierConfig>>();
    private Item gearItem;

    public static Map<Item, VaultGearWorkbenchConfig> registerConfigs() {
        HashMap<Item, VaultGearWorkbenchConfig> gearConfig = new HashMap<Item, VaultGearWorkbenchConfig>();
        List<Item> gearItems = Arrays.asList(ModItems.HELMET, ModItems.CHESTPLATE, ModItems.LEGGINGS, ModItems.BOOTS, ModItems.SWORD, ModItems.AXE, ModItems.SHIELD, ModItems.IDOL_BENEVOLENT, ModItems.IDOL_MALEVOLENCE, ModItems.IDOL_OMNISCIENT, ModItems.IDOL_TIMEKEEPER, ModItems.WAND, ModItems.FOCUS, ModItems.MAGNET);
        for (Item item : gearItems) {
            gearConfig.put(item, (VaultGearWorkbenchConfig)new VaultGearWorkbenchConfig(item).readConfig());
        }
        return gearConfig;
    }

    public static Optional<VaultGearWorkbenchConfig> getConfig(Item item) {
        return Optional.ofNullable(ModConfigs.VAULT_GEAR_WORKBENCH_CONFIG.get(item));
    }

    public VaultGearWorkbenchConfig(Item gearItem) {
        this.gearItem = gearItem;
    }

    public Item getGearItem() {
        return this.gearItem;
    }

    @Override
    public String getName() {
        return "gear_workbench%s%s".formatted(File.separator, this.gearItem.getRegistryName().m_135815_());
    }

    public List<ItemStack> getCostRemoveCraftedModifiers() {
        return this.costRemoveCraftedModifiers.stream().map(ItemEntry::createItemStack).filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
    }

    public List<CraftableModifierConfig> getAllCraftableModifiers() {
        ArrayList<CraftableModifierConfig> all = new ArrayList<CraftableModifierConfig>();
        this.craftableModifiers.values().forEach(all::addAll);
        return all;
    }

    @Nullable
    public CraftableModifierConfig getConfig(ResourceLocation modifierConfigIdentifier) {
        for (List<CraftableModifierConfig> configs : this.craftableModifiers.values()) {
            for (CraftableModifierConfig cfg : configs) {
                if (!cfg.workbenchCraftIdentifier.equals((Object)modifierConfigIdentifier)) continue;
                return cfg;
            }
        }
        return null;
    }

    @Override
    protected void reset() {
        this.costRemoveCraftedModifiers.clear();
        this.costRemoveCraftedModifiers.add(new ItemEntry(new ItemStack((ItemLike)ModItems.NULLIFYING_FOCUS, 5)));
        this.craftableModifiers.clear();
        ArrayList<CraftableModifierConfig> prefixes = new ArrayList<CraftableModifierConfig>();
        ArrayList suffixes = new ArrayList();
        this.craftableModifiers.put(VaultGearModifier.AffixType.PREFIX, prefixes);
        this.craftableModifiers.put(VaultGearModifier.AffixType.SUFFIX, suffixes);
        prefixes.add(new CraftableModifierConfig(VaultMod.id("crafted_armor"), 0, UnlockCategory.LEVEL, new ItemEntry((ItemLike)Items.f_42415_, 5)));
    }

    @Override
    public <T extends Config> T readConfig() {
        VaultGearWorkbenchConfig cfg = (VaultGearWorkbenchConfig)super.readConfig();
        for (CraftableModifierConfig modifierConfig : cfg.craftableModifiers.computeIfAbsent(VaultGearModifier.AffixType.PREFIX, affix -> new ArrayList())) {
            modifierConfig.affixGroup = VaultGearTierConfig.ModifierAffixTagGroup.CRAFTED_PREFIX;
            modifierConfig.gearItem = cfg.gearItem;
        }
        for (CraftableModifierConfig modifierConfig : cfg.craftableModifiers.computeIfAbsent(VaultGearModifier.AffixType.SUFFIX, affix -> new ArrayList())) {
            modifierConfig.affixGroup = VaultGearTierConfig.ModifierAffixTagGroup.CRAFTED_SUFFIX;
            modifierConfig.gearItem = cfg.gearItem;
        }
        return (T)cfg;
    }

    @Override
    protected void onLoad(@Nullable Config oldConfigInstance) {
        super.onLoad(oldConfigInstance);
        if (oldConfigInstance instanceof VaultGearWorkbenchConfig) {
            VaultGearWorkbenchConfig cfg = (VaultGearWorkbenchConfig)oldConfigInstance;
            this.gearItem = cfg.gearItem;
        }
    }

    @Override
    protected boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        HashSet<ResourceLocation> foundIdentifiers = new HashSet<ResourceLocation>();
        for (List<CraftableModifierConfig> configs : this.craftableModifiers.values()) {
            for (CraftableModifierConfig cfg : configs) {
                if (foundIdentifiers.add(cfg.workbenchCraftIdentifier)) continue;
                throw new IllegalArgumentException("Invalid Gear Workbench configuration (%s) - duplicate identifier found: %s".formatted(this.getName(), cfg.workbenchCraftIdentifier));
            }
        }
        return true;
    }

    public static class CraftableModifierConfig {
        @Expose
        private final ResourceLocation workbenchCraftIdentifier;
        @Expose
        private final ResourceLocation modifierIdentifier;
        @Expose
        private final int modifierTier;
        @Expose
        private final UnlockCategory unlockCategory;
        @Expose
        private final List<ItemEntry> craftingCost;
        private VaultGearTierConfig.ModifierAffixTagGroup affixGroup;
        private Item gearItem;

        public CraftableModifierConfig(ResourceLocation modifierIdentifier, int modifierTier, UnlockCategory unlockCategory, ItemEntry ... craftingCost) {
            this(VaultMod.id(modifierIdentifier.m_135815_() + "_t" + modifierTier), modifierIdentifier, modifierTier, unlockCategory, Arrays.asList(craftingCost));
        }

        public CraftableModifierConfig(ResourceLocation workbenchCraftIdentifier, ResourceLocation modifierIdentifier, int modifierTier, UnlockCategory unlockCategory, List<ItemEntry> craftingCost) {
            this.workbenchCraftIdentifier = workbenchCraftIdentifier;
            this.modifierIdentifier = modifierIdentifier;
            this.modifierTier = modifierTier;
            this.unlockCategory = unlockCategory;
            this.craftingCost = craftingCost;
        }

        public int getModifierTier() {
            return this.modifierTier;
        }

        public boolean hasPrerequisites(Player player) {
            int level = this.getMinLevel();
            if (level == Integer.MIN_VALUE) {
                return false;
            }
            switch (this.unlockCategory) {
                case LEVEL: {
                    return SidedHelper.getVaultLevel(player) >= level;
                }
                case VAULT_DISCOVERY: {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sPlayer = (ServerPlayer)player;
                        DiscoveredWorkbenchModifiersData data = DiscoveredWorkbenchModifiersData.get(sPlayer.m_183503_());
                        return data.hasDiscoveredCraft(player, this.gearItem, this.workbenchCraftIdentifier);
                    }
                    return ClientDiscoveredEntriesData.WorkbenchCrafts.getDiscoveredWorkbenchCrafts(this.gearItem).contains(this.workbenchCraftIdentifier);
                }
            }
            return false;
        }

        public List<ItemEntry> getCraftingCost() {
            return this.craftingCost;
        }

        public List<ItemStack> createCraftingCost(ItemStack input) {
            if (input.m_41619_()) {
                return Collections.emptyList();
            }
            List<ItemStack> inputs = this.getCraftingCost().stream().map(ItemEntry::createItemStack).filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
            if (ModifierWorkbenchHelper.hasCraftedModifier(input)) {
                VaultGearWorkbenchConfig.getConfig(input.m_41720_()).map(VaultGearWorkbenchConfig::getCostRemoveCraftedModifiers).ifPresent(inputs::addAll);
            }
            return inputs;
        }

        public UnlockCategory getUnlockCategory() {
            return this.unlockCategory;
        }

        public VaultGearTierConfig.ModifierAffixTagGroup getAffixGroup() {
            return this.affixGroup;
        }

        public ResourceLocation getWorkbenchCraftIdentifier() {
            return this.workbenchCraftIdentifier;
        }

        public ResourceLocation getModifierIdentifier() {
            return this.modifierIdentifier;
        }

        public Optional<VaultGearModifier<?>> createModifier() {
            return VaultGearTierConfig.getConfig(this.gearItem.getRegistryName()).flatMap(cfg -> cfg.createModifier(this.affixGroup, this.modifierIdentifier, this.modifierTier, Config.rand));
        }

        public int getMinLevel() {
            return VaultGearTierConfig.getConfig(this.gearItem.getRegistryName()).flatMap(cfg -> cfg.getConfiguredModifierTier(this.affixGroup, this.modifierIdentifier, this.modifierTier)).map(VaultGearTierConfig.ModifierOutcome::tier).map(VaultGearTierConfig.ModifierTier::getMinLevel).orElse(Integer.MIN_VALUE);
        }
    }

    public static enum UnlockCategory {
        LEVEL("Requires Level %s"),
        VAULT_DISCOVERY("Requires discovery in the Modifier Archives");

        private final String display;

        private UnlockCategory(String display) {
            this.display = display;
        }

        public String formatDisplay(Object ... args) {
            return this.display.formatted(args);
        }
    }
}

