/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.block.entity.CompanionHomeTileEntity;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionParticleTrailItem;
import iskallia.vault.item.CompanionRelicItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompanionHomeContainer
extends AbstractContainerMenu {
    private static final int RELIC_SLOTS = 4;
    private static final int COSMETIC_SLOTS = 3;
    private final Level level;
    private final BlockPos pos;
    private final SimpleContainer relicInventory = new SimpleContainer(4);
    private final SimpleContainer trailInventory = new SimpleContainer(3);
    private final ItemStack companionStack;

    public CompanionHomeContainer(int id, Level level, BlockPos pos, Inventory inv) {
        super(ModContainers.COMPANION_HOME_CONTAINER, id);
        this.level = level;
        this.pos = pos;
        ItemStack initialStack = CompanionHomeContainer.getStack(level, pos);
        if (!initialStack.m_41619_()) {
            CompanionItem.migrateFromWorldData(initialStack);
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof CompanionHomeTileEntity) {
                CompanionHomeTileEntity home = (CompanionHomeTileEntity)be;
                ItemStack migratedCopy = initialStack.m_41777_();
                home.setCompanion(migratedCopy);
            }
        }
        this.companionStack = CompanionHomeContainer.getStack(level, pos);
        if (this.companionStack.m_41720_() instanceof CompanionItem) {
            int i = 0;
            while (i < this.relicInventory.m_6643_()) {
                int slot = i++;
                CompanionItem.getRelic(this.companionStack, slot).ifPresent(mods -> this.relicInventory.m_6836_(slot, CompanionRelicItem.create((Pair<Integer, List<ResourceLocation>>)mods)));
            }
            for (i = 0; i < this.trailInventory.m_6643_(); ++i) {
                CompanionParticleTrailItem.TrailType type;
                int colour = CompanionItem.getCosmeticColour(this.companionStack, i);
                if (colour == -1 || (type = CompanionItem.getCosmeticTrailType(this.companionStack, i)) == null) continue;
                this.trailInventory.m_6836_(i, CompanionParticleTrailItem.create(colour, type));
            }
        }
        this.buildSlots(inv.f_35978_);
    }

    public CompanionHomeContainer(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv.f_35978_.f_19853_, buf.m_130135_(), inv);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!(slot instanceof RelicSlot)) {
            ItemStack itemstack = ItemStack.f_41583_;
            if (slot != null && slot.m_6657_()) {
                ItemStack itemstack1 = slot.m_7993_();
                itemstack = itemstack1.m_41777_();
                int containerSlots = 7;
                if (index < containerSlots) {
                    if (!this.m_38903_(itemstack1, containerSlots, this.f_38839_.size(), true)) {
                        return ItemStack.f_41583_;
                    }
                } else if (itemstack1.m_41720_() instanceof CompanionRelicItem) {
                    if (!this.m_38903_(itemstack1, 0, 4, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (itemstack1.m_41720_() instanceof CompanionParticleTrailItem) {
                    if (!this.m_38903_(itemstack1, 4, containerSlots, false)) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    return ItemStack.f_41583_;
                }
                if (itemstack1.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
            }
            return itemstack;
        }
        RelicSlot relicSlot = (RelicSlot)slot;
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    private void buildSlots(Player player) {
        int startX = 8;
        int startY = 50;
        for (int row = 0; row < 4; ++row) {
            this.m_38897_(new RelicSlot(this.relicInventory, row, 8, 19 + row * 18));
        }
        int cosmeticY = startY + 36 + 3;
        for (int i = 0; i < 3; ++i) {
            this.m_38897_(new TrailSlot(this.trailInventory, i, 80, 1 + (i + 2) * 18));
        }
        int invX = 8;
        int invY = 103;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)player.m_150109_(), col + row * 9 + 9, invX + col * 18, invY + row * 18));
            }
        }
        for (int h = 0; h < 9; ++h) {
            this.m_38897_(new Slot((Container)player.m_150109_(), h, invX + h * 18, invY + 58));
        }
    }

    private static ItemStack getStack(Level level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof CompanionHomeTileEntity) {
            CompanionHomeTileEntity home = (CompanionHomeTileEntity)be;
            return home.getCompanion();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getCompanionStack() {
        return this.companionStack;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean m_6875_(@NotNull Player player) {
        BlockEntity be = this.level.m_7702_(this.pos);
        if (!(be instanceof CompanionHomeTileEntity)) {
            return false;
        }
        CompanionHomeTileEntity home = (CompanionHomeTileEntity)be;
        if (!ItemStack.m_41728_((ItemStack)home.getCompanion(), (ItemStack)this.getCompanionStack())) {
            return false;
        }
        return player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0;
    }

    public class RelicSlot
    extends Slot {
        private final int relicIndex;

        public RelicSlot(SimpleContainer inv, int index, int x, int y) {
            super((Container)inv, index, x, y);
            this.relicIndex = index;
        }

        public boolean isUnlocked() {
            return CompanionHomeContainer.this.companionStack.m_41720_() instanceof CompanionItem && this.relicIndex < CompanionItem.getRelicSlots(CompanionHomeContainer.this.companionStack);
        }

        public boolean m_5857_(ItemStack stack) {
            return this.isUnlocked() && stack.m_41720_() instanceof CompanionRelicItem && !this.m_6657_() && CompanionItem.getCompanionHearts(CompanionHomeContainer.this.companionStack) > 0;
        }

        public boolean m_8010_(Player player) {
            return this.isUnlocked() && player.m_6144_();
        }

        public void m_6654_() {
            super.m_6654_();
            if (!(CompanionHomeContainer.this.companionStack.m_41720_() instanceof CompanionItem)) {
                return;
            }
            ItemStack stack = this.m_7993_();
            if (stack.m_41619_()) {
                CompanionItem.setRelic(CompanionHomeContainer.this.companionStack, this.relicIndex, 0, Collections.emptyList());
            } else {
                List<ResourceLocation> mods = CompanionRelicItem.getModifiers(stack);
                CompanionItem.setRelic(CompanionHomeContainer.this.companionStack, this.relicIndex, CompanionRelicItem.getModel(stack), mods);
            }
        }

        public List<Component> getUnlockTooltip() {
            int level = switch (this.relicIndex) {
                case 0 -> 2;
                case 1 -> 5;
                case 2 -> 8;
                default -> 10;
            };
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)new TextComponent("Locked Relic Slot").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)new TextComponent("Unlocks at level " + level).m_130940_(ChatFormatting.GRAY));
            return tooltip;
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            if (!this.isUnlocked()) {
                return null;
            }
            return Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.COMPANION_RELIC_SLOTS);
        }
    }

    public class TrailSlot
    extends Slot {
        private final int trailIndex;

        public TrailSlot(SimpleContainer inv, int index, int x, int y) {
            super((Container)inv, index, x, y);
            this.trailIndex = index;
        }

        public boolean isUnlocked() {
            return CompanionHomeContainer.this.companionStack.m_41720_() instanceof CompanionItem && this.trailIndex < CompanionItem.getCosmeticSlots(CompanionHomeContainer.this.companionStack);
        }

        public boolean m_5857_(ItemStack stack) {
            return this.isUnlocked() && stack.m_41720_() instanceof CompanionParticleTrailItem && !this.m_6657_() && CompanionItem.getCompanionHearts(CompanionHomeContainer.this.companionStack) > 0;
        }

        public void m_6654_() {
            super.m_6654_();
            if (!(CompanionHomeContainer.this.companionStack.m_41720_() instanceof CompanionItem)) {
                return;
            }
            ItemStack stack = this.m_7993_();
            if (stack.m_41619_()) {
                CompanionItem.setCosmeticColour(CompanionHomeContainer.this.companionStack, this.trailIndex, -1);
                CompanionItem.setCosmeticTrailType(CompanionHomeContainer.this.companionStack, this.trailIndex, null);
            } else {
                CompanionItem.setCosmeticColour(CompanionHomeContainer.this.companionStack, this.trailIndex, CompanionParticleTrailItem.getColour(stack));
                CompanionItem.setCosmeticTrailType(CompanionHomeContainer.this.companionStack, this.trailIndex, CompanionParticleTrailItem.getType(stack));
            }
        }

        public List<Component> getUnlockTooltip() {
            int level = switch (this.trailIndex) {
                case 0 -> 3;
                case 1 -> 6;
                default -> 10;
            };
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)new TextComponent("Locked Particle Slot").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)new TextComponent("Unlocks at level " + level).m_130940_(ChatFormatting.GRAY));
            return tooltip;
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            if (!this.isUnlocked()) {
                return null;
            }
            return Pair.of((Object)InventoryMenu.f_39692_, (Object)ModSlotIcons.COMPANION_TRAIL_NO_ITEM);
        }
    }

    public static class Provider
    implements MenuProvider {
        private final BlockPos pos;

        public Provider(BlockPos pos) {
            this.pos = pos;
        }

        public Component m_5446_() {
            return new TextComponent("Companion Home");
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
            return new CompanionHomeContainer(id, player.f_19853_, this.pos, inv);
        }
    }
}

