/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.CrystalWorkbenchTileEntity;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.item.AugmentItem;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.item.InscriptionItem;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.gear.CharmItem;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CrystalWorkbenchContainer
extends OverSizedSlotContainer {
    private final CrystalWorkbenchTileEntity entity;
    private final BlockPos pos;

    public CrystalWorkbenchContainer(int windowId, Level world, BlockPos pos, Player player) {
        super(ModContainers.CRYSTAL_MODIFICATION_STATION_CONTAINER, windowId, player);
        this.pos = pos;
        BlockEntity blockEntity = world.m_7702_(this.pos);
        if (!(blockEntity instanceof CrystalWorkbenchTileEntity)) {
            this.entity = null;
            return;
        }
        CrystalWorkbenchTileEntity entity = (CrystalWorkbenchTileEntity)blockEntity;
        this.entity = entity;
        this.entity.onOpen(player);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)player.m_150109_(), column + row * 9 + 9, 58 + column * 18, 108 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)player.m_150109_(), hotbarSlot, 58 + hotbarSlot * 18, 166));
        }
        this.m_38897_(new TabSlot(this.entity.getInput(), 0, 120, 73){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof VaultCrystalItem && !CrystalData.read(stack).getProperties().isUnmodifiable();
            }
        });
        for (int y = 0; y < 20; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.m_38897_(new TabSlot(this.entity.getIngredients(), y * 3 + x, -999 + x * 18, 50 + y * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return stack.m_41720_() instanceof InfusedCatalystItem || stack.m_41720_() instanceof InscriptionItem || stack.m_41720_() instanceof CharmItem;
                    }
                });
            }
        }
        for (int slotIndex = 0; slotIndex < 3; ++slotIndex) {
            final int finalSlotIndex = slotIndex;
            this.m_38897_(new TabSlot(this.entity.getUniqueIngredients(), finalSlotIndex, 112 + slotIndex * 18, -1){

                public boolean m_5857_(ItemStack stack) {
                    if (finalSlotIndex == 0) {
                        return stack.m_204117_(ModItems.CRYSTAL_SEALS_TAG);
                    }
                    if (finalSlotIndex == 1) {
                        return stack.m_41720_() instanceof AugmentItem;
                    }
                    return stack.m_204117_(ModItems.CRYSTAL_CAPSTONES_TAG);
                }
            }.setBackground(InventoryMenu.f_39692_, this.getUniqueSlotBackground(slotIndex)));
        }
    }

    private ResourceLocation getUniqueSlotBackground(int index) {
        switch (index) {
            case 0: {
                return ModSlotIcons.SEAL_NO_ITEM;
            }
            case 1: {
                return ModSlotIcons.AUGMENT_NO_ITEM;
            }
        }
        return ModSlotIcons.CAPSTONE_NO_ITEM;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public CrystalWorkbenchTileEntity getEntity() {
        return this.entity;
    }

    public int getFirstCursedIngredient() {
        return this.entity.getFirstCursedIngredient();
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack copy = stack.m_41777_();
        if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(stack, slot, 36, this.f_38839_.size(), false)) {
            return copy;
        }
        if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(stack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(stack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(stack, slot, 0, 36, false))) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41613_() == 0) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == copy.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return copy;
    }

    public boolean m_6875_(Player player) {
        return this.entity != null && this.entity.stillValid(this.player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.entity.onClose(player);
    }
}

