/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.init.ModContainers;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.world.data.PersonalVaultData;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PersonalVaultCatalystContainer
extends OverSizedSlotContainer {
    public static final int GRID_COLS = 9;
    public static final int GRID_ROWS = 7;
    public static final int TOTAL_SLOTS = 63;
    private static final int GRID_START_Y = 18;
    private static final int GRID_START_X = 8;
    private final UUID playerId;
    private final PersonalVaultData.Entry dataEntry;
    private final OverSizedInventory gridInv;
    private final BlockPos pos;

    public PersonalVaultCatalystContainer(int windowId, Player player, BlockPos pos) {
        super(ModContainers.PERSONAL_VAULT_CATALYST_CONTAINER, windowId, player);
        this.playerId = player.m_142081_();
        this.dataEntry = PersonalVaultData.getEntry(this.playerId);
        this.gridInv = new OverSizedInventory(63, stacks -> {}, p -> true);
        this.pos = pos;
        this.initialiseInventoryFromData();
        this.buildGridSlots();
        this.addPlayerInventorySlots(player);
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    private void initialiseInventoryFromData() {
        for (int s = 0; s < 63; ++s) {
            ItemStack stack = this.dataEntry.getInfusedCatalyst(s);
            this.gridInv.m_6836_(s, stack);
        }
    }

    private void buildGridSlots() {
        for (int row = 0; row < 7; ++row) {
            for (int col = 0; col < 9; ++col) {
                int idx = row * 9 + col;
                this.m_38897_(new CatalystSlot(this.gridInv, idx, 8 + col * 18, 18 + row * 18));
            }
        }
    }

    private void addPlayerInventorySlots(Player player) {
        int invX = 8;
        int invY = 158;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new TabSlot((Container)player.m_150109_(), col + row * 9 + 9, invX + col * 18, invY + row * 18));
            }
        }
        for (int h = 0; h < 9; ++h) {
            this.m_38897_(new TabSlot((Container)player.m_150109_(), h, invX + h * 18, invY + 58));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack resultCopy = stackInSlot.m_41777_();
        if (index < 63) {
            if (!this.moveOverSizedItemStackTo(stackInSlot, slot, 63, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (!InfusedCatalystItem.isSuper(stackInSlot)) {
                return ItemStack.f_41583_;
            }
            OptionalInt targetSlot = this.findFirstEmptySlot();
            if (targetSlot.isEmpty()) {
                return ItemStack.f_41583_;
            }
            int slotIndex = targetSlot.getAsInt();
            if (!this.moveOverSizedItemStackTo(stackInSlot, slot, slotIndex, slotIndex + 1, false)) {
                return ItemStack.f_41583_;
            }
        }
        if (stackInSlot.m_41613_() == resultCopy.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        slot.m_6654_();
        return resultCopy;
    }

    private OptionalInt findFirstEmptySlot() {
        for (int i = 0; i < 63; ++i) {
            if (!this.gridInv.m_8020_(i).m_41619_()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private class CatalystSlot
    extends TabSlot {
        private final int catalystSlot;

        CatalystSlot(OverSizedInventory inv, int index, int x, int y) {
            super(inv, index, x, y);
            this.catalystSlot = index;
        }

        public boolean m_5857_(ItemStack stack) {
            return !stack.m_41619_() && InfusedCatalystItem.isSuper(stack);
        }

        public void m_6654_() {
            super.m_6654_();
            ItemStack current = this.m_7993_();
            if (current.m_41619_()) {
                PersonalVaultCatalystContainer.this.dataEntry.removeInfusedCatalyst(this.catalystSlot);
            } else if (InfusedCatalystItem.isSuper(current)) {
                PersonalVaultCatalystContainer.this.dataEntry.placeInfusedCatalyst(this.catalystSlot, current.m_41777_());
            }
        }

        public int m_5866_(ItemStack stack) {
            return 1;
        }
    }
}

