/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.config.PersonalVaultConfig;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.CoinPouchItem;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.world.data.PersonalVaultData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PersonalVaultContainer
extends OverSizedSlotContainer {
    public static final int GRID_SIZE = 9;
    public static final int TOTAL_SLOTS = 81;
    private static final int VISIBLE_ROWS = 7;
    private static final int GRID_START_Y = 18;
    private static Field slotYField;
    private final UUID playerId;
    private final PersonalVaultData.Entry dataEntry;
    private final OverSizedInventory gridInv;
    private int startRow = 0;
    protected final BlockPos pos;

    public PersonalVaultContainer(int windowId, Player player, BlockPos pos) {
        super(ModContainers.PERSONAL_VAULT_CONTAINER, windowId, player);
        this.playerId = player.m_142081_();
        this.dataEntry = PersonalVaultData.getEntry(this.playerId);
        this.gridInv = new OverSizedInventory(81, stacks -> {}, p -> true);
        this.pos = pos;
        this.initialiseInventoryFromData();
        this.buildGridSlots();
        this.scrollTo(0);
        this.addPlayerInventorySlots(player);
    }

    private void initialiseInventoryFromData() {
        for (int s = 0; s < 81; ++s) {
            ItemStack stack = ItemStack.f_41583_;
            switch (this.dataEntry.getSlotStatus(s)) {
                case ROCK: {
                    stack = new ItemStack((ItemLike)ModItems.VAULT_ROCK);
                    break;
                }
                case FILLED: {
                    stack = this.dataEntry.getSlotItems().getOrDefault(s, ItemStack.f_41583_);
                    break;
                }
                case UNLOCKED: {
                    stack = ItemStack.f_41583_;
                }
            }
            this.gridInv.m_6836_(s, stack);
        }
    }

    public OverSizedInventory getGridInventory() {
        return this.gridInv;
    }

    private void buildGridSlots() {
        int startX = 8;
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                int idx = row * 9 + col;
                this.m_38897_(new DataSlot(this.gridInv, idx, startX + col * 18, 18 + row * 18));
            }
        }
    }

    public void scrollTo(int row) {
        this.startRow = Mth.m_14045_((int)row, (int)0, (int)2);
        for (int i = 0; i < 81; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            int rel = i / 9 - this.startRow;
            int newY = rel >= 0 && rel < 7 ? 18 + rel * 18 : -2000;
            try {
                slotYField.setInt(slot, newY);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void centerOnSlot(int slotIndex) {
        int row = slotIndex / 9;
        int half = 3;
        this.scrollTo(row - half);
    }

    private void addPlayerInventorySlots(Player player) {
        int invX = 8;
        int invY = 158;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new TabSlot((Container)player.m_150109_(), col + row * 9 + 9, invX + col * 18, invY + row * 18));
            }
        }
        for (int h = 0; h < 9; ++h) {
            this.m_38897_(new TabSlot((Container)player.m_150109_(), h, invX + h * 18, invY + 58));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack resultCopy = stackInSlot.m_41777_();
        if (index < 81) {
            if (!this.moveOverSizedItemStackTo(stackInSlot, slot, 81, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (!InscriptionData.from(stackInSlot).isSuper()) {
                return ItemStack.f_41583_;
            }
            OptionalInt target = this.dataEntry.findFirstValidSlot();
            if (target.isEmpty()) {
                return ItemStack.f_41583_;
            }
            int slotIndex = target.getAsInt();
            if (!this.moveOverSizedItemStackTo(stackInSlot, slot, slotIndex, slotIndex + 1, false)) {
                return ItemStack.f_41583_;
            }
        }
        if (stackInSlot.m_41613_() == resultCopy.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        slot.m_6654_();
        return resultCopy;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    static {
        for (Field f : Slot.class.getDeclaredFields()) {
            if (f.getType() != Integer.TYPE) continue;
            f.setAccessible(true);
            slotYField = f;
        }
    }

    public class DataSlot
    extends TabSlot {
        public final int pvSlot;

        DataSlot(OverSizedInventory inv, int index, int x, int y) {
            super(inv, index, x, y);
            this.pvSlot = index;
        }

        public boolean locked() {
            return switch (PersonalVaultContainer.this.dataEntry.getSlotStatus(this.pvSlot)) {
                case PersonalVaultData.Entry.SlotStatus.ROCK, PersonalVaultData.Entry.SlotStatus.LOCKED -> true;
                default -> false;
            };
        }

        public PersonalVaultData.Entry.SlotStatus getSlotStatus() {
            return PersonalVaultData.getEntry(PersonalVaultContainer.this.playerId).getSlotStatus(this.pvSlot);
        }

        private boolean isSuper(ItemStack stack) {
            return !stack.m_41619_() && InscriptionData.from(stack).isSuper();
        }

        public boolean m_5857_(ItemStack stack) {
            if (stack.m_41619_() || !InscriptionData.from(stack).isSuper()) {
                return false;
            }
            return PersonalVaultContainer.this.dataEntry.getSlotStatus(this.pvSlot) == PersonalVaultData.Entry.SlotStatus.UNLOCKED && PersonalVaultContainer.this.dataEntry.hasAdjacentRoomOrRock(this.pvSlot);
        }

        public boolean m_8010_(Player player) {
            if (this.locked()) {
                return false;
            }
            return this.isSuper(this.m_7993_());
        }

        public void m_6654_() {
            super.m_6654_();
            ItemStack current = this.m_7993_();
            if (current.m_41619_()) {
                PersonalVaultContainer.this.dataEntry.removeInscription(this.pvSlot);
            } else if (this.isSuper(current)) {
                PersonalVaultContainer.this.dataEntry.placeInscription(this.pvSlot, current.m_41777_());
            }
        }

        public int m_5866_(ItemStack stack) {
            return 1;
        }

        public List<Component> getTooltip() {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            int ring = PersonalVaultData.Entry.getRing(this.pvSlot);
            if (ring > 0) {
                PersonalVaultConfig config = ModConfigs.PERSONAL_VAULT;
                PersonalVaultConfig.RingCost ringCost = config.getRingCost(ring);
                if (ringCost == null) {
                    return tooltip;
                }
                int prestigePoints = ringCost.getPrestigePointCost();
                int vaultGold = ringCost.getVaultGoldCost();
                boolean hasEnoughPoints = VaultBarOverlay.unspentPrestigePoints >= prestigePoints;
                boolean hasEnoughGold = true;
                if (vaultGold > 0) {
                    int userGold = CoinPouchItem.getGoldAmount(Minecraft.m_91087_().f_91074_.m_150109_());
                    hasEnoughGold = userGold >= vaultGold;
                }
                boolean canUnlock = false;
                if (PersonalVaultData.CLIENT.getOrCreate(Minecraft.m_91087_().f_91074_.m_142081_()).canUnlockSlot(this.pvSlot)) {
                    canUnlock = true;
                }
                if (hasEnoughPoints && hasEnoughGold && canUnlock) {
                    tooltip.add((Component)new TextComponent("Click to unlock").m_130940_(ChatFormatting.GREEN));
                } else {
                    tooltip.add((Component)new TextComponent("Locked Slot").m_130940_(ChatFormatting.RED));
                }
                tooltip.add(TextComponent.f_131282_);
                if (prestigePoints > 0) {
                    tooltip.add((Component)new TextComponent("\u2022 " + prestigePoints + "x Prestige Point" + (prestigePoints > 1 ? "s" : "")).m_130940_(hasEnoughPoints ? ChatFormatting.GREEN : ChatFormatting.RED));
                }
                if (vaultGold > 0) {
                    tooltip.add((Component)new TextComponent("\u2022 " + vaultGold + "x Vault Gold").m_130940_(hasEnoughGold ? ChatFormatting.GREEN : ChatFormatting.RED));
                }
                if (!canUnlock) {
                    tooltip.add((Component)new TextComponent("Unlock an adjacent slot first").m_130940_(ChatFormatting.RED));
                }
            } else {
                tooltip.add((Component)new TextComponent("Locked Slot").m_130940_(ChatFormatting.RED));
            }
            return tooltip;
        }
    }
}

