/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.PersonalVaultTileEntity;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.slot.RecipeOutputSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.world.data.PersonalVaultData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PersonalVaultCraftingContainer
extends OverSizedSlotContainer {
    private final UUID playerId;
    private final PersonalVaultData.Entry dataEntry;
    private final PersonalVaultTileEntity tileEntity;
    protected final BlockPos pos;

    public PersonalVaultCraftingContainer(int windowId, Player player, BlockPos pos) {
        super(ModContainers.PERSONAL_VAULT_CRAFTING_CONTAINER, windowId, player);
        this.playerId = player.m_142081_();
        this.dataEntry = PersonalVaultData.getEntry(this.playerId);
        this.pos = pos;
        BlockEntity tile = player.f_19853_.m_7702_(pos);
        if (tile instanceof PersonalVaultTileEntity) {
            PersonalVaultTileEntity te;
            this.tileEntity = te = (PersonalVaultTileEntity)tile;
            this.addPlayerInventorySlots(player);
            this.addCraftingSlots();
        } else {
            this.tileEntity = null;
        }
    }

    private void addPlayerInventorySlots(Player player) {
        int invX = 8;
        int invY = 158;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new TabSlot((Container)player.m_150109_(), col + row * 9 + 9, invX + col * 18, invY + row * 18));
            }
        }
        for (int h = 0; h < 9; ++h) {
            this.m_38897_(new TabSlot((Container)player.m_150109_(), h, invX + h * 18, invY + 58));
        }
    }

    private void addCraftingSlots() {
        OverSizedInventory invContainer = this.tileEntity.getInventory();
        for (int invSlot = 0; invSlot < invContainer.m_6643_(); ++invSlot) {
            int x = 20 + invSlot / 3 * 18;
            int y = 51 + invSlot % 3 * 18;
            OverSizedTabSlot slot = new OverSizedTabSlot(invContainer, invSlot, x, y);
            if (invSlot == 0) {
                slot.setBackground(InventoryMenu.f_39692_, ModSlotIcons.COINS_NO_ITEM);
                slot.setFilter(stack -> stack.m_41720_() == ModBlocks.VAULT_GOLD);
            } else if (invSlot == 1) {
                slot.setBackground(InventoryMenu.f_39692_, ModSlotIcons.COINS_NO_ITEM);
                slot.setFilter(stack -> stack.m_41720_() == ModItems.ECHO_GEM);
            }
            this.m_38897_(slot);
        }
        int slotWidth = Mth.m_14167_((float)((float)invContainer.m_6643_() / 3.0f));
        this.m_38897_(new RecipeOutputSlot((Container)this.tileEntity.getResultContainer(), 0, 20 + slotWidth * 18 + 100, 60));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size(), false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        if (this.tileEntity == null) {
            return false;
        }
        return this.tileEntity.craftingInventoryStillValid(player);
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public PersonalVaultTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public static List<ItemStack> getRecipe(Player player) {
        int unlockedSlots = 0;
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            unlockedSlots = PersonalVaultData.get(splayer.m_183503_()).getOrCreate(splayer.m_142081_()).getUnlockedSlots();
        } else {
            unlockedSlots = PersonalVaultData.CLIENT.getOrCreate(player.m_142081_()).getUnlockedSlots();
        }
        final int finalUnlockedSlots = unlockedSlots;
        return new ArrayList<ItemStack>(){
            {
                this.add(new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, 2 * finalUnlockedSlots));
                this.add(new ItemStack((ItemLike)ModItems.ECHO_GEM, 4));
            }
        };
    }

    public Slot getResultSlot() {
        return this.f_38839_.stream().filter(slot -> slot instanceof RecipeOutputSlot).findFirst().orElseGet(() -> this.m_38853_(this.f_38839_.size() - 1));
    }
}

