/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.RoyaleDrafterControllerTileEntity;
import iskallia.vault.config.RoyalePresetConfig;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.gear.TrinketItem;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RoyaleDraftContainer
extends AbstractElementContainer {
    private final int entityId;
    private final Map<String, Map<String, Integer>> skillPreset;
    private final List<ResourceLocation> blueTrinkets;
    private final List<ResourceLocation> redTrinkets;
    private final List<List<ItemStack>> loot;
    private final BlockPos pos;

    public RoyaleDraftContainer(int id, Inventory inv, int entityId, Map<String, Map<String, Integer>> skillPreset, List<ResourceLocation> blueTrinkets, List<ResourceLocation> redTrinkets, List<List<ItemStack>> loot, BlockPos pos) {
        super(ModContainers.ROYALE_DRAFT_CONTAINER, id, inv.f_35978_);
        this.entityId = entityId;
        this.skillPreset = skillPreset;
        this.blueTrinkets = blueTrinkets;
        this.redTrinkets = redTrinkets;
        this.pos = pos;
        this.loot = loot;
    }

    public List<RoyalePresetConfig.SkillPreset> getSkillPreset() {
        return ModConfigs.PRESET_CONFIG.getAllSkillPresets().stream().filter(p -> this.skillPreset.containsKey(p.name)).collect(Collectors.toList());
    }

    public Map<String, Integer> getGeneratedPresetData(String presetName) {
        return this.skillPreset.getOrDefault(presetName, Map.of());
    }

    public List<ResourceLocation> getBlueTrinkets() {
        return this.blueTrinkets;
    }

    public List<List<ItemStack>> getLoot() {
        return this.loot;
    }

    public List<ResourceLocation> getRedTrinkets() {
        return this.redTrinkets;
    }

    public boolean selectPreset(RoyalePresetConfig.SkillPreset preset) {
        if (!this.skillPreset.containsKey(preset.name)) {
            return false;
        }
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        RoyalePresetConfig.apply(sPlayer, preset.getName(), Map.of());
        return true;
    }

    public boolean selectTrinket(ResourceLocation trinket, boolean isBlue) {
        List<ResourceLocation> targetList;
        List<ResourceLocation> list = targetList = isBlue ? this.blueTrinkets : this.redTrinkets;
        if (!targetList.contains(trinket)) {
            return false;
        }
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        ItemStack stack = TrinketItem.createBaseTrinket(TrinketEffectRegistry.getEffect(trinket));
        TrinketItem.getSlotIdentifier(stack).ifPresent(identifier -> IntegrationCurios.setCurioItemStack((LivingEntity)sPlayer, new ItemStack((ItemLike)ModItems.TRINKET), identifier, 0));
        return true;
    }

    public boolean m_6875_(Player pPlayer) {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public RoyaleDrafterControllerTileEntity getControllerTile() {
        BlockEntity blockEntity = this.player.m_183503_().m_7702_(this.pos);
        if (blockEntity instanceof RoyaleDrafterControllerTileEntity) {
            RoyaleDrafterControllerTileEntity tile = (RoyaleDrafterControllerTileEntity)blockEntity;
            return tile;
        }
        return null;
    }

    public int getTab(UUID playerId) {
        RoyaleDrafterControllerTileEntity tile = this.getControllerTile();
        if (tile != null) {
            return tile.getTab(playerId);
        }
        return 0;
    }

    public void setTab(int tab, UUID playerId) {
        RoyaleDrafterControllerTileEntity tile = this.getControllerTile();
        if (tile != null) {
            tile.setTab(tab, playerId);
        }
    }
}

