/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.container.CurioContainerHandler;
import iskallia.vault.container.NBTElementContainer;
import iskallia.vault.container.slot.ArmorTabSlot;
import iskallia.vault.container.slot.OffhandTabSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.core.vault.stat.StatTotals;
import iskallia.vault.init.ModContainers;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.item.gear.TrinketItem;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;

public class StatisticsTabContainer
extends NBTElementContainer<StatTotals> {
    private static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final CurioContainerHandler curioContainerHandler;
    private final AbstractElementContainer.SlotIndexRange hotbarSlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange inventorySlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange hotbarInventorySlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange armorSlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange offhandSlotIndexRange;
    private final AbstractElementContainer.SlotIndexRange curioSlotIndexRange;

    public StatisticsTabContainer(int id, Inventory playerInventory, StatTotals statTotals) {
        super(() -> ModContainers.STATISTICS_TAB_CONTAINER, id, playerInventory.f_35978_, statTotals);
        int offsetX = 0;
        int offsetY = 18;
        int nextSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + (row + 1) * 9, 8 + column * 18 + offsetX, 84 + row * 18 + offsetY));
                ++nextSlotIndex;
            }
        }
        this.inventorySlotIndexRange = new AbstractElementContainer.SlotIndexRange(0, nextSlotIndex);
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18 + offsetX, 142 + offsetY));
            ++nextSlotIndex;
        }
        this.hotbarSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.inventorySlotIndexRange.end(), nextSlotIndex);
        this.hotbarInventorySlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.inventorySlotIndexRange.start(), this.hotbarSlotIndexRange.end());
        for (int armorSlot = 0; armorSlot < 4; ++armorSlot) {
            this.m_38897_(new ArmorTabSlot((Container)playerInventory, 39 - armorSlot, 8 + offsetX, 8 + armorSlot * 18 + offsetY - 18, EQUIPMENT_SLOTS[armorSlot], this.player));
            ++nextSlotIndex;
        }
        this.armorSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.hotbarSlotIndexRange.end(), nextSlotIndex);
        this.m_38897_(new OffhandTabSlot((Container)playerInventory, 40, 8 + offsetX, 62 + offsetY));
        this.offhandSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.armorSlotIndexRange.end(), ++nextSlotIndex);
        this.curioContainerHandler = new CurioContainerHandler(CurioContainerHandler.TabContainerAccessDecorator.of(this), nextSlotIndex, -20, 8, 8);
        this.curioContainerHandler.scrollToIndex(0);
        this.curioSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.offhandSlotIndexRange.end(), this.offhandSlotIndexRange.end() + this.curioContainerHandler.getVisibleSlotCount());
    }

    @Override
    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotItemStack = slot.m_7993_();
            itemStack = slotItemStack.m_41777_();
            EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)slotItemStack);
            if (this.armorSlotIndexRange.contains(index)) {
                if (!this.moveItemStackTo(slotItemStack, this.hotbarInventorySlotIndexRange, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(this.armorSlotIndexRange.end() - equipmentSlot.m_20749_() - 1)).m_6657_()) {
                int i = this.armorSlotIndexRange.end() - equipmentSlot.m_20749_() - 1;
                this.m_38903_(slotItemStack, i, i + 1, false);
            } else if (index < this.curioSlotIndexRange.start() && !CuriosApi.getCuriosHelper().getCurioTags(slotItemStack.m_41720_()).isEmpty()) {
                this.moveItemStackTo(slotItemStack, this.curioSlotIndexRange, false);
            } else if (index < this.curioSlotIndexRange.start() && (slotItemStack.m_41720_() instanceof CharmItem || slotItemStack.m_41720_() instanceof TrinketItem)) {
                this.moveItemStackTo(slotItemStack, this.curioSlotIndexRange, false);
            } else if (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(this.offhandSlotIndexRange.start())).m_6657_()) {
                this.moveItemStackTo(slotItemStack, this.offhandSlotIndexRange, false);
            }
            if (this.inventorySlotIndexRange.contains(index) ? !this.moveItemStackTo(slotItemStack, this.hotbarSlotIndexRange, false) : (this.hotbarSlotIndexRange.contains(index) ? !this.moveItemStackTo(slotItemStack, this.inventorySlotIndexRange, false) : !this.moveItemStackTo(slotItemStack, this.hotbarInventorySlotIndexRange, false))) {
                return ItemStack.f_41583_;
            }
        }
        return itemStack;
    }

    public CurioContainerHandler getCurioContainerHandler() {
        return this.curioContainerHandler;
    }
}

