/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.TransmogTableTileEntity;
import iskallia.vault.container.inventory.TransmogTableInventory;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.oversized.OverSizedTabSlot;
import iskallia.vault.container.slot.RecipeOutputSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.container.slot.VaultGearSlot;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TransmogTableContainer
extends OverSizedSlotContainer {
    protected TransmogTableInventory internalInventory;
    protected AbstractElementContainer.SlotIndexRange playerInventoryIndexRange;
    protected AbstractElementContainer.SlotIndexRange hotbarIndexRange;
    protected AbstractElementContainer.SlotIndexRange internalInventoryIndexRange;
    protected ResourceLocation selectedModelId;
    private final TransmogTableTileEntity tileEntity;
    private final BlockPos tilePos;

    public TransmogTableContainer(int id, Level level, BlockPos pos, Inventory playerInventory) {
        super(ModContainers.TRANSMOG_TABLE_CONTAINER, id, playerInventory.f_35978_);
        this.tilePos = pos;
        BlockEntity tile = level.m_7702_(this.tilePos);
        if (tile instanceof TransmogTableTileEntity) {
            TransmogTableTileEntity transmogTableTileEntity;
            this.tileEntity = transmogTableTileEntity = (TransmogTableTileEntity)tile;
            this.initInventory();
        } else {
            this.tileEntity = null;
        }
    }

    private void initInventory() {
        this.internalInventory = this.tileEntity.getInternalInventory();
        this.internalInventory.m_5785_(this.player);
        int offsetX = 0;
        int offsetY = 0;
        int containerSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + (row + 1) * 9;
                int x = 8 + column * 18 + offsetX;
                int y = 84 + row * 18 + offsetY;
                this.m_38897_(new TabSlot((Container)this.player.m_150109_(), index, x, y));
                ++containerSlotIndex;
            }
        }
        this.playerInventoryIndexRange = new AbstractElementContainer.SlotIndexRange(0, containerSlotIndex);
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            int x = 8 + hotbarSlot * 18 + offsetX;
            int y = 142 + offsetY;
            this.m_38897_(new TabSlot((Container)this.player.m_150109_(), hotbarSlot, x, y));
            ++containerSlotIndex;
        }
        this.hotbarIndexRange = new AbstractElementContainer.SlotIndexRange(this.playerInventoryIndexRange.end(), containerSlotIndex);
        this.m_38897_(new VaultGearSlot(this.internalInventory, 0, 63, 61){

            public void m_6654_() {
                super.m_6654_();
                if (this.m_7993_().m_41619_()) {
                    TransmogTableContainer.this.selectModelId(null);
                }
            }
        });
        ++containerSlotIndex;
        this.m_38897_(new OverSizedTabSlot(this.internalInventory, 1, 92, 61){

            @Override
            public void m_6654_() {
                super.m_6654_();
                TransmogTableContainer.this.m_6199_(this.f_40218_);
            }
        }.setFilter(itemStack -> itemStack.m_41720_() == ModBlocks.VAULT_BRONZE).setBackground(InventoryMenu.f_39692_, ModSlotIcons.COINS_NO_ITEM));
        ++containerSlotIndex;
        this.m_38897_(new RecipeOutputSlot(this.internalInventory, this.internalInventory.outputSlotIndex(), 152, 61){

            public void m_6654_() {
                super.m_6654_();
                TransmogTableContainer.this.m_6199_(this.f_40218_);
            }
        });
        this.internalInventoryIndexRange = new AbstractElementContainer.SlotIndexRange(this.hotbarIndexRange.end(), ++containerSlotIndex);
    }

    public TransmogTableInventory getInternalInventory() {
        return this.internalInventory;
    }

    public AbstractElementContainer.SlotIndexRange getInternalInventoryIndexRange() {
        return this.internalInventoryIndexRange;
    }

    public ResourceLocation getSelectedModelId() {
        return this.selectedModelId;
    }

    public void selectModelId(ResourceLocation modelId) {
        this.selectedModelId = modelId;
    }

    public ItemStack getPreviewItemStack() {
        ResourceLocation selectedModelId = this.getSelectedModelId();
        if (selectedModelId == null) {
            return ItemStack.f_41583_;
        }
        int gearSlotIndex = this.internalInventoryIndexRange.getContainerIndex(0);
        ItemStack gearStack = this.m_38853_(gearSlotIndex).m_7993_();
        if (gearStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack displayStack = new ItemStack((ItemLike)gearStack.m_41720_());
        VaultGearData gearData = VaultGearData.read(displayStack);
        gearData.setState(VaultGearState.IDENTIFIED);
        gearData.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, selectedModelId);
        gearData.write(displayStack);
        return displayStack;
    }

    public boolean priceFulfilled() {
        Slot bronzeSlot = this.m_38853_(this.internalInventoryIndexRange.getContainerIndex(1));
        return bronzeSlot.m_6657_() && bronzeSlot.m_7993_().m_150930_((Item)ModBlocks.VAULT_BRONZE) && bronzeSlot.m_7993_().m_41613_() >= this.copperCost() || CoinDefinition.hasEnoughCurrency(InventoryUtil.findAllItems(this.player), new ItemStack((ItemLike)ModBlocks.VAULT_BRONZE, this.copperCost()));
    }

    public int copperCost() {
        Slot gearSlot = this.m_38853_(this.internalInventoryIndexRange.getContainerIndex(0));
        ItemStack gearItem = gearSlot.m_7993_();
        if (gearItem.m_41619_()) {
            return -1;
        }
        VaultGearData gearData = VaultGearData.read(gearItem);
        return Mth.m_14045_((int)gearData.getItemLevel(), (int)1, (int)64);
    }

    public void m_6199_(Container pInventory) {
        this.tileEntity.m_6596_();
        super.m_6199_(pInventory);
    }

    public boolean m_6875_(@Nonnull Player player) {
        if (this.tileEntity == null) {
            return false;
        }
        return this.tileEntity.stillValid(player);
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.internalInventory.m_5785_(player);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size(), false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemstack;
    }
}

