/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import iskallia.vault.block.entity.VoidCrucibleTileEntity;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.util.ThemeBlockRetriever;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModContainers;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.world.data.VoidStoneBlacklistData;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class VoidCrucibleContainer
extends OverSizedSlotContainer {
    private static final int PLAYER_INVENTORY_TOP_Y = 298;
    protected final VoidCrucibleTileEntity tileEntity;
    protected final BlockPos pos;
    private Runnable slotChangeListener = () -> {};

    public VoidCrucibleContainer(MenuType<?> menuType, int id, Inventory playerInventory, BlockPos pos) {
        super(menuType, id, playerInventory.f_35978_);
        this.pos = pos;
        BlockEntity tile = this.player.f_19853_.m_7702_(pos);
        if (tile instanceof VoidCrucibleTileEntity) {
            VoidCrucibleTileEntity te;
            this.tileEntity = te = (VoidCrucibleTileEntity)tile;
            this.initSlots(playerInventory);
        } else {
            this.tileEntity = null;
        }
    }

    public VoidCrucibleTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public void setSlotChangeListener(Runnable slotChangeListener) {
        this.slotChangeListener = slotChangeListener;
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0 && (this.tileEntity == null || this.tileEntity.m_58904_().m_7702_(this.tileEntity.m_58899_()) == this.tileEntity);
    }

    protected void initSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 298 + row * 18));
            }
        }
    }

    public void m_182406_(int pSlotId, int pStateId, ItemStack pStack) {
        super.m_182406_(pSlotId, pStateId, pStack);
        this.slotChangeListener.run();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public static class Blacklist
    extends VoidCrucibleContainer {
        private List<ResourceLocation> blacklist;

        public Blacklist(int id, Inventory playerInventory, BlockPos pos, List<ResourceLocation> data) {
            super(ModContainers.VOID_CRUCIBLE_BLACKLIST_CONTAINER, id, playerInventory, pos);
            this.blacklist = data != null ? data : new ArrayList();
            this.initializeSlots(playerInventory);
            this.updateVisibleItems();
        }

        public Blacklist(int id, Inventory playerInventory, BlockPos pos, CompoundTag data) {
            super(ModContainers.VOID_CRUCIBLE_BLACKLIST_CONTAINER, id, playerInventory, pos);
            if (data == null) {
                this.blacklist = new ArrayList<ResourceLocation>();
            } else {
                VoidStoneBlacklistData.BlacklistInventory blacklistInventory = VoidStoneBlacklistData.BlacklistInventory.fromNbt(data);
                this.blacklist = blacklistInventory.getBlacklist();
            }
            this.initializeSlots(playerInventory);
            this.updateVisibleItems();
        }

        public Point getOffset() {
            return new Point(8, 20);
        }

        @Override
        protected void initSlots(Inventory inventory) {
        }

        protected void initializeSlots(Inventory playerInventory) {
            int i;
            int xOffset = this.getOffset().x;
            int yOffset = this.getOffset().y;
            for (int row = 0; row < 6; ++row) {
                for (int column = 0; column < 9; ++column) {
                    if (this.tileEntity == null) continue;
                    int slotIndex = column + row * 9;
                    this.m_38897_(new BlacklistSlot(this.tileEntity.getBlacklistInventory(), slotIndex, xOffset + column * 18, yOffset + row * 18));
                    this.m_182406_(slotIndex, 0, ItemStack.f_41583_);
                }
            }
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_38897_(new TabSlot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 142 + i * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.m_38897_(new TabSlot((Container)playerInventory, i, 8 + i * 18, 200));
            }
        }

        public List<ResourceLocation> getBlacklist() {
            return this.blacklist;
        }

        public int getBlacklistSize() {
            if (this.blacklist == null) {
                return 0;
            }
            return this.blacklist.size();
        }

        public void m_6877_(Player pPlayer) {
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)pPlayer;
                VoidStoneBlacklistData.get(sPlayer.m_183503_()).updateBlacklist(sPlayer, this.blacklist);
            }
            super.m_6877_(pPlayer);
        }

        public void updateVisibleItems() {
            int i;
            if (this.blacklist == null || this.tileEntity == null) {
                return;
            }
            for (i = 0; i < this.getTileEntity().getBlacklistInventory().m_6643_(); ++i) {
                this.getTileEntity().getBlacklistInventory().m_6836_(i, ItemStack.f_41583_);
            }
            for (i = 0; i < Math.min(this.blacklist.size(), this.getTileEntity().getBlacklistInventory().m_6643_()); ++i) {
                ResourceLocation id = this.blacklist.get(i);
                ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(id));
                this.getTileEntity().getBlacklistInventory().m_6836_(i, stack);
                if (i >= this.f_38839_.size()) continue;
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
            }
            this.m_38946_();
        }

        @Override
        public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
            Slot slot;
            Slot slot2 = slot = slotId >= 0 ? this.m_38853_(slotId) : null;
            if (slot instanceof BlacklistSlot) {
                if (slot.m_6657_()) {
                    this.blacklist.remove(slot.m_7993_().m_41720_().getRegistryName());
                    if (player instanceof ServerPlayer) {
                        ServerPlayer splayer = (ServerPlayer)player;
                        VoidStoneBlacklistData.get(splayer.m_183503_()).removeBlacklist(splayer, slot.m_7993_().m_41720_().getRegistryName());
                    }
                    slot.m_5852_(ItemStack.f_41583_);
                    this.updateVisibleItems();
                    return;
                }
                if (!this.m_142621_().m_41619_()) {
                    ItemStack stack = this.m_142621_().m_41777_();
                    if (!ThemeBlockRetriever.allowVaultBlock(stack.m_41720_().getRegistryName())) {
                        return;
                    }
                    if (!this.blacklist.contains(stack.m_41720_().getRegistryName())) {
                        this.blacklist.add(stack.m_41720_().getRegistryName());
                        if (player instanceof ServerPlayer) {
                            ServerPlayer splayer = (ServerPlayer)player;
                            VoidStoneBlacklistData.get(splayer.m_183503_()).addBlacklist(splayer, stack.m_41720_().getRegistryName());
                        }
                        this.updateVisibleItems();
                        return;
                    }
                }
            }
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }

        public ItemStack m_7648_(Player playerIn, int index) {
            ItemStack stack = ItemStack.f_41583_;
            Slot slot = this.m_38853_(index);
            if (!slot.m_6657_()) {
                return stack;
            }
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (slot instanceof BlacklistSlot) {
                this.blacklist.remove(slot.m_7993_().m_41720_().getRegistryName());
                slot.m_5852_(ItemStack.f_41583_);
                this.updateVisibleItems();
                return ItemStack.f_41583_;
            }
            if (this.blacklist.size() < 54 && !this.blacklist.contains(stack.m_41720_().getRegistryName())) {
                if (stack.m_41720_().getRegistryName() != null && !ThemeBlockRetriever.allowVaultBlock(stack.m_41720_().getRegistryName())) {
                    return ItemStack.f_41583_;
                }
                this.blacklist.add(stack.m_41720_().getRegistryName());
                float pitch = MathUtilities.randomFloat(0.9f, 1.1f);
                playerIn.f_19853_.m_5594_(null, playerIn.m_142538_(), SoundEvents.f_12130_, SoundSource.PLAYERS, 0.7f, pitch);
                this.updateVisibleItems();
                return ItemStack.f_41583_;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
            this.updateVisibleItems();
            return stack;
        }

        public class BlacklistSlot
        extends Slot {
            public BlacklistSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
                super(inventoryIn, index, xPosition, yPosition);
            }

            public boolean m_5857_(ItemStack stack) {
                if (this.m_6657_()) {
                    return false;
                }
                if (ThemeBlockRetriever.allowVaultBlock(stack.m_41720_().getRegistryName())) {
                    return true;
                }
                ResourceLocation id = stack.m_41720_().getRegistryName();
                return !Blacklist.this.blacklist.contains(id);
            }

            public int m_6641_() {
                return 1;
            }
        }
    }

    public static class ThemeSelect
    extends VoidCrucibleContainer {
        private final List<ThemeKey> themes;
        private List<ResourceLocation> blacklist = new ArrayList<ResourceLocation>();

        public ThemeSelect(int id, Inventory playerInventory, BlockPos pos, CompoundTag data) {
            super(ModContainers.VOID_CRUCIBLE_THEME_SELECT_CONTAINER, id, playerInventory, pos);
            this.themes = VaultRegistry.THEME.getKeys();
            if (data == null) {
                this.blacklist = new ArrayList<ResourceLocation>();
            } else {
                VoidStoneBlacklistData.BlacklistInventory blacklistInventory = VoidStoneBlacklistData.BlacklistInventory.fromNbt(data);
                this.blacklist = blacklistInventory.getBlacklist();
            }
        }

        public List<ThemeKey> getThemes() {
            return this.themes;
        }

        public List<ResourceLocation> getBlocksInTheme(ResourceLocation selectedTheme) {
            if (ModConfigs.VOID_CRUCIBLE_CUSTOM_ROOMS.hasItems(selectedTheme)) {
                return ModConfigs.VOID_CRUCIBLE_CUSTOM_ROOMS.getItems().get(selectedTheme.m_135815_()).getResources();
            }
            return ThemeBlockRetriever.getBlocksForTheme(selectedTheme);
        }

        @Override
        public boolean m_6875_(Player player) {
            if (this.tileEntity == null) {
                return false;
            }
            return this.tileEntity.stillValid(player);
        }

        @Override
        protected void initSlots(Inventory playerInventory) {
        }

        public List<ResourceLocation> getBlacklist() {
            return this.blacklist;
        }

        public void setBlacklist(List<ResourceLocation> blacklist) {
            this.blacklist = blacklist;
        }
    }
}

