/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.block.entity.WardrobeTileEntity;
import iskallia.vault.container.CurioContainerHandler;
import iskallia.vault.container.slot.ArmorTabSlot;
import iskallia.vault.container.slot.CurioTabSlot;
import iskallia.vault.container.slot.OffhandTabSlot;
import iskallia.vault.container.slot.TabSlot;
import iskallia.vault.container.spi.AbstractElementContainer;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ServerboundWardrobeSwapMessage;
import iskallia.vault.network.message.ServerboundWardrobeToggleSolidRenderMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public abstract class WardrobeContainer
extends AbstractElementContainer {
    private static final int PLAYER_INVENTORY_TOP_Y = 122;
    protected final WardrobeTileEntity tileEntity;
    protected AbstractElementContainer.SlotIndexRange hotbarSlotIndexRange;
    protected AbstractElementContainer.SlotIndexRange inventorySlotIndexRange;
    protected AbstractElementContainer.SlotIndexRange hotbarInventorySlotIndexRange;
    private final BlockPos pos;
    private Runnable slotChangeListener = () -> {};

    public WardrobeContainer(MenuType<?> menuType, int id, Inventory playerInventory, BlockPos pos) {
        super(menuType, id, playerInventory.f_35978_);
        this.pos = pos;
        BlockEntity tile = this.player.f_19853_.m_7702_(pos);
        if (tile instanceof WardrobeTileEntity) {
            WardrobeTileEntity spiritExtractorTile;
            this.tileEntity = spiritExtractorTile = (WardrobeTileEntity)tile;
            this.initSlots(playerInventory);
        } else {
            this.tileEntity = null;
        }
    }

    public void setSlotChangeListener(Runnable slotChangeListener) {
        this.slotChangeListener = slotChangeListener;
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0 && (this.tileEntity == null || this.tileEntity.m_58904_().m_7702_(this.tileEntity.m_58899_()) == this.tileEntity);
    }

    protected int initSlots(Inventory playerInventory) {
        int nextSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new TabSlot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 122 + row * 18));
                ++nextSlotIndex;
            }
        }
        this.inventorySlotIndexRange = new AbstractElementContainer.SlotIndexRange(0, nextSlotIndex);
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new TabSlot((Container)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 180));
            ++nextSlotIndex;
        }
        this.hotbarSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.inventorySlotIndexRange.end(), nextSlotIndex);
        this.hotbarInventorySlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.inventorySlotIndexRange.start(), this.hotbarSlotIndexRange.end());
        return nextSlotIndex;
    }

    public ItemStack getStoredEquipmentBySlot(EquipmentSlot equipmentSlot) {
        return this.tileEntity.getEquipment(equipmentSlot);
    }

    public Map<String, List<Tuple<ItemStack, Integer>>> getStoredCurios() {
        HashMap<String, List<Tuple<ItemStack, Integer>>> ret = new HashMap<String, List<Tuple<ItemStack, Integer>>>();
        this.tileEntity.getCuriosItems().forEach((slotKey, stacks) -> stacks.forEach((slot, stack) -> ret.computeIfAbsent((String)slotKey, sk -> new ArrayList()).add(new Tuple(stack, slot))));
        return ret;
    }

    public ItemStackHandler getHotbarItems() {
        return this.tileEntity.getHotbarItems();
    }

    public boolean isOwner() {
        return this.tileEntity.isOwner(this.player);
    }

    public void swap() {
        if (this.player.f_19853_.m_5776_()) {
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundWardrobeSwapMessage(this.pos, this.isHoldingShift()));
        }
    }

    public boolean isHoldingShift() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344);
    }

    public ItemStack getStoredCurio(String slotKey, int slot) {
        return this.tileEntity.getCurio(slotKey, slot);
    }

    public void m_182406_(int pSlotId, int pStateId, ItemStack pStack) {
        super.m_182406_(pSlotId, pStateId, pStack);
        this.slotChangeListener.run();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    private static class StoredCurioContainerHandler
    extends CurioContainerHandler {
        private Player player;
        private final WardrobeTileEntity wardrobeTile;

        public StoredCurioContainerHandler(Player player, WardrobeTileEntity wardrobeTile, CurioContainerHandler.IContainerAccess containerAccess, int slotStartIndex, int offsetX, int offsetY, int maxSlotsDisplayed) {
            super(containerAccess, slotStartIndex, offsetX, offsetY, maxSlotsDisplayed);
            this.player = player;
            this.wardrobeTile = wardrobeTile;
        }

        @Override
        protected void addSlots(Map<String, ICurioStacksHandler> curioMap, int startingIndex, int offsetY) {
            int index = 0;
            int slotCount = 0;
            for (Map.Entry<String, ICurioStacksHandler> entry : curioMap.entrySet()) {
                ICurioStacksHandler curioStacksHandler = entry.getValue();
                if (!curioStacksHandler.isVisible()) continue;
                IDynamicStackHandler dynamicStackHandler = curioStacksHandler.getStacks();
                WardrobeTileEntity.CuriosDynamicStackHandler storedCurioDynamicStackHandler = new WardrobeTileEntity.CuriosDynamicStackHandler(this.wardrobeTile, entry.getKey(), dynamicStackHandler.getSlots());
                for (int slotIndex = 0; slotIndex < dynamicStackHandler.getSlots() && slotCount < this.maxSlotsDisplayed; ++slotIndex) {
                    if (index >= startingIndex) {
                        this.containerAccess.addSlot((Slot)new CurioTabSlot(this.containerAccess.getPlayer(), storedCurioDynamicStackHandler, slotIndex, entry.getKey(), this.offsetX, offsetY, curioStacksHandler.getRenders()){

                            public boolean m_5857_(@NotNull ItemStack stack) {
                                return wardrobeTile.isOwner(player) && super.m_5857_(stack);
                            }

                            public boolean m_8010_(Player playerIn) {
                                return wardrobeTile.isOwner(player) && super.m_8010_(playerIn);
                            }
                        });
                        ++slotCount;
                        offsetY += 18;
                    }
                    ++index;
                }
            }
        }
    }

    private static class WardrobeEquipmentContainer
    implements Container {
        private final WardrobeTileEntity wardrobe;
        private final EquipmentSlot equipmentSlot;

        public WardrobeEquipmentContainer(WardrobeTileEntity wardrobe, EquipmentSlot equipmentSlot) {
            this.wardrobe = wardrobe;
            this.equipmentSlot = equipmentSlot;
        }

        public int m_6643_() {
            return 1;
        }

        public boolean m_7983_() {
            return this.getItem().m_41619_();
        }

        public ItemStack m_8020_(int pIndex) {
            return this.getItem();
        }

        private ItemStack getItem() {
            return this.wardrobe.getEquipment(this.equipmentSlot);
        }

        public ItemStack m_7407_(int pIndex, int pCount) {
            if (pCount < 1) {
                return ItemStack.f_41583_;
            }
            return this.m_8016_(pIndex);
        }

        public ItemStack m_8016_(int pIndex) {
            ItemStack result = this.getItem();
            if (!result.m_41619_()) {
                this.wardrobe.setEquipmentSlot(this.equipmentSlot, ItemStack.f_41583_);
            }
            return result;
        }

        public void m_6836_(int pIndex, ItemStack pStack) {
            this.wardrobe.setEquipmentSlot(this.equipmentSlot, pStack);
        }

        public void m_6596_() {
            this.wardrobe.m_6596_();
        }

        public boolean m_6542_(Player pPlayer) {
            return true;
        }

        public void m_6211_() {
            this.wardrobe.setEquipmentSlot(this.equipmentSlot, ItemStack.f_41583_);
        }

        public int m_6893_() {
            return 1;
        }
    }

    public static class Hotbar
    extends WardrobeContainer {
        private AbstractElementContainer.SlotIndexRange storedHotbarSlotIndexRange;

        public Hotbar(int id, Inventory playerInventory, BlockPos pos) {
            super(ModContainers.WARDROBE_HOTBAR_CONTAINER, id, playerInventory, pos);
        }

        @Override
        protected int initSlots(Inventory playerInventory) {
            int nextSlotIndex = super.initSlots(playerInventory);
            ItemStackHandler hotbarItems = this.tileEntity.getHotbarItems();
            for (int slot = 0; slot < hotbarItems.getSlots(); ++slot) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)hotbarItems, slot, 8 + 18 * slot, 90));
            }
            this.storedHotbarSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.hotbarInventorySlotIndexRange.end(), this.hotbarInventorySlotIndexRange.end() + hotbarItems.getSlots());
            return nextSlotIndex;
        }

        public ItemStack m_7648_(Player player, int index) {
            ItemStack originalStack = ItemStack.f_41583_;
            Slot slot = (Slot)this.f_38839_.get(index);
            if (slot != null && slot.m_6657_()) {
                ItemStack slotStack = slot.m_7993_();
                originalStack = slotStack.m_41777_();
                boolean didNotMoveStack = false;
                if (this.storedHotbarSlotIndexRange.contains(index)) {
                    didNotMoveStack = !this.moveItemStackTo(slotStack, this.hotbarInventorySlotIndexRange, false);
                } else if (this.hotbarInventorySlotIndexRange.contains(index)) {
                    boolean bl = didNotMoveStack = !this.moveItemStackTo(slotStack, this.storedHotbarSlotIndexRange, false);
                }
                if (didNotMoveStack) {
                    return ItemStack.f_41583_;
                }
                if (slotStack.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
            }
            return originalStack;
        }

        @Override
        protected boolean moveItemStackTo(@NotNull ItemStack itemStack, AbstractElementContainer.SlotIndexRange slotIndexRange, boolean pReverseDirection) {
            return super.moveItemStackTo(itemStack, slotIndexRange, pReverseDirection);
        }
    }

    public static class Gear
    extends WardrobeContainer {
        private CurioContainerHandler curioContainerHandler;
        protected AbstractElementContainer.SlotIndexRange curioSlotIndexRange;
        protected AbstractElementContainer.SlotIndexRange armorSlotIndexRange;
        protected AbstractElementContainer.SlotIndexRange offhandSlotIndexRange;
        private CurioContainerHandler storedCurioContainerHandler;
        private AbstractElementContainer.SlotIndexRange storedCurioSlotIndexRange;
        private AbstractElementContainer.SlotIndexRange storedArmorSlotIndexRange;
        private AbstractElementContainer.SlotIndexRange storedOffhandSlotIndexRange;

        public Gear(int id, Inventory playerInventory, BlockPos pos) {
            super(ModContainers.WARDROBE_GEAR_CONTAINER, id, playerInventory, pos);
        }

        @Override
        protected int initSlots(Inventory playerInventory) {
            int nextSlotIndex = super.initSlots(playerInventory);
            int slotIdx = 36;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                this.m_38897_(new ArmorTabSlot((Container)playerInventory, slotIdx++, 8, 72 - equipmentSlot.m_20749_() * 18, equipmentSlot, this.player));
                ++nextSlotIndex;
            }
            this.armorSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.hotbarSlotIndexRange.end(), nextSlotIndex);
            this.m_38897_(new OffhandTabSlot((Container)playerInventory, 40, 8, 90));
            this.offhandSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.armorSlotIndexRange.end(), ++nextSlotIndex);
            this.curioContainerHandler = new CurioContainerHandler(CurioContainerHandler.TabContainerAccessDecorator.of(this), nextSlotIndex, -20, 18, 8);
            this.curioContainerHandler.scrollToIndex(0);
            this.curioSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.offhandSlotIndexRange.end(), this.offhandSlotIndexRange.end() + this.curioContainerHandler.getVisibleSlotCount());
            nextSlotIndex += this.curioContainerHandler.getVisibleSlotCount();
            slotIdx = 0;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                this.m_38897_(new ArmorTabSlot(new WardrobeEquipmentContainer(this.tileEntity, equipmentSlot), slotIdx++, 152, 72 - equipmentSlot.m_20749_() * 18, equipmentSlot, this.player){

                    @Override
                    public boolean m_5857_(ItemStack itemStack) {
                        return this.isOwner() && super.m_5857_(itemStack);
                    }

                    @Override
                    public boolean m_8010_(@NotNull Player player) {
                        return this.isOwner() && super.m_8010_(player);
                    }
                });
                ++nextSlotIndex;
            }
            this.storedArmorSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.curioSlotIndexRange.end(), nextSlotIndex);
            this.m_38897_(new OffhandTabSlot(new WardrobeEquipmentContainer(this.tileEntity, EquipmentSlot.OFFHAND), 40, 152, 90){

                public boolean m_5857_(ItemStack pStack) {
                    return this.isOwner() && super.m_5857_(pStack);
                }

                public boolean m_8010_(Player pPlayer) {
                    return this.isOwner() && super.m_8010_(pPlayer);
                }
            });
            this.storedOffhandSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.storedArmorSlotIndexRange.end(), ++nextSlotIndex);
            this.storedCurioContainerHandler = new StoredCurioContainerHandler(this.player, this.tileEntity, CurioContainerHandler.TabContainerAccessDecorator.of(this), nextSlotIndex, 180, 18, 8);
            this.storedCurioContainerHandler.scrollToIndex(0);
            this.storedCurioSlotIndexRange = new AbstractElementContainer.SlotIndexRange(this.storedOffhandSlotIndexRange.end(), this.storedOffhandSlotIndexRange.end() + this.storedCurioContainerHandler.getVisibleSlotCount());
            return nextSlotIndex;
        }

        public CurioContainerHandler getCurioContainerHandler() {
            return this.curioContainerHandler;
        }

        public Set<ItemStack> getPlayerEquipment() {
            HashSet<ItemStack> ret = new HashSet<ItemStack>();
            for (int i = this.armorSlotIndexRange.start(); i < this.armorSlotIndexRange.end(); ++i) {
                ret.add(this.m_38853_(i).m_7993_());
            }
            ret.add(this.m_38853_(this.armorSlotIndexRange.start()).m_7993_());
            return ret;
        }

        public Collection<ItemStack> getStoredEquipment() {
            HashSet<ItemStack> ret = new HashSet<ItemStack>();
            for (int i = this.storedArmorSlotIndexRange.start(); i < this.storedArmorSlotIndexRange.end(); ++i) {
                ret.add(this.m_38853_(i).m_7993_());
            }
            ret.add(this.m_38853_(this.storedOffhandSlotIndexRange.start()).m_7993_());
            return ret;
        }

        public ItemStack m_7648_(Player player, int index) {
            ItemStack originalStack = ItemStack.f_41583_;
            Slot slot = (Slot)this.f_38839_.get(index);
            if (slot != null && slot.m_6657_()) {
                boolean didNotMoveAnything;
                ItemStack slotStack = slot.m_7993_();
                originalStack = slotStack.m_41777_();
                if (this.curioSlotIndexRange.contains(index)) {
                    didNotMoveAnything = !this.moveItemStackTo(slotStack, this.storedCurioSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.hotbarInventorySlotIndexRange, false);
                } else if (this.armorSlotIndexRange.contains(index)) {
                    didNotMoveAnything = !this.moveItemStackTo(slotStack, this.storedArmorSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.hotbarInventorySlotIndexRange, false);
                } else if (this.offhandSlotIndexRange.contains(index)) {
                    didNotMoveAnything = !this.moveItemStackTo(slotStack, this.storedOffhandSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.hotbarInventorySlotIndexRange, false);
                } else if (this.storedCurioSlotIndexRange.contains(index)) {
                    didNotMoveAnything = !this.moveItemStackTo(slotStack, this.curioSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.hotbarInventorySlotIndexRange, false);
                } else if (this.storedArmorSlotIndexRange.contains(index)) {
                    didNotMoveAnything = !this.moveItemStackTo(slotStack, this.armorSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.hotbarInventorySlotIndexRange, false);
                } else if (this.storedOffhandSlotIndexRange.contains(index)) {
                    didNotMoveAnything = !this.moveItemStackTo(slotStack, this.offhandSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.hotbarInventorySlotIndexRange, false);
                } else {
                    boolean bl = didNotMoveAnything = this.hotbarInventorySlotIndexRange.contains(index) && !this.moveItemStackTo(slotStack, this.storedCurioSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.storedArmorSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.curioSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.armorSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.storedOffhandSlotIndexRange, false) && !this.moveItemStackTo(slotStack, this.offhandSlotIndexRange, false);
                }
                if (didNotMoveAnything) {
                    return ItemStack.f_41583_;
                }
                if (slotStack.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                if (slotStack.m_41613_() == originalStack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(player, slotStack);
            }
            return originalStack;
        }

        public boolean shouldRenderSolid() {
            return this.tileEntity.shouldRenderSolid();
        }

        public void toggleSolidRender() {
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundWardrobeToggleSolidRenderMessage(this.tileEntity.m_58899_()));
        }

        public Player getDummyRenderPlayer() {
            return this.tileEntity.getDummyRenderPlayer();
        }

        public BlockPos getBlockPos() {
            return this.tileEntity.m_58899_();
        }
    }
}

