/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import iskallia.vault.antique.Antique;
import iskallia.vault.antique.AntiqueRegistry;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.ChangeListenerSlot;
import iskallia.vault.container.slot.ConditionalReadSlot;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.AntiqueItem;
import iskallia.vault.item.AntiqueStampCollectorBook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class AntiqueCollectorBookContainer
extends OverSizedSlotContainer {
    private final Inventory inventory;
    private final int bookSlot;
    private int activePage = 0;
    private final List<Runnable> slotListeners = new ArrayList<Runnable>();
    private final List<AntiqueCollectorBookSlot> antiqueSlots = new ArrayList<AntiqueCollectorBookSlot>();
    private final Map<Integer, List<AntiqueCollectorBookSlot>> pageAntiqueSlots = new HashMap<Integer, List<AntiqueCollectorBookSlot>>();

    public AntiqueCollectorBookContainer(int id, Inventory playerInventory, int bookSlot) {
        super(ModContainers.ANTIQUE_COLLECTOR_BOOK_CONTAINER, id, playerInventory.f_35978_);
        this.inventory = playerInventory;
        this.bookSlot = bookSlot;
        if (!playerInventory.f_35978_.f_19853_.f_46443_) {
            this.slotListeners.add(this::updateAntiques);
        }
        this.getBookStack().ifPresent(bookStack -> playerInventory.f_35978_.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            InvWrapper invWrapper = new InvWrapper(AntiqueStampCollectorBook.getAntiqueContainer(bookStack, this::m_6875_));
            this.initPlayerSlots((IItemHandler)inv);
            this.initAntiqueSlots((IItemHandler)invWrapper);
        }));
        this.setActivePage(0);
    }

    private void initPlayerSlots(IItemHandler playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_((Slot)new ConditionalReadSlot(playerInventory, column + row * 9 + 9, 64 + column * 18, 163 + row * 18, this::canAccess));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_((Slot)new ConditionalReadSlot(playerInventory, hotbarSlot, 64 + hotbarSlot * 18, 221, this::canAccess));
        }
    }

    private void initAntiqueSlots(IItemHandler antiqueInventory) {
        int xySlotStep = 36;
        List<Antique> sortedAntiques = AntiqueRegistry.sorted().toList();
        for (int i = 0; i < sortedAntiques.size(); ++i) {
            Antique antique = sortedAntiques.get(i);
            int doublePage = i / 18;
            int doublePageSlot = i % 18;
            int pageSideSlot = doublePageSlot % 9;
            boolean leftPage = doublePageSlot < 9;
            int slotX = pageSideSlot % 3;
            int slotY = pageSideSlot / 3;
            int offsetX = leftPage ? 36 : 164;
            int offsetY = 25;
            AntiqueCollectorBookSlot slot = new AntiqueCollectorBookSlot(antiqueInventory, i, offsetX + slotX * xySlotStep, offsetY + slotY * xySlotStep, antique);
            slot.addListener(() -> this.slotListeners.forEach(Runnable::run));
            slot.setActive(false);
            this.antiqueSlots.add(slot);
            this.pageAntiqueSlots.computeIfAbsent(doublePage, integer -> new ArrayList()).add(slot);
            this.m_38897_((Slot)slot);
        }
    }

    public int getActivePage() {
        return this.activePage;
    }

    public void setActivePage(int page) {
        this.activePage = page;
        this.antiqueSlots.forEach(slot -> slot.setActive(false));
        ((List)this.pageAntiqueSlots.getOrDefault(page, new ArrayList())).forEach(slot -> slot.setActive(true));
    }

    public int getPages() {
        return this.pageAntiqueSlots.size();
    }

    public List<AntiqueCollectorBookSlot> getAntiqueSlots() {
        return this.antiqueSlots;
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.hasBook();
    }

    public boolean canAccess(int slot, ItemStack slotStack) {
        return this.hasBook() && !(slotStack.m_41720_() instanceof AntiqueStampCollectorBook);
    }

    public boolean hasBook() {
        ItemStack book = this.inventory.m_8020_(this.bookSlot);
        return !book.m_41619_() && book.m_41720_() instanceof AntiqueStampCollectorBook;
    }

    public Optional<ItemStack> getBookStack() {
        if (!this.hasBook()) {
            return Optional.empty();
        }
        return Optional.of(this.inventory.m_8020_(this.bookSlot));
    }

    public Supplier<AntiqueStampCollectorBook.StoredAntiques> getStoredAntiquesSupplier() {
        return () -> this.getBookStack().map(AntiqueStampCollectorBook::getStoredAntiques).orElse(new AntiqueStampCollectorBook.StoredAntiques());
    }

    private void updateAntiques() {
        this.getBookStack().ifPresent(book -> {
            AntiqueStampCollectorBook.StoredAntiques antiques = this.getStoredAntiquesSupplier().get();
            for (AntiqueCollectorBookSlot slot : this.antiqueSlots) {
                Antique antique = slot.getAntique();
                ItemStack stack = slot.m_7993_();
                int count = stack.m_41613_();
                antiques.getInfo(antique).setCount(count);
            }
            AntiqueStampCollectorBook.setStoredAntiques(book, antiques);
        });
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size(), false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return itemstack;
    }

    public static class AntiqueCollectorBookSlot
    extends ChangeListenerSlot {
        private final Antique antique;
        private boolean isActive = true;

        public AntiqueCollectorBookSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, Antique antique) {
            super(itemHandler, index, xPosition, yPosition, (ItemStack stack) -> !stack.m_41619_() && stack.m_150930_((Item)ModItems.ANTIQUE) && ((Object)((Object)antique)).equals((Object)AntiqueItem.getAntique(stack)));
            this.antique = antique;
        }

        public int m_6641_() {
            return this.getItemHandler().getSlotLimit(0);
        }

        public int m_5866_(@Nonnull ItemStack stack) {
            return this.m_6641_();
        }

        public Antique getAntique() {
            return this.antique;
        }

        public void setActive(boolean active) {
            this.isActive = active;
        }

        public boolean m_6659_() {
            return this.isActive;
        }
    }
}

