/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardCondition;
import iskallia.vault.core.card.CardDeck;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardPos;
import iskallia.vault.item.CardDeckItem;
import iskallia.vault.item.CardItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class CardDeckContainer
extends SimpleContainer {
    private final ItemStack delegate;
    private final CardDeck deck;
    private final Map<Integer, CardPos> slotMapping;
    private final int deckHeight;
    private final int deckWidth;

    public CardDeckContainer(ItemStack delegate) {
        super(54);
        int slot;
        this.delegate = delegate;
        this.deck = CardDeckItem.getCardDeck(this.delegate).orElse(new CardDeck());
        this.slotMapping = new HashMap<Integer, CardPos>();
        for (CardPos pos : this.deck.getSlots()) {
            this.slotMapping.put(pos.x + pos.y * 9, pos);
        }
        if (this.delegate.m_41783_() != null && this.delegate.m_41783_().m_128441_("inventory")) {
            ListTag inventoryNbt = this.delegate.m_41783_().m_128437_("inventory", 10);
            for (int slotId = 0; slotId < inventoryNbt.size(); ++slotId) {
                CompoundTag entry = inventoryNbt.m_128728_(slotId);
                slot = entry.m_128445_("Slot") & 0xFF;
                if (slot >= this.m_6643_()) continue;
                this.m_6836_(slot, ItemStack.m_41712_((CompoundTag)entry));
            }
        }
        HashMap<Integer, ItemStack> deckItems = new HashMap<Integer, ItemStack>();
        for (CardPos pos : this.deck.getSlots()) {
            slot = pos.x + pos.y * 9;
            this.deck.getCard(pos).ifPresent(card -> {
                if (!card.getEntries().isEmpty()) {
                    ItemStack cardItem = CardItem.create(card);
                    deckItems.put(slot, cardItem);
                }
            });
        }
        deckItems.forEach((arg_0, arg_1) -> ((CardDeckContainer)this).m_6836_(arg_0, arg_1));
        if (!this.deck.getCards().isEmpty()) {
            CardPos min = this.deck.getMinSlot();
            CardPos max = this.deck.getMaxSlot();
            this.deckWidth = max.x - min.x + 1;
            this.deckHeight = max.y - min.y + 1;
        } else {
            this.deckWidth = 0;
            this.deckHeight = 0;
        }
    }

    public Map<Integer, CardPos> getSlotMapping() {
        return this.slotMapping;
    }

    public int getDeckWidth() {
        return this.deckWidth;
    }

    public int getDeckHeight() {
        return this.deckHeight;
    }

    public void m_6596_() {
        int i;
        super.m_6596_();
        ListTag inventoryNbt = new ListTag();
        for (i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag entry = new CompoundTag();
            entry.m_128344_("Slot", (byte)i);
            stack.m_41739_(entry);
            inventoryNbt.add((Object)entry);
        }
        this.delegate.m_41784_().m_128365_("inventory", (Tag)inventoryNbt);
        for (i = 0; i < this.m_6643_(); ++i) {
            if (!this.slotMapping.containsKey(i)) continue;
            if (this.m_8020_(i).m_41619_()) {
                this.deck.setCard(this.slotMapping.get(i), null);
                continue;
            }
            this.deck.setCard(this.slotMapping.get(i), CardItem.getCard(this.m_8020_(i)));
        }
        CardDeckItem.setCardDeck(this.delegate, this.deck);
    }

    public List<SlotColor> getMatchingNeighbors(int slotIndex) {
        CardPos pos = this.slotMapping.get(slotIndex);
        return this.deck.getCard(pos).map(card -> this.getMatchingNeighborSlots(pos, (Card)card)).orElse(Collections.emptyList());
    }

    public CardDeck getDeck() {
        return this.deck;
    }

    public boolean isCardActive(int slotIndex) {
        ItemStack stack = this.m_8020_(slotIndex);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CardItem)) {
            return true;
        }
        CardPos pos = this.slotMapping.get(slotIndex);
        if (pos == null) {
            return true;
        }
        Card card = CardItem.getCard(stack);
        for (CardEntry entry : card.getEntries()) {
            CardCondition condition = entry.getCondition();
            if (condition == null || condition.test(card.getTier(), pos, this.deck)) continue;
            return false;
        }
        return true;
    }

    private List<SlotColor> getMatchingNeighborSlots(CardPos cardPos, Card card) {
        ArrayList<SlotColor> matchingSlots = new ArrayList<SlotColor>();
        for (CardEntry entry : card.getEntries()) {
            if (entry.getScaler() == null) continue;
            entry.getScaler().getMatchingNeighbors(card.getTier(), cardPos, this.deck).forEach(neighbor -> {
                int slotIndex = neighbor.x + neighbor.y * 9;
                matchingSlots.add(new SlotColor(slotIndex, entry.getModifier().getHighlightColor() & 0xFFFFFF | 0x77000000));
            });
        }
        return matchingSlots;
    }

    public record SlotColor(int slotIndex, int color) {
    }
}

