/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import iskallia.vault.container.inventory.CardDeckContainer;
import iskallia.vault.core.card.modifier.deck.SlotDeckModifier;
import iskallia.vault.init.ModContainers;
import iskallia.vault.item.CardDeckItem;
import iskallia.vault.item.CardItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.common.integration.curios.CuriosIntegration;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CardDeckContainerMenu
extends AbstractContainerMenu {
    private final List<DeckSlot> cardSlots = new ArrayList<DeckSlot>();
    private final List<Slot> playerSlots = new ArrayList<Slot>();
    private final CardDeckContainer container;
    private final int cardSlot;
    private final boolean curios;
    private final int inventoryWidth;
    private final int inventoryHeight;
    private final int deckWidth;
    private final int deckHeight;
    private final int totalWidth;
    private final int totalHeight;

    public CardDeckContainerMenu(int id, Inventory playerInventory, int cardSlot, boolean curios, CardDeckContainer container) {
        super(ModContainers.CARD_DECK_CONTAINER, id);
        this.container = container;
        this.cardSlot = cardSlot;
        this.curios = curios;
        this.inventoryWidth = 176;
        this.inventoryHeight = 93;
        int cardBackgroundPaddingHeight = 20;
        int cardBackgroundPaddingWidth = 20;
        int cardBackgroundInventoryPadding = 2;
        this.deckWidth = 2 * cardBackgroundPaddingWidth + 18 * container.getDeckWidth();
        this.deckHeight = 2 * cardBackgroundPaddingHeight + 18 * container.getDeckHeight();
        this.totalWidth = Math.max(this.deckWidth, this.inventoryWidth);
        this.totalHeight = this.deckHeight + this.inventoryHeight + cardBackgroundInventoryPadding;
        this.addContainerSlots(container);
        this.addPlayerSlots(playerInventory);
    }

    private void addContainerSlots(CardDeckContainer deckCt) {
        int offsetX = (this.totalWidth - this.deckWidth) / 2 + 21;
        int offsetY = 21;
        for (int row = 0; row < 6; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + row * 9;
                boolean isDeckModified = deckCt.getDeck().getModifiers().stream().anyMatch(modifier -> {
                    if (modifier instanceof SlotDeckModifier) {
                        SlotDeckModifier slotDeckModifier = (SlotDeckModifier)modifier;
                        return slotDeckModifier.getAffectedSlots().stream().anyMatch(cardPos -> cardPos != null && deckCt.getSlotMapping().get(index) != null && deckCt.getSlotMapping().get(index).equals(cardPos));
                    }
                    return false;
                });
                DeckSlot slot = new DeckSlot((Container)this.container, index, offsetX + column * 18, offsetY + row * 18, isDeckModified);
                slot.setActive(deckCt.getSlotMapping().containsKey(index));
                this.m_38897_(slot);
                this.cardSlots.add(slot);
            }
        }
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int j;
        int offsetX = (this.totalWidth - this.inventoryWidth) / 2 + 8;
        int offsetY = this.totalHeight - 83;
        int offsetHotbarY = this.totalHeight - 25;
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                Slot slot = this.m_38897_(new Slot((Container)playerInventory, k + j * 9 + 9, offsetX + k * 18, offsetY + j * 18){

                    public boolean m_8010_(Player pPlayer) {
                        return CardDeckContainerMenu.this.curios || this.getSlotIndex() != CardDeckContainerMenu.this.cardSlot;
                    }
                });
                this.playerSlots.add(slot);
            }
        }
        for (j = 0; j < 9; ++j) {
            Slot slot = this.m_38897_(new Slot((Container)playerInventory, j, offsetX + j * 18, offsetHotbarY){

                public boolean m_8010_(Player pPlayer) {
                    return CardDeckContainerMenu.this.curios || this.getSlotIndex() != CardDeckContainerMenu.this.cardSlot;
                }
            });
            this.playerSlots.add(slot);
        }
    }

    public List<Slot> getCardSlots() {
        return Collections.unmodifiableList(this.cardSlots.stream().filter(slot -> !slot.deckModified).toList());
    }

    public List<Slot> getModifiedCardSlots() {
        return Collections.unmodifiableList(this.cardSlots.stream().filter(DeckSlot::isDeckModified).toList());
    }

    public List<Slot> getPlayerSlots() {
        return Collections.unmodifiableList(this.playerSlots);
    }

    public boolean m_6875_(Player player) {
        if (!(this.getDeckStack(player).m_41720_() instanceof CardDeckItem)) {
            return false;
        }
        return this.container.m_6542_(player);
    }

    public ItemStack getDeckStack(Player player) {
        return this.curios ? CuriosIntegration.getCurioStack((LivingEntity)player, (String)"deck", (int)0) : player.m_150109_().m_8020_(this.cardSlot);
    }

    public CardDeckContainer getContainer() {
        return this.container;
    }

    public int getInventoryWidth() {
        return this.inventoryWidth;
    }

    public int getInventoryHeight() {
        return this.inventoryHeight;
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public int getDeckWidth() {
        return this.deckWidth;
    }

    public int getDeckHeight() {
        return this.deckHeight;
    }

    public ItemStack m_7648_(Player player, int pIndex) {
        ItemStack copy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            copy = stack.m_41777_();
            if (pIndex < 54 ? !this.m_38903_(stack, 54, this.f_38839_.size(), true) : !this.m_38903_(stack, 0, 54, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return copy;
    }

    public static class DeckSlot
    extends Slot {
        private boolean isActive = true;
        private final boolean deckModified;

        public DeckSlot(Container container, int index, int x, int y, boolean deckModified) {
            super(container, index, x, y);
            this.deckModified = deckModified;
        }

        public void setActive(boolean active) {
            this.isActive = active;
        }

        public boolean m_6659_() {
            return this.isActive;
        }

        public boolean isDeckModified() {
            return this.deckModified;
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41720_() instanceof CardItem && this.m_6659_();
        }
    }
}

