/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.CompactingSlot;
import iskallia.vault.container.slot.ConditionalReadSlot;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModContainers;
import iskallia.vault.item.CoinPouchItem;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CoinPouchContainer
extends OverSizedSlotContainer {
    private final int pouchSlot;
    private final Inventory inventory;

    public CoinPouchContainer(int id, Inventory playerInventory, int pouchSlot) {
        super(ModContainers.COIN_POUCH_CONTAINER, id, playerInventory.f_35978_);
        this.inventory = playerInventory;
        this.pouchSlot = pouchSlot;
        if (this.hasPouch()) {
            playerInventory.f_35978_.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(playerHandler -> {
                ItemStack pouch = this.inventory.m_8020_(this.pouchSlot);
                if (pouch.m_41619_()) {
                    return;
                }
                pouch.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(pouchHandler -> this.initSlots((IItemHandler)playerHandler, (IItemHandler)pouchHandler));
            });
        }
    }

    private void initSlots(IItemHandler playerInvHandler, IItemHandler pouchHandler) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_((Slot)new ConditionalReadSlot(playerInvHandler, column + row * 9 + 9, 8 + column * 18, 84 + row * 18, this::canAccess));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_((Slot)new ConditionalReadSlot(playerInvHandler, hotbarSlot, 8 + hotbarSlot * 18, 142, this::canAccess));
        }
        int x = 44;
        int y = 33;
        Slot bronze = this.m_38897_((Slot)new CompactingSlot(pouchHandler, 0, x, y, this, ModBlocks.BRONZE_COIN_PILE.m_5456_()));
        Slot silver = this.m_38897_((Slot)new CompactingSlot(pouchHandler, 1, x += 24, y, this, ModBlocks.SILVER_COIN_PILE.m_5456_()));
        Slot gold = this.m_38897_((Slot)new CompactingSlot(pouchHandler, 2, x += 24, y, this, ModBlocks.GOLD_COIN_PILE.m_5456_()));
        Slot plat = this.m_38897_((Slot)new CompactingSlot(pouchHandler, 3, x += 24, y, this, ModBlocks.PLATINUM_COIN_PILE.m_5456_()));
        ((CompactingSlot)bronze).setupSlots(null, silver);
        ((CompactingSlot)silver).setupSlots(bronze, gold);
        ((CompactingSlot)gold).setupSlots(silver, plat);
        ((CompactingSlot)plat).setupSlots(gold, null);
    }

    public boolean m_6875_(Player player) {
        return this.hasPouch();
    }

    public boolean canAccess(int slot, ItemStack slotStack) {
        return this.hasPouch() && !(slotStack.m_41720_() instanceof CoinPouchItem);
    }

    public boolean hasPouch() {
        ItemStack pouchStack = this.inventory.m_8020_(this.pouchSlot);
        return !pouchStack.m_41619_() && pouchStack.m_41720_() instanceof CoinPouchItem;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, 40, false)) {
                return itemStack;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return itemStack;
    }
}

