/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.inventory;

import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.ConditionalReadSlot;
import iskallia.vault.container.slot.TreasureKeySlot;
import iskallia.vault.init.ModContainers;
import iskallia.vault.item.ItemVaultKey;
import iskallia.vault.item.ItemVaultKeyring;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class VaultKeyringContainer
extends OverSizedSlotContainer {
    private final Inventory inventory;
    private final int keyringSlot;
    private final List<Runnable> slotListeners = new ArrayList<Runnable>();
    private final List<TreasureKeySlot> keySlots = new ArrayList<TreasureKeySlot>();

    public VaultKeyringContainer(int id, Inventory playerInventory, int slot) {
        super(ModContainers.VAULT_KEYRING_CONTAINER, id, playerInventory.f_35978_);
        this.inventory = playerInventory;
        this.keyringSlot = slot;
        if (!playerInventory.f_35978_.f_19853_.f_46443_) {
            this.slotListeners.add(this::updateTreasureKeys);
        }
        this.getKeyringStack().ifPresent(keyringStack -> playerInventory.f_35978_.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            this.initPlayerSlots((IItemHandler)inv);
            this.initKeySlots((ItemStack)keyringStack);
        }));
    }

    public List<TreasureKeySlot> getKeySlots() {
        return this.keySlots;
    }

    private void initPlayerSlots(IItemHandler playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_((Slot)new ConditionalReadSlot(playerInventory, column + row * 9 + 9, 8 + column * 18, 82 + row * 18, this::canAccess));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_((Slot)new ConditionalReadSlot(playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 140, this::canAccess));
        }
    }

    private void initKeySlots(ItemStack keyringStack) {
        List<OverSizedItemStack> keyringStacks = ItemVaultKeyring.getStoredStacks(keyringStack);
        List keyItems = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof ItemVaultKey).map(item -> (ItemVaultKey)((Object)item)).filter(ItemVaultKey::isActive).sorted(Comparator.comparing(ForgeRegistryEntry::getRegistryName)).collect(Collectors.toList());
        int slots = keyItems.size();
        OverSizedInventory buffer = new OverSizedInventory(slots, stacks -> {}, player -> true);
        for (int index = 0; index < slots; ++index) {
            Item keyItem = (Item)keyItems.get(index);
            OverSizedItemStack keyStack = keyringStacks.stream().filter(stack -> stack.stack().m_150930_(keyItem)).findFirst().orElse(OverSizedItemStack.EMPTY);
            buffer.setOverSizedStack(index, keyStack);
            this.addKeySlot(buffer, new ItemStack((ItemLike)keyItem), index, 8 + index * 18, 25);
        }
    }

    private void addKeySlot(Container container, ItemStack keyType, int index, int x, int y) {
        TreasureKeySlot slot = new TreasureKeySlot(container, index, x, y, keyType);
        slot.addListener(() -> this.slotListeners.forEach(Runnable::run));
        this.keySlots.add(slot);
        this.m_38897_(slot);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.hasKeyring();
    }

    public boolean canAccess(int slot, ItemStack slotStack) {
        return this.hasKeyring() && !(slotStack.m_41720_() instanceof ItemVaultKeyring);
    }

    public boolean hasKeyring() {
        ItemStack slotStack = this.inventory.m_8020_(this.keyringSlot);
        return !slotStack.m_41619_() && slotStack.m_41720_() instanceof ItemVaultKeyring;
    }

    public Optional<ItemStack> getKeyringStack() {
        if (!this.hasKeyring()) {
            return Optional.empty();
        }
        return Optional.of(this.inventory.m_8020_(this.keyringSlot));
    }

    private void updateTreasureKeys() {
        this.getKeyringStack().ifPresent(keyring -> {
            ArrayList<OverSizedItemStack> stacks = new ArrayList<OverSizedItemStack>();
            for (TreasureKeySlot slot : this.keySlots) {
                ItemStack stored = slot.m_7993_();
                stacks.add(OverSizedItemStack.of(stored));
            }
            ItemVaultKeyring.setStoredStacks(keyring, stacks);
        });
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.moveOverSizedItemStackTo(slotStack, slot, 36, this.f_38839_.size(), false)) {
                return itemstack;
            }
            if (index >= 0 && index < 27 ? !this.moveOverSizedItemStackTo(slotStack, slot, 27, 36, false) : (index >= 27 && index < 36 ? !this.moveOverSizedItemStackTo(slotStack, slot, 0, 27, false) : !this.moveOverSizedItemStackTo(slotStack, slot, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return itemstack;
    }
}

