/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.modifier;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public record DiscoverableModifier(Item item, ResourceLocation modifierId, boolean discovered) {
    public static Optional<DiscoverableModifier> deserialize(CompoundTag tag) {
        String itemKey = tag.m_128461_("item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemKey));
        if (item != null) {
            boolean discovered = tag.m_128441_("discovered") && tag.m_128471_("discovered");
            ResourceLocation modifier = new ResourceLocation(tag.m_128461_("modifier"));
            return Optional.of(new DiscoverableModifier(item, modifier, discovered));
        }
        return Optional.empty();
    }

    public static DiscoverableModifier deserialize(FriendlyByteBuf buf) {
        return new DiscoverableModifier((Item)buf.readRegistryId(), buf.m_130281_(), buf.readBoolean());
    }

    public void serialize(CompoundTag tag) {
        tag.m_128359_("item", this.item.getRegistryName().toString());
        tag.m_128359_("modifier", this.modifierId.toString());
        tag.m_128379_("discovered", this.discovered);
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeRegistryId((IForgeRegistryEntry)this.item);
        buf.m_130085_(this.modifierId);
        buf.writeBoolean(this.discovered);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoverableModifier modifier = (DiscoverableModifier)o;
        return Objects.equals(this.item, modifier.item) && Objects.equals(this.modifierId, modifier.modifierId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.item, this.modifierId);
    }
}

