/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.oversized;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record OverSizedItemStack(ItemStack stack, int amount) {
    public static final OverSizedItemStack EMPTY = new OverSizedItemStack(ItemStack.f_41583_, 0);

    public static List<OverSizedItemStack> of(List<ItemStack> stacks) {
        ArrayList<OverSizedItemStack> oversized = new ArrayList<OverSizedItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            oversized.add(OverSizedItemStack.of(stack));
        }
        return oversized;
    }

    @Nonnull
    public static OverSizedItemStack of(ItemStack stack) {
        return new OverSizedItemStack(stack, stack.m_41613_());
    }

    public OverSizedItemStack copyAmount(int newAmount) {
        return new OverSizedItemStack(this.stack(), newAmount);
    }

    public OverSizedItemStack addCopy(int change) {
        return new OverSizedItemStack(this.stack(), this.amount() + change);
    }

    public ItemStack overSizedStack() {
        ItemStack overSized = this.stack().m_41777_();
        overSized.m_41764_(this.amount());
        return overSized;
    }

    public boolean isEmpty() {
        return this.amount() <= 0 || this.overSizedStack().m_41619_();
    }

    public List<ItemStack> splitByStackSize() {
        ArrayList<ItemStack> split = new ArrayList<ItemStack>();
        ItemStack sample = this.stack();
        for (int i = 0; i < this.amount(); i += sample.m_41741_()) {
            int amt = Math.min(this.amount() - i, sample.m_41741_());
            ItemStack out = sample.m_41777_();
            out.m_41764_(amt);
            split.add(out);
        }
        return split;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        ItemStack serializable = this.stack;
        if (this.amount() > 64) {
            serializable.m_41764_(64);
        }
        tag.m_128365_("stack", (Tag)serializable.serializeNBT());
        tag.m_128405_("amount", this.amount());
        return tag;
    }

    public static OverSizedItemStack deserialize(CompoundTag tag) {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
        return new OverSizedItemStack(stack, tag.m_128451_("amount"));
    }

    public void write(FriendlyByteBuf buf) {
        this.write(buf, true);
    }

    public void write(FriendlyByteBuf buf, boolean limitedTag) {
        if (this.amount() <= 0) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            Item item = this.stack().m_41720_();
            buf.m_130130_(Item.m_41393_((Item)item));
            buf.writeInt(this.amount());
            CompoundTag compoundtag = null;
            if (item.isDamageable(this.stack()) || item.m_41468_()) {
                compoundtag = limitedTag ? this.stack().getShareTag() : this.stack().m_41783_();
            }
            buf.m_130079_(compoundtag);
        }
    }

    public static OverSizedItemStack read(FriendlyByteBuf buf) {
        if (!buf.readBoolean()) {
            return EMPTY;
        }
        int itemId = buf.m_130242_();
        int count = buf.readInt();
        ItemStack itemstack = new ItemStack((ItemLike)Item.m_41445_((int)itemId), Math.min(count, 64));
        itemstack.readShareTag(buf.m_130260_());
        return new OverSizedItemStack(itemstack, count);
    }
}

