/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.oversized;

import iskallia.vault.container.oversized.OverSizedItemStack;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class OverSizedItemStackHandler
extends ItemStackHandler {
    public OverSizedItemStackHandler(int size) {
        super(size);
    }

    public CompoundTag serializeNBT() {
        ListTag items = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag tag = OverSizedItemStack.of(stack).serialize();
            tag.m_128405_("Slot", i);
            items.add((Object)tag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Size", this.stacks.size());
        nbt.m_128365_("Items", (Tag)items);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stacks = NonNullList.m_122780_((int)(nbt.m_128441_("Size") ? nbt.m_128451_("Size") : this.stacks.size()), (Object)ItemStack.f_41583_);
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            OverSizedItemStack ov = OverSizedItemStack.deserialize(itemTags);
            this.stacks.set(slot, (Object)ov.overSizedStack());
        }
        this.onLoad();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack stackInSlot = (ItemStack)this.stacks.get(slot);
        int slotLimit = this.getSlotLimit(slot);
        if (!stackInSlot.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (stackInSlot.m_41613_() >= slotLimit) {
                return stack;
            }
            int storeable = Math.min(slotLimit - stackInSlot.m_41613_(), stack.m_41613_());
            ItemStack remainder = stack.m_41777_();
            remainder.m_41774_(storeable);
            if (!simulate) {
                ItemStack copy = stackInSlot.m_41777_();
                copy.m_41769_(storeable);
                this.stacks.set(slot, (Object)copy);
                this.onContentsChanged(slot);
            }
            return remainder.m_41619_() ? ItemStack.f_41583_ : remainder;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int toInsert = Math.min(slotLimit, stack.m_41613_());
        ItemStack remainder = stack.m_41777_();
        remainder.m_41774_(toInsert);
        if (!simulate) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(toInsert);
            this.stacks.set(slot, (Object)copy);
            this.onContentsChanged(slot);
        }
        return remainder.m_41619_() ? ItemStack.f_41583_ : remainder;
    }

    public int getSlotLimit(int slot) {
        return 2147483582;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return this.getSlotLimit(slot);
    }
}

