/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.container.slot;

import iskallia.vault.container.inventory.CoinPouchContainer;
import iskallia.vault.container.slot.ConditionalReadSlot;
import iskallia.vault.init.ModSlotIcons;
import iskallia.vault.item.CoinPouchItem;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompactingSlot
extends ConditionalReadSlot {
    private final ItemStack defaultStack;
    private Slot prevSlot;
    private Slot nextSlot;

    public CompactingSlot(IItemHandler inventory, int index, int xPosition, int yPosition, CoinPouchContainer container, Item defaultItem) {
        super(inventory, index, xPosition, yPosition, (slot, stack) -> container.canAccess((int)slot, (ItemStack)stack) && stack.m_41720_() == defaultItem);
        this.defaultStack = new ItemStack((ItemLike)defaultItem);
        this.setBackground(InventoryMenu.f_39692_, ModSlotIcons.COINS_NO_ITEM);
    }

    public void setupSlots(@Nullable Slot prevSlot, @Nullable Slot nextSlot) {
        this.prevSlot = prevSlot;
        this.nextSlot = nextSlot;
    }

    public int m_5866_(@NotNull ItemStack stack) {
        return this.getItemHandler().getSlotLimit(this.getSlotIndex());
    }

    public ItemStack getDefaultCopy() {
        return this.defaultStack.m_41777_();
    }

    public void m_5852_(@NotNull ItemStack stack) {
        ((CoinPouchItem.Handler)this.getItemHandler()).setStackInSlotGUI(this.getSlotIndex(), stack);
        this.m_6654_();
        this.compact(stack.m_41613_());
    }

    @NotNull
    public ItemStack m_6201_(int amount) {
        ItemStack stack = ((CoinPouchItem.Handler)this.getItemHandler()).extractItemGUI(this.getSlotIndex(), amount, false);
        this.m_6654_();
        this.compact(this.m_7993_().m_41613_());
        return stack;
    }

    public void m_142406_(Player player, ItemStack stack) {
        this.m_6654_();
        ((CoinPouchItem.Handler)this.getItemHandler()).setStackInSlotGUI(this.getSlotIndex(), this.m_7993_());
        this.compact(this.m_7993_().m_41613_());
    }

    private void compact(int count) {
        ItemStack stack;
        if (this.prevSlot != null) {
            stack = this.prevSlot.m_7993_();
            int prevCount = 0;
            if (stack.m_150930_(Items.f_41852_)) {
                stack = ((CompactingSlot)this.prevSlot).getDefaultCopy();
                prevCount = count * 9;
            } else {
                prevCount = stack.m_41613_();
                prevCount -= Mth.m_14042_((int)prevCount, (int)9) * 9;
                prevCount += count * 9;
            }
            if (prevCount != this.prevSlot.m_7993_().m_41613_()) {
                this.prevSlot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)prevCount));
            }
        }
        if (this.nextSlot != null) {
            int nextCount;
            stack = this.nextSlot.m_7993_();
            if (stack.m_150930_(Items.f_41852_)) {
                stack = ((CompactingSlot)this.nextSlot).getDefaultCopy();
            }
            if ((nextCount = Mth.m_14042_((int)count, (int)9)) != this.nextSlot.m_7993_().m_41613_()) {
                this.nextSlot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)nextCount));
            }
        }
    }
}

