/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import iskallia.vault.VaultMod;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.configured.ConfiguredTemplate;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.init.ModBlocks;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class SkyVaultsChunkGenerator
extends ChunkGenerator {
    public static final Codec<SkyVaultsChunkGenerator> CODEC = RecordCodecBuilder.create(builder -> SkyVaultsChunkGenerator.m_208005_((RecordCodecBuilder.Instance)builder).and(builder.group((App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_211073_).optionalFieldOf("structure_overrides").forGetter(gen -> gen.f_207956_), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(gen -> gen.noises), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(gen -> gen.seed), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(gen -> gen.settings))).apply((Applicative)builder, builder.stable(SkyVaultsChunkGenerator::new)));
    private final Registry<NormalNoise.NoiseParameters> noises;
    private final long seed;
    private final Holder<NoiseGeneratorSettings> settings;
    private final Climate.Sampler sampler;
    private final SurfaceSystem surfaceSystem;

    public SkyVaultsChunkGenerator(Registry<StructureSet> structures, HolderSet<StructureSet> overrides, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, long seed, Holder<NoiseGeneratorSettings> settings) {
        this(structures, Optional.ofNullable(overrides), noises, biomeSource, biomeSource, seed, settings);
    }

    private SkyVaultsChunkGenerator(Registry<StructureSet> structures, Optional<HolderSet<StructureSet>> overrides, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, long seed, Holder<NoiseGeneratorSettings> settings) {
        this(structures, overrides, noises, biomeSource, biomeSource, seed, settings);
    }

    private SkyVaultsChunkGenerator(Registry<StructureSet> structures, Optional<HolderSet<StructureSet>> overrides, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource1, BiomeSource biomeSource2, long seed, Holder<NoiseGeneratorSettings> settings) {
        super(structures, overrides, biomeSource1, biomeSource2, seed);
        this.noises = noises;
        this.seed = seed;
        this.settings = settings;
        NoiseGeneratorSettings noiseSettings = (NoiseGeneratorSettings)this.settings.m_203334_();
        BlockState defaultBlock = noiseSettings.f_64440_();
        NoiseRouter router = noiseSettings.m_209366_(noises, seed);
        this.sampler = new Climate.Sampler(router.f_209384_(), router.f_209385_(), router.f_209386_(), router.f_209387_(), router.f_209388_(), router.f_209389_(), router.f_209395_());
        this.surfaceSystem = new SurfaceSystem(noises, defaultBlock, noiseSettings.f_64444_(), seed, noiseSettings.m_188893_());
    }

    public Climate.Sampler m_183403_() {
        return this.sampler;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long seed) {
        return new SkyVaultsChunkGenerator((Registry<StructureSet>)this.f_207955_, (HolderSet<StructureSet>)((HolderSet)this.f_207956_.orElse(null)), this.noises, this.f_62137_.m_7206_(seed), seed, this.settings);
    }

    public int m_142647_(int pX, int pZ, Heightmap.Types type, LevelHeightAccessor world) {
        return world.m_141937_();
    }

    public NoiseColumn m_141914_(int pX, int pZ, LevelHeightAccessor world) {
        return new NoiseColumn(world.m_141937_(), new BlockState[0]);
    }

    public void m_207076_(List<String> p_208054_, BlockPos p_208055_) {
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public void m_183621_(WorldGenRegion genRegion, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        ServerLevel world = genRegion.m_6018_();
        if (world.m_46472_() != Level.f_46428_) {
            return;
        }
        Version version = Version.latest();
        JavaRandom random = JavaRandom.ofInternal(world.m_7328_());
        TemplatePoolKey pool = VaultRegistry.TEMPLATE_POOL.getKey(VaultMod.id("skyblock/island"));
        ((TemplatePool)pool.get(version)).getRandomFlat(version, random).ifPresent(entry -> {
            PlacementSettings settings = new PlacementSettings(new ProcessorContext(null, random)).setFlags(3);
            Mirror mirror = random.nextBoolean() ? Mirror.NONE : Mirror.FRONT_BACK;
            Rotation rotation = (new Rotation[]{Rotation.NONE, Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_180})[random.nextInt(4)];
            settings.addProcessor(TileProcessor.rotate(rotation, 0, 0, true));
            settings.addProcessor(TileProcessor.mirror(mirror, 0, true));
            settings.addProcessor(TileProcessor.translate(0, 128, 0));
            settings.addProcessor(TileProcessor.bound(chunk.m_7697_(), genRegion.m_141937_(), genRegion.m_151558_()));
            settings.addProcessor(TileProcessor.of((tile, context) -> {
                if (tile.getState().is(ModBlocks.PLACEHOLDER)) {
                    Direction facing = (Direction)tile.getState().get(PlaceholderBlock.FACING);
                    world.m_8733_(tile.getPos(), facing.m_122435_());
                    tile.setState(PartialBlockState.of(Blocks.f_50016_.m_49966_()));
                    for (ServerPlayer player2 : world.m_8795_(player -> true)) {
                        player2.m_9158_(Level.f_46428_, tile.getPos(), facing.m_122435_(), true, false);
                    }
                }
                return tile;
            }));
            ConfiguredTemplate template = JigsawTemplate.of(version, entry, 10, random).configure(ConfiguredTemplate::new, settings);
            template.place((ServerLevelAccessor)genRegion, chunk.m_7697_());
        });
    }

    public void m_183516_(WorldGenRegion genRegion, long seed, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ChunkAccess chunk, GenerationStep.Carving step) {
    }

    public void m_6929_(WorldGenRegion world) {
        if (!((NoiseGeneratorSettings)this.settings.m_203334_()).f_64445_()) {
            ChunkPos chunkpos = world.m_143488_();
            Holder holder = world.m_204166_(chunkpos.m_45615_().m_175288_(world.m_151558_() - 1));
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
            worldgenrandom.m_64690_(world.m_7328_(), chunkpos.m_45604_(), chunkpos.m_45605_());
            NaturalSpawner.m_204175_((ServerLevelAccessor)world, (Holder)holder, (ChunkPos)chunkpos, (Random)worldgenrandom);
        }
    }

    public int m_6331_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_64508_();
    }

    public int m_6337_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_();
    }

    public int m_142062_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_158688_();
    }

    @Deprecated
    public Optional<BlockState> topMaterial(CarvingContext p_188669_, Function<BlockPos, Holder<Biome>> p_188670_, ChunkAccess p_188671_, NoiseChunk p_188672_, BlockPos p_188673_, boolean p_188674_) {
        return this.surfaceSystem.m_189971_(((NoiseGeneratorSettings)this.settings.m_203334_()).f_188871_(), p_188669_, p_188670_, p_188671_, p_188672_, p_188673_, p_188674_);
    }

    public void m_183372_(WorldGenLevel world, ChunkAccess pChunk, StructureFeatureManager structureFeatureManager) {
        ChunkPos chunkpos = pChunk.m_7697_();
        if (!structureFeatureManager.m_47271_()) {
            return;
        }
        if (SharedConstants.m_183707_((ChunkPos)chunkpos)) {
            return;
        }
        SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)chunkpos, (int)world.m_151560_());
        BlockPos blockpos = sectionpos.m_123249_();
        Registry registry = world.m_5962_().m_175515_(Registry.f_122882_);
        Map<Integer, List<ConfiguredStructureFeature>> map = registry.m_123024_().collect(Collectors.groupingBy(p_211653_ -> p_211653_.f_65403_.m_67095_().ordinal()));
        List list = this.f_62137_.m_186733_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_189328_()));
        long populationSeed = random.m_64690_(world.m_7328_(), blockpos.m_123341_(), blockpos.m_123343_());
        int j = list.size();
        try {
            int steps = Math.max(GenerationStep.Decoration.values().length, j);
            for (int step = 0; step < steps; ++step) {
                int index = 0;
                for (ConfiguredStructureFeature feature : map.getOrDefault(step, Collections.emptyList())) {
                    random.m_190064_(populationSeed, index, step);
                    Supplier<String> supplier = () -> registry.m_7854_((Object)feature).map(Object::toString).orElseGet(feature::toString);
                    try {
                        world.m_183406_(supplier);
                        structureFeatureManager.m_207794_(sectionpos, feature).forEach(p_211647_ -> p_211647_.m_7129_(world, structureFeatureManager, (ChunkGenerator)this, (Random)random, SkyVaultsChunkGenerator.getWritableArea(pChunk), chunkpos));
                    }
                    catch (Exception exception) {
                        CrashReport crashreport1 = CrashReport.m_127521_((Throwable)exception, (String)"Feature placement");
                        crashreport1.m_127514_("Feature").m_128165_("Description", supplier::get);
                        throw new ReportedException(crashreport1);
                    }
                    ++index;
                }
            }
            world.m_183406_(null);
        }
        catch (Exception exception2) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)exception2, (String)"Biome decoration");
            crashreport.m_127514_("Generation").m_128159_("CenterX", (Object)chunkpos.f_45578_).m_128159_("CenterZ", (Object)chunkpos.f_45579_).m_128159_("Seed", (Object)populationSeed);
            throw new ReportedException(crashreport);
        }
    }

    private static BoundingBox getWritableArea(ChunkAccess chunkAccess) {
        ChunkPos chunkpos = chunkAccess.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        LevelHeightAccessor levelheightaccessor = chunkAccess.m_183618_();
        int k = levelheightaccessor.m_141937_() + 1;
        int l = levelheightaccessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    public static boolean matches(Level world) {
        MinecraftServer server = world.m_142572_();
        if (server == null) {
            return false;
        }
        return server.m_129783_().m_7726_().m_8481_() instanceof SkyVaultsChunkGenerator;
    }
}

