/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card;

import iskallia.vault.core.card.modifier.card.TaskLootCardModifier;
import iskallia.vault.core.data.compound.ItemStackList;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.item.CardDeckItem;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.ResettingTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TargetTaskCounter;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.util.IProgressTask;
import iskallia.vault.task.util.TaskProgress;
import iskallia.vault.world.data.ServerVaults;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber
public class ActiveCardTaskHelper {
    private static final ActiveCardTaskHelper INSTANCE = new ActiveCardTaskHelper();
    private final Map<UUID, TaskEntry> entries = new HashMap<UUID, TaskEntry>();

    private ActiveCardTaskHelper() {
    }

    public static ActiveCardTaskHelper getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        ActiveCardTaskHelper.getInstance().entries.forEach((id, entry) -> entry.task.onDetach());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ActiveCardTaskHelper.updateTasksFromCards(server);
        ActiveCardTaskHelper.getInstance().entries.values().forEach(entry -> {
            if (entry.task().isCompleted()) {
                int completions;
                Task task = entry.task();
                UUID playerId = entry.cardTask().playerId();
                ServerPlayer player = server.m_6846_().m_11259_(playerId);
                Double overflow = null;
                if (task instanceof IProgressTask) {
                    IProgressTask progressTask = (IProgressTask)((Object)task);
                    TaskProgress progress = progressTask.getProgress();
                    double current = progress.getCurrent().doubleValue();
                    double target = progress.getTarget().doubleValue();
                    completions = (int)Math.floor(current / target);
                    double remainingProgress = current % target;
                    if (remainingProgress > 0.0) {
                        overflow = progress.getCurrent().getClass().equals(Integer.class) ? (double)((int)remainingProgress) : remainingProgress;
                    }
                } else {
                    completions = 1;
                }
                if (player != null) {
                    ServerVaults.get((Level)player.m_183503_()).ifPresent(vault -> {
                        Listener listener = vault.get(Vault.LISTENERS).get(playerId);
                        if (listener instanceof Runner) {
                            Runner runner = (Runner)listener;
                            runner.setIfAbsent(Runner.ADDITIONAL_CRATE_ITEMS, ItemStackList::create);
                            for (int i = 0; i < completions; ++i) {
                                runner.get(Runner.ADDITIONAL_CRATE_ITEMS).addAll(entry.cardTask().modifier().generateLoot(entry.cardTask().cardTier(), JavaRandom.ofNanoTime()));
                            }
                        }
                    });
                }
                if (task instanceof ResettingTask) {
                    ProgressConfiguredTask progressTask;
                    TaskCounter patt4538$temp;
                    ResettingTask resetTask = (ResettingTask)((Object)task);
                    resetTask.onReset(entry.context());
                    if (overflow != null && task instanceof ProgressConfiguredTask && (patt4538$temp = (progressTask = (ProgressConfiguredTask)task).getCounter()) instanceof TargetTaskCounter) {
                        TargetTaskCounter counter = (TargetTaskCounter)patt4538$temp;
                        Number value = overflow;
                        Number currentValue = progressTask.getProgress().getCurrent();
                        if (currentValue instanceof Integer) {
                            value = ((Number)overflow).intValue();
                        } else if (currentValue instanceof Float) {
                            value = Float.valueOf(((Number)overflow).floatValue());
                        } else if (currentValue instanceof Long) {
                            value = ((Number)overflow).longValue();
                        }
                        counter.setCurrent(value);
                    }
                }
            }
        });
    }

    private static void updateTasksFromCards(MinecraftServer server) {
        HashMap<UUID, CardTask> modifierTasks = new HashMap<UUID, CardTask>();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            ItemStack deckStack = player.getCapability(CuriosCapability.INVENTORY).map(inventory -> {
                ICurioStacksHandler slot = (ICurioStacksHandler)inventory.getCurios().get("deck");
                return slot == null ? ItemStack.f_41583_ : slot.getStacks().getStackInSlot(0);
            }).orElse(ItemStack.f_41583_);
            if (deckStack.m_41619_()) continue;
            CardDeckItem.getCardDeck(deckStack).ifPresent(deck -> deck.getCards().values().forEach(card -> card.getEntries().stream().filter(entry -> entry.getModifier() instanceof TaskLootCardModifier).map(entry -> (TaskLootCardModifier)entry.getModifier()).forEach(modifier -> modifierTasks.put(modifier.getUuid(), new CardTask((TaskLootCardModifier)modifier, card.getTier(), player.m_142081_())))));
        }
        Iterator<Map.Entry<UUID, TaskEntry>> existingTaskIterator = ActiveCardTaskHelper.getInstance().entries.entrySet().iterator();
        while (existingTaskIterator.hasNext()) {
            Map.Entry<UUID, TaskEntry> entry = existingTaskIterator.next();
            UUID taskModifierId2 = entry.getKey();
            CardTask task = (CardTask)modifierTasks.remove(taskModifierId2);
            if (task == null) {
                entry.getValue().task.onDetach();
                existingTaskIterator.remove();
                continue;
            }
            entry.getValue().context.setSource(EntityTaskSource.ofUuids(JavaRandom.ofNanoTime(), task.playerId()));
        }
        modifierTasks.forEach((taskModifierId, cardTask) -> {
            TaskEntry newEntry = new TaskEntry(cardTask.modifier().getTask(), TaskContext.of(EntityTaskSource.ofUuids(JavaRandom.ofNanoTime(), cardTask.playerId()), server), (CardTask)cardTask);
            ActiveCardTaskHelper.getInstance().entries.put((UUID)taskModifierId, newEntry);
            newEntry.task.onAttach(newEntry.context);
        });
    }

    private record CardTask(TaskLootCardModifier modifier, int cardTier, UUID playerId) {
    }

    private record TaskEntry(Task task, TaskContext context, CardTask cardTask) {
    }
}

