/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.adapter.basic.SerializableAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class Card
implements ISerializable<CompoundTag, JsonObject> {
    public static final SerializableAdapter<Card, CompoundTag, JsonObject> ADAPTER = Adapters.of(Card::new, true);
    public static Set<String> TYPES = new HashSet<String>(Arrays.asList("Arcane", "Temporal", "Resource", "Evolution", "Stat", "Wild"));
    private int tier;
    private List<CardEntry> entries;
    public static final ArrayAdapter<CardEntry> ENTRIES = Adapters.ofArray(CardEntry[]::new, Adapters.of(CardEntry::new, false));

    public Card() {
        this.tier = 1;
        this.entries = new ArrayList<CardEntry>();
    }

    public Card(int tier, List<CardEntry> entries) {
        this.tier = tier;
        this.entries = entries;
    }

    public int getTier() {
        return this.tier;
    }

    public List<CardEntry> getEntries() {
        return this.entries;
    }

    public Component getFirstName() {
        for (CardEntry entry : this.entries) {
            if (entry.getName() == null) continue;
            return entry.getName();
        }
        return null;
    }

    public Set<CardEntry.Color> getColors() {
        return this.entries.stream().flatMap(entry -> entry.getColors().stream()).collect(Collectors.toSet());
    }

    public CardEntry.Color getFirstColor() {
        for (CardEntry entry : this.entries) {
            if (entry.getColors().isEmpty()) continue;
            return entry.getColors().iterator().next();
        }
        return null;
    }

    @Nullable
    public String getFirstModel() {
        for (CardEntry entry : this.entries) {
            if (entry.getModel() == null) continue;
            return entry.getModel();
        }
        return null;
    }

    public boolean canUpgrade() {
        for (CardEntry entry : this.entries) {
            if (this.tier >= entry.getModifier().getMaxTier()) continue;
            return true;
        }
        return false;
    }

    public void onUpgrade() {
        ++this.tier;
    }

    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        tooltip.add((Component)new TextComponent("Tier: ").m_7220_((Component)new TextComponent("" + this.tier).m_6270_(Style.f_131099_.m_178520_(11583738))));
        ArrayList<CardEntry.Color> colors = new ArrayList<CardEntry.Color>(this.getColors());
        if (!colors.isEmpty()) {
            TextComponent colorText = new TextComponent("");
            for (int i = 0; i < colors.size(); ++i) {
                colorText.m_7220_(((CardEntry.Color)((Object)colors.get(i))).getColoredText());
                if (i == colors.size() - 1) continue;
                colorText.m_7220_((Component)new TextComponent(", ").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)new TextComponent("Color: ").m_7220_((Component)colorText));
        }
        ArrayList<String> groups = new ArrayList<String>(this.getGroups());
        ArrayList<String> types = new ArrayList<String>();
        for (String type : TYPES) {
            if (!groups.remove(type)) continue;
            types.add(type);
        }
        if (!types.isEmpty()) {
            TextComponent typeText = new TextComponent("");
            for (int i = 0; i < types.size(); ++i) {
                typeText.m_7220_((Component)new TextComponent((String)types.get(i)).m_130948_(Style.f_131099_.m_178520_(0xCCCCCC)));
                if (i == types.size() - 1) continue;
                typeText.m_7220_((Component)new TextComponent(", ").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)new TextComponent("Type: ").m_7220_((Component)typeText));
        }
        if (!groups.isEmpty()) {
            TextComponent groupText = new TextComponent("");
            for (int i = 0; i < groups.size(); ++i) {
                groupText.m_7220_((Component)new TextComponent((String)groups.get(i)).m_130948_(Style.f_131099_.m_178520_(0xCCCCCC)));
                if (i == groups.size() - 1) continue;
                groupText.m_7220_((Component)new TextComponent(", ").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)new TextComponent("Groups: ").m_7220_((Component)groupText));
        }
        for (CardEntry entry : this.entries) {
            entry.addText(tooltip, minIndex, flag, time, this.tier);
        }
    }

    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected) {
        for (CardEntry entry : this.entries) {
            entry.onInventoryTick(world, entity, slot, selected, this.tier);
        }
    }

    public boolean hasGroup(String group) {
        for (CardEntry entry : this.entries) {
            if (!entry.getGroups().contains(group)) continue;
            return true;
        }
        return false;
    }

    public List<String> getGroups() {
        return this.entries.stream().map(CardEntry::getGroups).flatMap(Collection::stream).distinct().toList();
    }

    public boolean hasAllGroups(Set<String> groups) {
        return groups.stream().allMatch(this.getGroups()::contains);
    }

    public CardEntry.Color getColor() {
        return this.getFirstColor();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        ENTRIES.writeBits((CardEntry)((CardEntry[])this.entries.toArray(CardEntry[]::new)), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.tier, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.entries = Arrays.stream(ENTRIES.readBits(buffer).orElse(new CardEntry[0])).collect(Collectors.toList());
        this.tier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            ENTRIES.writeNbt((CardEntry)((CardEntry[])this.entries.toArray(CardEntry[]::new))).ifPresent(tag -> nbt.m_128365_("entries", tag));
            Adapters.INT_SEGMENTED_3.writeNbt(this.tier).ifPresent(tag -> nbt.m_128365_("tier", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.entries = Arrays.stream(ENTRIES.readNbt(nbt.m_128423_("entries")).orElse(new CardEntry[0])).collect(Collectors.toList());
        this.tier = Adapters.INT_SEGMENTED_3.readNbt(nbt.m_128423_("tier")).orElse(1);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(json -> {
            ENTRIES.writeJson((CardEntry)((CardEntry[])this.entries.toArray(CardEntry[]::new))).ifPresent(tag -> json.add("entries", tag));
            Adapters.INT_SEGMENTED_3.writeJson(this.tier).ifPresent(tag -> json.add("tier", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        this.entries = Arrays.stream(ENTRIES.readJson(json.get("entries")).orElse(new CardEntry[0])).collect(Collectors.toList());
        this.tier = Adapters.INT_SEGMENTED_3.readJson(json.get("tier")).orElse(1);
    }

    public static class Config
    implements ISerializable<CompoundTag, JsonObject> {
        public static final SerializableAdapter<Config, CompoundTag, JsonObject> ADAPTER = Adapters.of(Config::new, true);
        private final Map<WeightedList<CardEntry>, Double> modifiers = new LinkedHashMap<WeightedList<CardEntry>, Double>();

        public Card generate(int tier, RandomSource random) {
            ArrayList<CardEntry> entries = new ArrayList<CardEntry>();
            this.modifiers.forEach((pool, probability) -> {
                if (random.nextDouble() >= probability) {
                    return;
                }
                pool.getRandom(random).ifPresent(entry -> {
                    entry = entry.copy();
                    CardEntry.Color[] colors = CardEntry.Color.values();
                    entry.setColors(Set.of(colors[random.nextInt(colors.length)]));
                    entries.add((CardEntry)entry);
                });
            });
            return new Card(tier, entries);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                JsonArray modifiers = new JsonArray();
                this.modifiers.forEach((pool, probability) -> {
                    JsonObject element = new JsonObject();
                    JsonArray array = new JsonArray();
                    pool.forEach((entry, weight) -> entry.writeJson().ifPresent(modifier -> {
                        Adapters.DOUBLE.writeJson(weight).ifPresent(tag -> modifier.add("weight", tag));
                        array.add((JsonElement)modifier);
                    }));
                    element.add("pool", (JsonElement)array);
                    Adapters.DOUBLE.writeJson(probability).ifPresent(tag -> element.add("probability", tag));
                    modifiers.add((JsonElement)element);
                });
                json.add("modifiers", (JsonElement)modifiers);
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.modifiers.clear();
            JsonArray modifiers = json.getAsJsonArray("modifiers");
            for (JsonElement child1 : modifiers) {
                if (!(child1 instanceof JsonObject)) continue;
                JsonObject element = (JsonObject)child1;
                JsonArray array = element.getAsJsonArray("pool");
                WeightedList<CardEntry> pool = new WeightedList<CardEntry>();
                for (JsonElement child2 : array) {
                    if (!(child2 instanceof JsonObject)) continue;
                    JsonObject modifier = (JsonObject)child2;
                    CardEntry entry = new CardEntry();
                    entry.readJson(modifier);
                    double weight = (Double)Adapters.DOUBLE.readJson(modifier.get("weight")).orElseThrow();
                    pool.put(entry, weight);
                }
                this.modifiers.put(pool, Adapters.DOUBLE.readJson(element.get("probability")).orElse(1.0));
            }
        }
    }
}

