/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardPos;
import iskallia.vault.core.card.modifier.card.CardModifier;
import iskallia.vault.core.card.modifier.card.TaskLootCardModifier;
import iskallia.vault.core.card.modifier.deck.DeckModifier;
import iskallia.vault.core.card.modifier.deck.DummyDeckModifier;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.SerializableAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.TooltipFlag;

public class CardDeck
implements ISerializable<CompoundTag, JsonObject> {
    public static final SerializableAdapter<CardDeck, CompoundTag, JsonObject> ADAPTER = Adapters.of(CardDeck::new, true);
    private UUID uuid;
    private final Map<CardPos, Card> cards;
    private final List<DeckModifier<?>> modifiers;
    private boolean isModifiersPopulated;

    public CardDeck() {
        this.cards = new LinkedHashMap<CardPos, Card>();
        this.modifiers = new ArrayList();
    }

    public CardDeck(Map<CardPos, Card> cards) {
        this.cards = new LinkedHashMap<CardPos, Card>(cards);
        this.modifiers = new ArrayList();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public Set<CardPos> getSlots() {
        return this.cards.keySet();
    }

    public Map<CardPos, Card> getCards() {
        return Collections.unmodifiableMap(this.cards);
    }

    public Optional<Card> getCard(CardPos pos) {
        return Optional.ofNullable(this.cards.get(pos));
    }

    public void setCard(CardPos pos, Card card) {
        this.cards.put(pos, card);
    }

    public List<DeckModifier<?>> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    public void addModifier(DeckModifier<?> modifier) {
        Tag cTag = DeckModifier.ADAPTER.writeNbt(modifier).orElse(null);
        if (cTag == null) {
            return;
        }
        DeckModifier copy = DeckModifier.ADAPTER.readNbt(cTag).orElse(null);
        if (copy == null) {
            return;
        }
        copy.onPopulate(this);
        this.modifiers.add(copy);
    }

    public void clearModifiers() {
        this.modifiers.clear();
    }

    public float getModifierValue(Card card, CardPos pos) {
        float value = 1.0f;
        for (DeckModifier<?> modifier : this.modifiers) {
            value *= modifier.getModifierValue(card, pos, this);
        }
        return value;
    }

    public boolean isModifiersPopulated() {
        return this.isModifiersPopulated;
    }

    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        this.getSnapshotAttributes().forEach(instance -> {
            MutableComponent text = instance.getAttribute().getReader().getDisplay(instance, VaultGearModifier.AffixType.PREFIX);
            tooltip.add((Component)text);
        });
        this.cards.forEach((pos, card) -> {
            if (card == null) {
                return;
            }
            for (CardEntry entry : card.getEntries()) {
                CardModifier<?> patt3725$temp = entry.getModifier();
                if (!(patt3725$temp instanceof TaskLootCardModifier)) continue;
                TaskLootCardModifier modifier = (TaskLootCardModifier)patt3725$temp;
                modifier.addText(tooltip, minIndex, flag, time, card.getTier());
            }
        });
        if (!this.modifiers.stream().filter(modifier -> !(modifier instanceof DummyDeckModifier)).toList().isEmpty()) {
            tooltip.add((Component)new TextComponent(""));
            tooltip.add((Component)new TextComponent("Modifiers:").m_130940_(ChatFormatting.GRAY));
            this.modifiers.forEach(modifier -> modifier.addText(tooltip, minIndex, flag, time));
        }
    }

    private double getNumericValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public List<VaultGearAttributeInstance<?>> getSnapshotAttributes() {
        ArrayList attributes = new ArrayList();
        LinkedHashMap<VaultGearAttribute, List> merged = new LinkedHashMap<VaultGearAttribute, List>();
        this.getCards().forEach((pos, card) -> {
            if (card == null) {
                return;
            }
            for (CardEntry entry : card.getEntries()) {
                entry.getSnapshotAttributes(card.getTier(), (CardPos)pos, this).forEach(instance -> {
                    float modifierValue = this.getModifierValue((Card)card, (CardPos)pos);
                    Object modifiedValue = instance.getValue();
                    if (modifiedValue instanceof Number) {
                        if (modifiedValue instanceof Float) {
                            modifiedValue = Float.valueOf(((Float)modifiedValue).floatValue() * modifierValue);
                        } else if (modifiedValue instanceof Double) {
                            modifiedValue = (Double)modifiedValue * (double)modifierValue;
                        } else if (modifiedValue instanceof Integer) {
                            modifiedValue = (int)((float)((Integer)modifiedValue).intValue() * modifierValue);
                        } else if (modifiedValue instanceof Long) {
                            modifiedValue = (long)((float)((Long)modifiedValue).longValue() * modifierValue);
                        }
                    }
                    List values = merged.computeIfAbsent(instance.getAttribute(), k -> new ArrayList());
                    VaultGearAttributeComparator comparator = instance.getAttribute().getAttributeComparator();
                    if (comparator == null || values.isEmpty()) {
                        values.add(modifiedValue);
                        return;
                    }
                    for (int i = 0; i < values.size(); ++i) {
                        Object result = comparator.merge(values.get(i), modifiedValue).orElse(null);
                        if (result == null) continue;
                        values.set(i, result);
                        return;
                    }
                    values.add(modifiedValue);
                });
            }
        });
        merged.forEach((attribute, values) -> {
            for (Object value : values) {
                attributes.add(new VaultGearAttributeInstance(attribute, value));
            }
        });
        attributes.sort((a, b) -> {
            double valueA = this.getNumericValue(a.getValue());
            double valueB = this.getNumericValue(b.getValue());
            return Double.compare(valueB, valueA);
        });
        return attributes;
    }

    public CardPos getMinSlot() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (CardPos pos : this.cards.keySet()) {
            if (pos.x < minX) {
                minX = pos.x;
            }
            if (pos.y >= minY) continue;
            minY = pos.y;
        }
        return new CardPos(minX, minY);
    }

    public CardPos getMaxSlot() {
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (CardPos pos : this.cards.keySet()) {
            if (pos.x > maxX) {
                maxX = pos.x;
            }
            if (pos.y <= maxY) continue;
            maxY = pos.y;
        }
        return new CardPos(maxX, maxY);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.UUID.writeBits(this.uuid, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.cards.size(), buffer);
        this.cards.forEach((pos, card) -> {
            CardPos.ADAPTER.writeBits((CardPos)pos, buffer);
            Card.ADAPTER.writeBits((Card)card, buffer);
        });
        Adapters.INT_SEGMENTED_7.writeBits(this.modifiers.size(), buffer);
        for (DeckModifier<?> modifier : this.modifiers) {
            DeckModifier.ADAPTER.writeBits(modifier, buffer);
        }
        Adapters.BOOLEAN.writeBits(this.isModifiersPopulated, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.uuid = Adapters.UUID.readBits(buffer).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.cards.clear();
        for (int i = 0; i < size; ++i) {
            this.cards.put(CardPos.ADAPTER.readBits(buffer).orElseThrow(), Card.ADAPTER.readBits(buffer).orElse(null));
        }
        this.modifiers.clear();
        int modifierSize = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        for (int i = 0; i < modifierSize; ++i) {
            DeckModifier.ADAPTER.readBits(buffer).ifPresent(this.modifiers::add);
        }
        this.isModifiersPopulated = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            Adapters.UUID.writeNbt(this.uuid).ifPresent(tag -> nbt.m_128365_("uuid", tag));
            ListTag cards = new ListTag();
            this.cards.forEach((pos, card) -> {
                CompoundTag entry = new CompoundTag();
                CardPos.ADAPTER.writeNbt((CardPos)pos).ifPresent(tag -> entry.m_128365_("pos", tag));
                Card.ADAPTER.writeNbt((Card)card).ifPresent(tag -> entry.m_128365_("card", (Tag)tag));
                cards.add((Object)entry);
            });
            nbt.m_128365_("cards", (Tag)cards);
            ListTag modifiers = new ListTag();
            for (DeckModifier<?> modifier : this.modifiers) {
                DeckModifier.ADAPTER.writeNbt(modifier).ifPresent(arg_0 -> modifiers.add(arg_0));
            }
            nbt.m_128365_("modifiers", (Tag)modifiers);
            nbt.m_128379_("isModifiersPopulated", this.isModifiersPopulated);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.uuid = Adapters.UUID.readNbt(nbt.m_128423_("uuid")).orElseGet(Mth::m_14002_);
        ListTag cards = nbt.m_128437_("cards", 10);
        for (int i = 0; i < cards.size(); ++i) {
            CompoundTag entry = cards.m_128728_(i);
            this.cards.put(CardPos.ADAPTER.readNbt(entry.m_128423_("pos")).orElseThrow(), Card.ADAPTER.readNbt(entry.m_128469_("card")).orElse(null));
        }
        this.modifiers.clear();
        ListTag modifiers = nbt.m_128437_("modifiers", 10);
        for (int i = 0; i < modifiers.size(); ++i) {
            CompoundTag entry = modifiers.m_128728_(i);
            DeckModifier.ADAPTER.readNbt((Tag)entry).ifPresent(this.modifiers::add);
        }
        this.isModifiersPopulated = nbt.m_128471_("isModifiersPopulated");
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(nbt -> {
            Adapters.UUID.writeJson(this.uuid).ifPresent(tag -> nbt.add("uuid", tag));
            JsonArray cards = new JsonArray();
            this.cards.forEach((pos, card) -> {
                JsonObject entry = new JsonObject();
                CardPos.ADAPTER.writeJson((CardPos)pos).ifPresent(tag -> entry.add("pos", tag));
                Card.ADAPTER.writeJson((Card)card).ifPresent(tag -> entry.add("card", (JsonElement)tag));
                cards.add((JsonElement)entry);
            });
            nbt.add("cards", (JsonElement)cards);
            JsonArray modifiers = new JsonArray();
            for (DeckModifier<?> modifier : this.modifiers) {
                DeckModifier.ADAPTER.writeJson(modifier).ifPresent(tag -> modifiers.add(tag));
            }
            nbt.add("modifiers", (JsonElement)modifiers);
            nbt.addProperty("isModifiersPopulated", Boolean.valueOf(this.isModifiersPopulated));
            return nbt;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        this.uuid = Adapters.UUID.readJson(json.get("uuid")).orElseGet(Mth::m_14002_);
        JsonArray cards = json.getAsJsonArray("cards");
        for (int i = 0; i < cards.size(); ++i) {
            JsonObject entry = cards.get(i).getAsJsonObject();
            this.cards.put(CardPos.ADAPTER.readJson(entry.get("pos")).orElse(null), Card.ADAPTER.readJson(entry.getAsJsonObject("card")).orElseThrow());
        }
        this.modifiers.clear();
        JsonArray modifiers = json.getAsJsonArray("modifiers");
        for (int i = 0; i < modifiers.size(); ++i) {
            JsonObject entry = modifiers.get(i).getAsJsonObject();
            DeckModifier.ADAPTER.readJson((JsonElement)entry).ifPresent(this.modifiers::add);
        }
        this.isModifiersPopulated = json.get("isModifiersPopulated").getAsBoolean();
    }

    public void setModifiersPopulated(boolean b) {
        this.isModifiersPopulated = b;
    }
}

