/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card;

import iskallia.vault.core.card.CardDeck;
import iskallia.vault.core.card.CardPos;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.network.chat.TextComponent;

public enum CardNeighborType {
    ROW("Row", (origin, deck) -> {
        HashSet<CardPos> neighbors = new HashSet<CardPos>();
        int min = deck.getMinSlot().x;
        int max = deck.getMaxSlot().x;
        for (int x = min; x <= max; ++x) {
            CardPos pos = new CardPos(x, origin.y);
            if (!deck.getSlots().contains(pos)) continue;
            neighbors.add(pos);
        }
        return neighbors;
    }),
    COLUMN("Column", (origin, deck) -> {
        HashSet<CardPos> neighbors = new HashSet<CardPos>();
        int min = deck.getMinSlot().y;
        int max = deck.getMaxSlot().y;
        for (int y = min; y <= max; ++y) {
            CardPos pos = new CardPos(origin.x, y);
            if (!deck.getSlots().contains(pos)) continue;
            neighbors.add(pos);
        }
        return neighbors;
    }),
    DIAGONAL("Diagonal", (origin, deck) -> {
        HashSet<CardPos> neighbors = new HashSet<CardPos>();
        int i = 1;
        while (true) {
            List<CardPos> offsets = Arrays.asList(origin.add(i, i), origin.add(-i, i), origin.add(i, -i), origin.add(-i, -i));
            int done = 0;
            for (CardPos offset : offsets) {
                if (offset.x < deck.getMinSlot().x || offset.x > deck.getMaxSlot().x || offset.y < deck.getMinSlot().y || offset.y > deck.getMaxSlot().y) {
                    ++done;
                    continue;
                }
                neighbors.add(offset);
            }
            if (done == 4) break;
            ++i;
        }
        return neighbors;
    }),
    ADJACENT("Adjacent", (origin, deck) -> {
        HashSet<CardPos> neighbors = new HashSet<CardPos>();
        if (deck.getSlots().contains(origin.add(1, 0))) {
            neighbors.add(origin.add(1, 0));
        }
        if (deck.getSlots().contains(origin.add(-1, 0))) {
            neighbors.add(origin.add(-1, 0));
        }
        if (deck.getSlots().contains(origin.add(0, 1))) {
            neighbors.add(origin.add(0, 1));
        }
        if (deck.getSlots().contains(origin.add(0, -1))) {
            neighbors.add(origin.add(0, -1));
        }
        return neighbors;
    }),
    SURROUNDING("Surrounding", (origin, deck) -> {
        HashSet<CardPos> neighbors = new HashSet<CardPos>(ADJACENT.get((CardPos)origin, (CardDeck)deck));
        if (deck.getSlots().contains(origin.add(1, 1))) {
            neighbors.add(origin.add(1, 1));
        }
        if (deck.getSlots().contains(origin.add(-1, 1))) {
            neighbors.add(origin.add(-1, 1));
        }
        if (deck.getSlots().contains(origin.add(1, -1))) {
            neighbors.add(origin.add(1, -1));
        }
        if (deck.getSlots().contains(origin.add(-1, -1))) {
            neighbors.add(origin.add(-1, -1));
        }
        return neighbors;
    });

    private String name;
    private BiFunction<CardPos, CardDeck, Set<CardPos>> supplier;

    private CardNeighborType(String name, BiFunction<CardPos, CardDeck, Set<CardPos>> supplier) {
        this.name = name;
        this.supplier = supplier;
    }

    Set<CardPos> get(CardPos origin, CardDeck deck) {
        return this.supplier.apply(origin, deck);
    }

    public TextComponent getText() {
        return new TextComponent(this.name);
    }
}

