/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class CardProperty<C extends Config>
implements ISerializable<CompoundTag, JsonObject> {
    private C config;
    private boolean populated;

    public CardProperty(C config) {
        this.config = config;
    }

    public C getConfig() {
        return this.config;
    }

    public void setConfig(C config) {
        this.config = config;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void setPopulated(boolean populated) {
        this.populated = populated;
    }

    public boolean onPopulate() {
        boolean result = !this.isPopulated();
        this.setPopulated(true);
        return result;
    }

    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time, int tier) {
    }

    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected, int tier) {
        if (!this.populated) {
            this.onPopulate();
        }
    }

    public abstract boolean voidConfigIfPopulated();

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.BOOLEAN.writeBits(this.populated, buffer);
        if (!this.voidConfigIfPopulated() || !this.populated) {
            ((Config)this.config).writeBits(buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.populated = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        if (!this.voidConfigIfPopulated() || !this.populated) {
            ((Config)this.config).readBits(buffer);
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            if (!this.populated) {
                CompoundTag other = ((Config)this.config).writeNbt().orElseThrow();
                other.m_128431_().forEach(key -> nbt.m_128365_(key, Objects.requireNonNull(other.m_128423_(key))));
            } else if (this.voidConfigIfPopulated()) {
                nbt.m_128365_("config", (Tag)new CompoundTag());
            } else {
                nbt.m_128365_("config", (Tag)((Config)this.config).writeNbt().orElseThrow());
            }
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        if (!nbt.m_128441_("config")) {
            ((Config)this.config).readNbt(nbt);
            this.populated = false;
        } else {
            ((Config)this.config).readNbt(nbt.m_128469_("config"));
            this.populated = true;
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(json -> {
            if (!this.populated) {
                ((Config)this.config).writeJson().orElseThrow().entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            } else {
                json.add("config", (JsonElement)((Config)this.config).writeJson().orElseThrow());
            }
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        if (!json.has("config")) {
            ((Config)this.config).readJson(json);
            this.populated = false;
        } else {
            ((Config)this.config).readJson(json.getAsJsonObject("config"));
            this.populated = true;
        }
    }

    public static class Config
    implements ISerializable<CompoundTag, JsonObject> {
        @Override
        public void writeBits(BitBuffer buffer) {
        }

        @Override
        public void readBits(BitBuffer buffer) {
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag());
        }

        @Override
        public void readNbt(CompoundTag nbt) {
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject());
        }

        @Override
        public void readJson(JsonObject json) {
        }
    }
}

