/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardDeck;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardNeighborType;
import iskallia.vault.core.card.CardPos;
import iskallia.vault.core.card.CardProperty;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.basic.SerializableAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class CardScaler
extends CardProperty<Config> {
    public static final SerializableAdapter<CardScaler, CompoundTag, JsonObject> ADAPTER = Adapters.of(CardScaler::new, true);
    private final Map<Integer, List<Filter>> filters = new LinkedHashMap<Integer, List<Filter>>();

    public CardScaler() {
        super(new Config());
    }

    public CardScaler(Config config) {
        super(config);
    }

    @Override
    public boolean onPopulate() {
        if (!super.onPopulate()) {
            return false;
        }
        JavaRandom random = JavaRandom.ofNanoTime();
        ((Config)this.getConfig()).tiers.forEach((tier, config) -> config.getRandom(random).ifPresent(filters -> this.filters.put((Integer)tier, filters.stream().map(filter -> filter.generate(random)).toList())));
        return true;
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time, int tier) {
        for (Filter filter : (List)CardEntry.getForTier(this.filters, tier).orElse(new ArrayList())) {
            ArrayList<TextComponent> parts = new ArrayList<TextComponent>();
            if (filter.colorFilter != null) {
                filter.colorFilter.stream().map(CardEntry.Color::getColoredText).reduce((c1, c2) -> new TextComponent("").m_7220_(c1).m_7220_((Component)new TextComponent(" or ").m_130940_(ChatFormatting.GRAY)).m_7220_(c2)).ifPresent(parts::add);
            }
            if (filter.neighborFilter != null) {
                filter.neighborFilter.stream().map(type -> type.getText().m_130940_(ChatFormatting.WHITE)).reduce((c1, c2) -> new TextComponent("").m_7220_((Component)c1).m_7220_((Component)new TextComponent(" or ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)c2)).ifPresent(parts::add);
            }
            if (filter.groupFilter != null) {
                filter.groupFilter.stream().map(s -> new TextComponent(s).m_130940_(ChatFormatting.WHITE)).reduce((c1, c2) -> new TextComponent("").m_7220_((Component)c1).m_7220_((Component)new TextComponent(" or ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)c2)).ifPresent(parts::add);
            }
            if (filter.tierFilter != null) {
                Integer min = filter.tierFilter.stream().min(Integer::compareTo).orElse(null);
                Integer max = filter.tierFilter.stream().max(Integer::compareTo).orElse(null);
                if (min != null) {
                    parts.add(new TextComponent(min.equals(max) ? "Tier " + min : "Tier " + min + "-" + max));
                }
            }
            TextComponent text = new TextComponent("");
            text.m_7220_((Component)new TextComponent(" > For Each ").m_130940_(ChatFormatting.GRAY));
            for (int i = 0; i < parts.size(); ++i) {
                text.m_7220_((Component)parts.get(i));
                if (i == parts.size() - 1) continue;
                text.m_7220_((Component)new TextComponent(", ").m_130940_(ChatFormatting.GRAY));
            }
            text.m_7220_((Component)new TextComponent(parts.isEmpty() ? "Card" : " Card").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)text);
        }
    }

    @Override
    public boolean voidConfigIfPopulated() {
        return true;
    }

    public int getFrequency(int tier, CardPos origin, CardDeck deck) {
        int total = 0;
        for (Filter filter : (List)CardEntry.getForTier(this.filters, tier).orElse(new ArrayList())) {
            Set<CardPos> filteredCards = CardScaler.getFilteredCards(origin, deck, filter);
            HashSet<CardEntry> filteredEntries = new HashSet<CardEntry>();
            filteredCards.forEach(pos -> deck.getCard((CardPos)pos).ifPresent(card -> filteredEntries.addAll(card.getEntries())));
            if (filter.colorFilter != null) {
                filteredEntries.removeIf(entry -> filter.colorFilter.stream().noneMatch(color -> entry.getColors().contains(color)));
            }
            if (filter.groupFilter != null) {
                filteredEntries.removeIf(entry -> filter.groupFilter.stream().noneMatch(group -> entry.getGroups().contains(group)));
            }
            total += filteredEntries.size();
        }
        return total;
    }

    private static Set<CardPos> getFilteredCards(CardPos origin, CardDeck deck, Filter filter) {
        HashSet<CardPos> filteredCards = new HashSet<CardPos>();
        if (filter.neighborFilter != null) {
            for (CardNeighborType cardNeighborType : filter.neighborFilter) {
                filteredCards.addAll(cardNeighborType.get(origin, deck));
            }
        } else {
            filteredCards.addAll(deck.getSlots());
            filteredCards.remove(origin);
        }
        if (filter.tierFilter != null) {
            filteredCards.removeIf(pos -> {
                Card card = deck.getCard((CardPos)pos).orElse(null);
                return card == null || !filter.tierFilter.contains(card.getTier());
            });
        }
        return filteredCards;
    }

    public List<CardPos> getMatchingNeighbors(int tier, CardPos origin, CardDeck deck) {
        ArrayList<CardPos> matchingNeighbors = new ArrayList<CardPos>();
        for (Filter filter : (List)CardEntry.getForTier(this.filters, tier).orElse(new ArrayList())) {
            Set<CardPos> filteredCards = CardScaler.getFilteredCards(origin, deck, filter);
            HashMap<CardPos, Set> filteredPosEntries = new HashMap<CardPos, Set>();
            filteredCards.forEach(pos -> deck.getCard((CardPos)pos).ifPresent(card -> filteredPosEntries.put((CardPos)pos, new HashSet<CardEntry>(card.getEntries()))));
            if (filter.colorFilter != null) {
                filteredPosEntries.forEach((pos, entries) -> entries.removeIf(entry -> filter.colorFilter.stream().noneMatch(color -> entry.getColors().contains(color))));
            }
            if (filter.groupFilter != null) {
                filteredPosEntries.forEach((pos, entries) -> entries.removeIf(entry -> filter.groupFilter.stream().noneMatch(group -> entry.getGroups().contains(group))));
            }
            filteredPosEntries.entrySet().stream().filter(entry -> !((Set)entry.getValue()).isEmpty()).forEach(entry -> matchingNeighbors.add((CardPos)entry.getKey()));
        }
        return matchingNeighbors;
    }

    public CardScaler copy() {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        this.writeBits(buffer);
        buffer.setPosition(0);
        CardScaler copy = new CardScaler();
        copy.readBits(buffer);
        return copy;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        Adapters.INT_SEGMENTED_3.writeBits(this.filters.size(), buffer);
        this.filters.forEach((tier, filters) -> {
            Adapters.INT_SEGMENTED_3.writeBits(tier, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(filters.size(), buffer);
            filters.forEach(filter -> filter.writeBits(buffer));
        });
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        this.filters.clear();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            int tier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            int filterSize = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (int j = 0; j < filterSize; ++j) {
                Filter filter = new Filter();
                filter.readBits(buffer);
                filters.add(filter);
            }
            this.filters.put(tier, filters);
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (!this.isPopulated()) {
                return nbt;
            }
            ListTag filtersTag = new ListTag();
            this.filters.forEach((tier, filters) -> {
                CompoundTag entry = new CompoundTag();
                Adapters.INT.writeNbt(tier).ifPresent(tag -> entry.m_128365_("tier", tag));
                ListTag valueTag = new ListTag();
                for (Filter filter : filters) {
                    filter.writeNbt().ifPresent(arg_0 -> valueTag.add(arg_0));
                }
                entry.m_128365_("value", (Tag)valueTag);
                filtersTag.add((Object)entry);
            });
            nbt.m_128365_("filters", (Tag)filtersTag);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        if (!this.isPopulated()) {
            return;
        }
        this.filters.clear();
        ListTag filtersTag = nbt.m_128437_("filters", 10);
        for (int i = 0; i < filtersTag.size(); ++i) {
            CompoundTag entry = filtersTag.m_128728_(i);
            int tier = (Integer)Adapters.INT.readNbt(entry.m_128423_("tier")).orElseThrow();
            ListTag valueTag = entry.m_128437_("value", 10);
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (int j = 0; j < valueTag.size(); ++j) {
                Filter filter = new Filter();
                filter.readNbt(valueTag.m_128728_(j));
                filters.add(filter);
            }
            this.filters.put(tier, filters);
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            if (!this.isPopulated()) {
                return json;
            }
            JsonArray filtersTag = new JsonArray();
            this.filters.forEach((tier, filters) -> {
                JsonObject entry = new JsonObject();
                Adapters.INT.writeJson(tier).ifPresent(tag -> entry.add("tier", tag));
                JsonArray valueTag = new JsonArray();
                for (Filter filter : filters) {
                    filter.writeJson().ifPresent(arg_0 -> ((JsonArray)valueTag).add(arg_0));
                }
                entry.add("value", (JsonElement)valueTag);
                filtersTag.add((JsonElement)entry);
            });
            json.add("filters", (JsonElement)filtersTag);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        if (!this.isPopulated()) {
            return;
        }
        this.filters.clear();
        JsonArray filtersTag = json.getAsJsonArray("filters");
        for (int i = 0; i < filtersTag.size(); ++i) {
            JsonObject entry = filtersTag.get(i).getAsJsonObject();
            int tier = (Integer)Adapters.INT.readJson(entry.get("tier")).orElseThrow();
            JsonArray valueTag = entry.getAsJsonArray("value");
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (int j = 0; j < valueTag.size(); ++j) {
                Filter filter = new Filter();
                filter.readJson(valueTag.get(j).getAsJsonObject());
                filters.add(filter);
            }
            this.filters.put(tier, filters);
        }
    }

    public static class Config
    extends CardProperty.Config {
        private final Map<Integer, WeightedList<List<Filter.Config>>> tiers;

        public Config() {
            this.tiers = new LinkedHashMap<Integer, WeightedList<List<Filter.Config>>>();
        }

        public Config(Map<Integer, WeightedList<List<Filter.Config>>> tiers) {
            this.tiers = tiers;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.tiers.size(), buffer);
            this.tiers.forEach((tier, pool) -> {
                Adapters.INT_SEGMENTED_3.writeBits(tier, buffer);
                Adapters.INT_SEGMENTED_3.writeBits(pool.size(), buffer);
                pool.forEach((filters, weight) -> {
                    Adapters.INT_SEGMENTED_3.writeBits(filters.size(), buffer);
                    for (Filter.Config filter : filters) {
                        filter.writeBits(buffer);
                    }
                    Adapters.DOUBLE.writeBits(weight, buffer);
                });
            });
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.tiers.clear();
            int tiersSize = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            for (int i = 0; i < tiersSize; ++i) {
                int tier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
                WeightedList pool = new WeightedList();
                int poolSize = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
                for (int j = 0; j < poolSize; ++j) {
                    int filtersSize = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
                    ArrayList<Filter.Config> filters = new ArrayList<Filter.Config>();
                    for (int k = 0; k < filtersSize; ++k) {
                        Filter.Config config = new Filter.Config();
                        config.readBits(buffer);
                        filters.add(config);
                    }
                    pool.put(filters, (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow());
                }
                this.tiers.put(tier, pool);
            }
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                ListTag tiersTag = new ListTag();
                this.tiers.forEach((tier, pool) -> {
                    CompoundTag tierEntry = new CompoundTag();
                    Adapters.INT.writeNbt(tier).ifPresent(tag -> tierEntry.m_128365_("tier", tag));
                    ListTag poolTag = new ListTag();
                    pool.forEach((filters, weight) -> {
                        CompoundTag poolEntry = new CompoundTag();
                        ListTag filtersTag = new ListTag();
                        for (Filter.Config filter : filters) {
                            Filter.Config.ADAPTER.writeNbt(filter).ifPresent(arg_0 -> filtersTag.add(arg_0));
                        }
                        poolEntry.m_128365_("filters", (Tag)filtersTag);
                        Adapters.DOUBLE.writeNbt(weight).ifPresent(tag -> poolEntry.m_128365_("weight", tag));
                        poolTag.add((Object)poolEntry);
                    });
                    tierEntry.m_128365_("pool", (Tag)poolTag);
                    tiersTag.add((Object)tierEntry);
                });
                nbt.m_128365_("tiers", (Tag)tiersTag);
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.tiers.clear();
            ListTag tiersTag = nbt.m_128437_("tiers", 10);
            for (int i = 0; i < tiersTag.size(); ++i) {
                CompoundTag tierEntry = tiersTag.m_128728_(i);
                int tier = (Integer)Adapters.INT.readNbt(tierEntry.m_128423_("tier")).orElseThrow();
                ListTag poolTag = tierEntry.m_128437_("pool", 10);
                WeightedList pool = new WeightedList();
                for (int j = 0; j < poolTag.size(); ++j) {
                    CompoundTag poolEntry = poolTag.m_128728_(j);
                    ListTag filtersTag = poolEntry.m_128437_("filters", 10);
                    ArrayList<Filter.Config> filters = new ArrayList<Filter.Config>();
                    double weight = (Double)Adapters.DOUBLE.readNbt(poolEntry.m_128423_("weight")).orElseThrow();
                    for (int k = 0; k < filtersTag.size(); ++k) {
                        Filter.Config config = new Filter.Config();
                        config.readNbt(filtersTag.m_128728_(k));
                        filters.add(config);
                    }
                    pool.put(filters, weight);
                }
                this.tiers.put(tier, pool);
            }
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                JsonArray tiersTag = new JsonArray();
                this.tiers.forEach((tier, pool) -> {
                    JsonObject tierEntry = new JsonObject();
                    Adapters.INT.writeJson(tier).ifPresent(tag -> tierEntry.add("tier", tag));
                    JsonArray poolTag = new JsonArray();
                    pool.forEach((filters, weight) -> {
                        JsonObject poolEntry = new JsonObject();
                        JsonArray filtersTag = new JsonArray();
                        for (Filter.Config filter : filters) {
                            Filter.Config.ADAPTER.writeJson(filter).ifPresent(arg_0 -> ((JsonArray)filtersTag).add(arg_0));
                        }
                        poolEntry.add("filters", (JsonElement)filtersTag);
                        Adapters.DOUBLE.writeJson(weight).ifPresent(tag -> poolEntry.add("weight", tag));
                        poolTag.add((JsonElement)poolEntry);
                    });
                    tierEntry.add("pool", (JsonElement)poolTag);
                    tiersTag.add((JsonElement)tierEntry);
                });
                json.add("tiers", (JsonElement)tiersTag);
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.tiers.clear();
            JsonArray tiersTag = json.get("tiers").getAsJsonArray();
            for (int i = 0; i < tiersTag.size(); ++i) {
                JsonObject tierEntry = tiersTag.get(i).getAsJsonObject();
                int tier = (Integer)Adapters.INT.readJson(tierEntry.get("tier")).orElseThrow();
                JsonArray poolTag = tierEntry.get("pool").getAsJsonArray();
                WeightedList pool = new WeightedList();
                for (int j = 0; j < poolTag.size(); ++j) {
                    JsonObject poolEntry = poolTag.get(j).getAsJsonObject();
                    JsonArray filtersTag = poolEntry.get("filters").getAsJsonArray();
                    ArrayList<Filter.Config> filters = new ArrayList<Filter.Config>();
                    double weight = (Double)Adapters.DOUBLE.readJson(poolEntry.get("weight")).orElseThrow();
                    for (int k = 0; k < filtersTag.size(); ++k) {
                        Filter.Config config = new Filter.Config();
                        config.readJson(filtersTag.get(k).getAsJsonObject());
                        filters.add(config);
                    }
                    pool.put(filters, weight);
                }
                this.tiers.put(tier, pool);
            }
        }
    }

    public static class Filter
    implements ISerializable<CompoundTag, JsonObject> {
        private Set<CardNeighborType> neighborFilter;
        private Set<Integer> tierFilter;
        private Set<CardEntry.Color> colorFilter;
        private Set<String> groupFilter;

        public Filter() {
        }

        public Filter(Set<CardNeighborType> neighborFilter, Set<Integer> tierFilter, Set<CardEntry.Color> colorFilter, Set<String> groupFilter) {
            this.neighborFilter = neighborFilter;
            this.tierFilter = tierFilter;
            this.colorFilter = colorFilter;
            this.groupFilter = groupFilter;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Stream.of("neighborFilter", "tierFilter", "colorFilter", "groupFilter").forEach(key -> {
                Set set = this.getSet((String)key);
                Adapters.BOOLEAN.writeBits(set == null, buffer);
                if (set != null) {
                    Adapters.INT_SEGMENTED_3.writeBits(set.size(), buffer);
                    set.forEach(value -> this.getElementAdapter((String)key).writeBits(value, buffer));
                }
            });
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Stream.of("neighborFilter", "tierFilter", "colorFilter", "groupFilter").forEach(key -> {
                HashSet<Object> set = new HashSet<Object>();
                if (!Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
                    this.deserialize((String)key, null);
                    return;
                }
                int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
                for (int j = 0; j < size; ++j) {
                    set.add(this.getElementAdapter((String)key).readBits(buffer).orElseThrow());
                }
                this.deserialize((String)key, set);
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Stream.of("neighborFilter", "tierFilter", "colorFilter", "groupFilter").forEach(key -> {
                    Set set = this.getSet((String)key);
                    if (set != null) {
                        ListTag setTag = new ListTag();
                        set.forEach(value -> this.getElementAdapter((String)key).writeNbt(value).ifPresent(arg_0 -> setTag.add(arg_0)));
                        nbt.m_128365_(this.getKey(set), (Tag)setTag);
                    }
                });
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Stream.of("neighborFilter", "tierFilter", "colorFilter", "groupFilter").forEach(key -> {
                Tag patt18692$temp = nbt.m_128423_(key);
                if (patt18692$temp instanceof ListTag) {
                    ListTag setTag = (ListTag)patt18692$temp;
                    HashSet set = new HashSet();
                    for (int i = 0; i < setTag.size(); ++i) {
                        this.getElementAdapter((String)key).readNbt((Tag)setTag.get(i)).ifPresent(object -> set.add(object));
                    }
                    this.deserialize((String)key, set);
                } else {
                    this.deserialize((String)key, null);
                }
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                Stream.of("neighborFilter", "tierFilter", "colorFilter", "groupFilter").forEach(key -> {
                    Set set = this.getSet((String)key);
                    if (set != null) {
                        JsonArray setTag = new JsonArray();
                        set.forEach(value -> this.getElementAdapter((String)key).writeJson(value).ifPresent(arg_0 -> ((JsonArray)setTag).add(arg_0)));
                        json.add(this.getKey(set), (JsonElement)setTag);
                    }
                });
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            Stream.of("neighborFilter", "tierFilter", "colorFilter", "groupFilter").forEach(key -> {
                JsonElement patt20116$temp = json.get(key);
                if (patt20116$temp instanceof JsonArray) {
                    JsonArray setTag = (JsonArray)patt20116$temp;
                    HashSet set = new HashSet();
                    for (int i = 0; i < setTag.size(); ++i) {
                        this.getElementAdapter((String)key).readJson((JsonElement)setTag.get(i)).ifPresent(object -> set.add(object));
                    }
                    this.deserialize((String)key, set);
                } else {
                    this.deserialize((String)key, null);
                }
            });
        }

        public String getKey(Set<?> set) {
            if (set == this.neighborFilter) {
                return "neighborFilter";
            }
            if (set == this.tierFilter) {
                return "tierFilter";
            }
            if (set == this.colorFilter) {
                return "colorFilter";
            }
            if (set == this.groupFilter) {
                return "groupFilter";
            }
            throw new UnsupportedOperationException();
        }

        private Set getSet(String key) {
            if ("neighborFilter".equals(key)) {
                return this.neighborFilter;
            }
            if ("tierFilter".equals(key)) {
                return this.tierFilter;
            }
            if ("colorFilter".equals(key)) {
                return this.colorFilter;
            }
            if ("groupFilter".equals(key)) {
                return this.groupFilter;
            }
            throw new UnsupportedOperationException();
        }

        public ISimpleAdapter<Object, ? extends Tag, ? extends JsonElement> getElementAdapter(String key) {
            if ("neighborFilter".equals(key)) {
                return Adapters.ofEnum(CardNeighborType.class, EnumAdapter.Mode.NAME);
            }
            if ("tierFilter".equals(key)) {
                return Adapters.INT_SEGMENTED_3;
            }
            if ("colorFilter".equals(key)) {
                return Adapters.ofEnum(CardEntry.Color.class, EnumAdapter.Mode.NAME);
            }
            if ("groupFilter".equals(key)) {
                return Adapters.UTF_8;
            }
            throw new UnsupportedOperationException();
        }

        private void deserialize(String key, Set set) {
            if ("neighborFilter".equals(key)) {
                this.neighborFilter = set;
            } else if ("tierFilter".equals(key)) {
                this.tierFilter = set;
            } else if ("colorFilter".equals(key)) {
                this.colorFilter = set;
            } else if ("groupFilter".equals(key)) {
                this.groupFilter = set;
            }
        }

        public static class Config
        implements ISerializable<CompoundTag, JsonObject> {
            public static final SerializableAdapter<Config, CompoundTag, JsonObject> ADAPTER = Adapters.of(Config::new, false);
            private WeightedList<Set<CardNeighborType>> neighborFilter;
            private WeightedList<Set<Integer>> tierFilter;
            private WeightedList<Set<CardEntry.Color>> colorFilter;
            private WeightedList<Set<String>> groupFilter;

            public Config() {
                this.neighborFilter = new WeightedList();
                this.tierFilter = new WeightedList();
                this.colorFilter = new WeightedList();
                this.groupFilter = new WeightedList();
            }

            public Config(WeightedList<Set<CardNeighborType>> neighborFilter, WeightedList<Set<Integer>> tierFilter, WeightedList<Set<CardEntry.Color>> colorFilter, WeightedList<Set<String>> groupFilter) {
                this.neighborFilter = neighborFilter;
                this.tierFilter = tierFilter;
                this.colorFilter = colorFilter;
                this.groupFilter = groupFilter;
            }

            public Filter generate(RandomSource random) {
                return new Filter(this.neighborFilter.getRandom(random).orElse(null), this.tierFilter.getRandom(random).orElse(null), this.colorFilter.getRandom(random).orElse(null), this.groupFilter.getRandom(random).orElse(null));
            }

            @Override
            public void writeBits(BitBuffer buffer) {
                Stream.of(this.neighborFilter, this.tierFilter, this.colorFilter, this.groupFilter).forEach(list -> {
                    Adapters.INT_SEGMENTED_3.writeBits(list.size(), buffer);
                    list.forEach((set, weight) -> {
                        Adapters.BOOLEAN.writeBits(set == null, buffer);
                        if (set != null) {
                            Adapters.INT_SEGMENTED_3.writeBits(set.size(), buffer);
                            set.forEach(value -> this.getElementAdapter((WeightedList<?>)list).writeBits(value, buffer));
                        }
                        Adapters.DOUBLE.writeBits(weight, buffer);
                    });
                });
            }

            @Override
            public void readBits(BitBuffer buffer) {
                Stream.of(this.neighborFilter, this.tierFilter, this.colorFilter, this.groupFilter).forEach(list -> {
                    list.clear();
                    int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
                    for (int i = 0; i < size; ++i) {
                        if (Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
                            double weight = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
                            list.put(null, weight);
                            continue;
                        }
                        int setSize = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
                        HashSet<Object> set = new HashSet<Object>();
                        for (int j = 0; j < setSize; ++j) {
                            set.add(this.getElementAdapter((WeightedList<?>)list).readBits(buffer).orElseThrow());
                        }
                        double weight = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
                        list.put(set, weight);
                    }
                });
            }

            @Override
            public Optional<CompoundTag> writeNbt() {
                return Optional.of(new CompoundTag()).map(nbt -> {
                    Stream.of(this.neighborFilter, this.tierFilter, this.colorFilter, this.groupFilter).forEach(list -> {
                        ListTag listTag = new ListTag();
                        list.forEach((set, weight) -> {
                            CompoundTag entry = new CompoundTag();
                            if (set != null) {
                                ListTag setTag = new ListTag();
                                set.forEach(value -> this.getElementAdapter((WeightedList<?>)list).writeNbt(value).ifPresent(arg_0 -> setTag.add(arg_0)));
                                entry.m_128365_("value", (Tag)setTag);
                            }
                            Adapters.DOUBLE.writeNbt(weight).ifPresent(tag -> entry.m_128365_("weight", tag));
                            listTag.add((Object)entry);
                        });
                        nbt.m_128365_(this.getId((WeightedList<?>)list), (Tag)listTag);
                    });
                    return nbt;
                });
            }

            @Override
            public void readNbt(CompoundTag nbt) {
                Stream.of(this.neighborFilter, this.tierFilter, this.colorFilter, this.groupFilter).forEach(list -> {
                    list.clear();
                    ListTag listTag = nbt.m_128437_(this.getId((WeightedList<?>)list), 10);
                    for (int i = 0; i < listTag.size(); ++i) {
                        HashSet set;
                        CompoundTag entry = listTag.m_128728_(i);
                        Tag patt27970$temp = entry.m_128423_("value");
                        if (patt27970$temp instanceof ListTag) {
                            ListTag setTag = (ListTag)patt27970$temp;
                            set = new HashSet();
                            for (int j = 0; j < setTag.size(); ++j) {
                                this.getElementAdapter((WeightedList<?>)list).readNbt((Tag)setTag.get(j)).ifPresent(object -> set.add(object));
                            }
                        } else {
                            set = null;
                        }
                        list.put(set, (Double)Adapters.DOUBLE.readNbt(entry.m_128423_("weight")).orElseThrow());
                    }
                });
            }

            @Override
            public Optional<JsonObject> writeJson() {
                return Optional.of(new JsonObject()).map(json -> {
                    Stream.of(this.neighborFilter, this.tierFilter, this.colorFilter, this.groupFilter).forEach(list -> {
                        JsonArray listTag = new JsonArray();
                        list.forEach((set, weight) -> {
                            JsonObject entry = new JsonObject();
                            if (set != null) {
                                JsonArray setTag = new JsonArray();
                                set.forEach(value -> this.getElementAdapter((WeightedList<?>)list).writeJson(value).ifPresent(arg_0 -> ((JsonArray)setTag).add(arg_0)));
                                entry.add("value", (JsonElement)setTag);
                            }
                            Adapters.DOUBLE.writeJson(weight).ifPresent(tag -> entry.add("weight", tag));
                            listTag.add((JsonElement)entry);
                        });
                        json.add(this.getId((WeightedList<?>)list), (JsonElement)listTag);
                    });
                    return json;
                });
            }

            @Override
            public void readJson(JsonObject json) {
                Stream.of(this.neighborFilter, this.tierFilter, this.colorFilter, this.groupFilter).forEach(list -> {
                    list.clear();
                    JsonElement patt30071$temp = json.get(this.getId((WeightedList<?>)list));
                    if (!(patt30071$temp instanceof JsonArray)) {
                        return;
                    }
                    JsonArray listTag = (JsonArray)patt30071$temp;
                    for (int i = 0; i < listTag.size(); ++i) {
                        HashSet set;
                        JsonObject entry = listTag.get(i).getAsJsonObject();
                        JsonElement patt30338$temp = entry.get("value");
                        if (patt30338$temp instanceof JsonArray) {
                            JsonArray setTag = (JsonArray)patt30338$temp;
                            set = new HashSet();
                            for (int j = 0; j < setTag.size(); ++j) {
                                this.getElementAdapter((WeightedList<?>)list).readJson((JsonElement)setTag.get(j)).ifPresent(object -> set.add(object));
                            }
                        } else {
                            set = null;
                        }
                        list.put(set, (Double)Adapters.DOUBLE.readJson(entry.get("weight")).orElseThrow());
                    }
                });
            }

            public String getId(WeightedList<?> list) {
                if (list == this.neighborFilter) {
                    return "neighborFilter";
                }
                if (list == this.tierFilter) {
                    return "tierFilter";
                }
                if (list == this.colorFilter) {
                    return "colorFilter";
                }
                if (list == this.groupFilter) {
                    return "groupFilter";
                }
                throw new UnsupportedOperationException();
            }

            public ISimpleAdapter<Object, ? extends Tag, ? extends JsonElement> getElementAdapter(WeightedList<?> list) {
                if (list == this.neighborFilter) {
                    return Adapters.ofEnum(CardNeighborType.class, EnumAdapter.Mode.NAME);
                }
                if (list == this.tierFilter) {
                    return Adapters.INT_SEGMENTED_3;
                }
                if (list == this.colorFilter) {
                    return Adapters.ofEnum(CardEntry.Color.class, EnumAdapter.Mode.NAME);
                }
                if (list == this.groupFilter) {
                    return Adapters.UTF_8;
                }
                throw new UnsupportedOperationException();
            }
        }
    }
}

