/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card.modifier.card;

import com.google.gson.JsonObject;
import iskallia.vault.core.card.CardProperty;
import iskallia.vault.core.card.modifier.card.DummyCardModifier;
import iskallia.vault.core.card.modifier.card.GearCardModifier;
import iskallia.vault.core.card.modifier.card.TaskLootCardModifier;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public abstract class CardModifier<C extends Config>
extends CardProperty<C> {
    public static final Adapter ADAPTER = new Adapter();

    public CardModifier(C config) {
        super(config);
    }

    public int getMaxTier() {
        return ((Config)this.getConfig()).maxTier;
    }

    public abstract List<VaultGearAttributeInstance<?>> getSnapshotAttributes(int var1);

    public abstract int getHighlightColor();

    @Override
    public boolean voidConfigIfPopulated() {
        return false;
    }

    public static class Config
    extends CardProperty.Config {
        public int maxTier;

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_3.writeBits(this.maxTier, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.maxTier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Adapters.INT.writeNbt(this.maxTier).ifPresent(tag -> nbt.m_128365_("maxTier", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.maxTier = Adapters.INT.readNbt(nbt.m_128423_("maxTier")).orElse(100);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                Adapters.INT.writeJson(this.maxTier).ifPresent(tag -> json.add("maxTier", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.maxTier = Adapters.INT.readJson(json.get("maxTier")).orElse(100);
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<CardModifier<?>> {
        public Adapter() {
            super("type", true);
            this.register("dummy", DummyCardModifier.class, DummyCardModifier::new);
            this.register("gear", GearCardModifier.class, GearCardModifier::new);
            this.register("task_loot", TaskLootCardModifier.class, TaskLootCardModifier::new);
        }
    }
}

