/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card.modifier.card;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.modifier.card.CardModifier;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.config.PairAttributeGenerator;
import iskallia.vault.gear.attribute.config.ThroupleAttributeGenerator;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class GearCardModifier<T>
extends CardModifier<Config<T>> {
    private final Map<Integer, T> values = new LinkedHashMap<Integer, T>();

    public GearCardModifier() {
        super(new Config());
    }

    public GearCardModifier(Config<T> config) {
        super(config);
    }

    public VaultGearAttribute<T> getAttribute() {
        return ((Config)this.getConfig()).getAttribute();
    }

    public T getValue(int tier) {
        return CardEntry.getForTier(this.values, tier).orElseThrow();
    }

    @Override
    public int getHighlightColor() {
        return this.getAttribute().getReader().getRgbColor();
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time, int tier) {
        CardEntry.getForTier(this.values, tier).ifPresent(value -> {
            long window = Minecraft.m_91087_().m_91268_().m_85439_();
            boolean shiftDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
            VaultGearAttributeInstance<Object> instance = new VaultGearAttributeInstance<Object>(this.getAttribute(), value);
            MutableComponent text = this.getAttribute().getReader().getDisplay(instance, VaultGearModifier.AffixType.PREFIX);
            if (shiftDown) {
                Style txtStyle = Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(false));
                TextComponent cmpRangeDescriptor = new TextComponent("");
                List<Object> configs = ((Config)this.getConfig()).pool.keySet().stream().map(s -> ((Config)this.getConfig()).getConfig((int)s)).toList();
                MutableComponent minMaxRangeCmp = this.getAttribute().getGenerator().getConfigRangeDisplay(this.getAttribute().getReader(), configs.get(0), configs.get(configs.size() - 1));
                if (minMaxRangeCmp != null) {
                    if (!cmpRangeDescriptor.getString().isBlank()) {
                        cmpRangeDescriptor.m_130946_(" ");
                    }
                    cmpRangeDescriptor.m_7220_((Component)minMaxRangeCmp);
                    if (Screen.m_96639_()) {
                        cmpRangeDescriptor.m_130946_(",");
                    }
                }
                if (Screen.m_96639_()) {
                    if (!cmpRangeDescriptor.getString().isBlank()) {
                        cmpRangeDescriptor.m_130946_(" ");
                    }
                    MutableComponent rangeCmp = this.getAttribute().getGenerator().getConfigRangeDisplay(this.getAttribute().getReader(), ((Config)this.getConfig()).getConfig(tier));
                    CardEntry.getTier(this.values, tier).ifPresent(arg_0 -> GearCardModifier.lambda$addText$1(rangeCmp, (MutableComponent)cmpRangeDescriptor, arg_0));
                }
                if (!cmpRangeDescriptor.getString().isBlank()) {
                    text.m_7220_((Component)new TextComponent(" ").m_130948_(txtStyle).m_130946_("(").m_7220_((Component)cmpRangeDescriptor).m_130946_(")"));
                }
            }
            tooltip.add((Component)text);
        });
    }

    @Override
    public boolean onPopulate() {
        if (!super.onPopulate()) {
            return false;
        }
        ((Config)this.getConfig()).getPool().forEach((tier, configNbt) -> {
            ConfigurableAttributeGenerator<T, ?> generator = this.getAttribute().getGenerator();
            Object config = ((Config)this.getConfig()).getConfig((int)tier);
            if (config != null) {
                this.values.put((Integer)tier, generator.generateRandomValue(config, new Random()));
            }
        });
        return true;
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getSnapshotAttributes(int tier) {
        return List.of(new VaultGearAttributeInstance<T>(this.getAttribute(), this.getValue(tier)));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        Adapters.INT_SEGMENTED_3.writeBits(this.values.size(), buffer);
        this.values.forEach((tier, value) -> {
            Adapters.INT_SEGMENTED_3.writeBits(tier, buffer);
            this.getAttribute().getType().write(buffer, value);
        });
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        this.values.clear();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            this.values.put((Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow(), this.getAttribute().getType().read(buffer));
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (!this.isPopulated()) {
                return nbt;
            }
            ListTag values = new ListTag();
            this.values.forEach((tier, value) -> {
                CompoundTag entry = new CompoundTag();
                Adapters.INT.writeNbt(tier).ifPresent(tag -> entry.m_128365_("tier", tag));
                entry.m_128365_("value", this.getAttribute().getType().nbtWrite(value));
                values.add((Object)entry);
            });
            nbt.m_128365_("values", (Tag)values);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        if (!this.isPopulated()) {
            return;
        }
        this.values.clear();
        ListTag pool = nbt.m_128437_("values", 10);
        for (int i = 0; i < pool.size(); ++i) {
            CompoundTag entry = pool.m_128728_(i);
            this.values.put((Integer)Adapters.INT.readNbt(entry.m_128423_("tier")).orElseThrow(), this.getAttribute().getType().nbtRead(entry.m_128423_("value")));
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            if (!this.isPopulated()) {
                return json;
            }
            JsonArray values = new JsonArray();
            this.values.forEach((tier, value) -> {
                JsonObject entry = new JsonObject();
                Adapters.INT.writeJson(tier).ifPresent(tag -> entry.add("tier", tag));
                Adapters.GENERIC_NBT.writeJson(this.getAttribute().getType().nbtWrite(value)).ifPresent(tag -> entry.add("value", tag));
                values.add((JsonElement)entry);
            });
            json.add("values", (JsonElement)values);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        if (!this.isPopulated()) {
            return;
        }
        this.values.clear();
        JsonElement jsonElement = json.get("pool");
        if (jsonElement instanceof JsonArray) {
            JsonArray pool = (JsonArray)jsonElement;
            for (int i = 0; i < pool.size(); ++i) {
                JsonObject entry = pool.get(i).getAsJsonObject();
                this.values.put((Integer)Adapters.INT.readJson(entry.get("tier")).orElseThrow(), this.getAttribute().getType().nbtRead((Tag)Adapters.GENERIC_NBT.readJson(entry.get("value")).orElseThrow()));
            }
        }
    }

    private static /* synthetic */ void lambda$addText$1(MutableComponent rangeCmp, MutableComponent cmpRangeDescriptor, Integer t) {
        if (rangeCmp != null) {
            cmpRangeDescriptor.m_130946_("T%s: ".formatted(t));
            cmpRangeDescriptor.m_7220_((Component)rangeCmp);
        }
    }

    public static class Config<T>
    extends CardModifier.Config {
        private VaultGearAttribute<T> attribute;
        private final Map<Integer, String> pool;

        public Config() {
            this.pool = new LinkedHashMap<Integer, String>();
        }

        public Config(VaultGearAttribute<T> attribute, Map<Integer, String> pool) {
            this.attribute = attribute;
            this.pool = pool;
        }

        public VaultGearAttribute<T> getAttribute() {
            return this.attribute;
        }

        public Map<Integer, String> getPool() {
            return this.pool;
        }

        public Object getConfig(int tier) {
            return CardEntry.getForTier(this.pool, tier).map(configString -> {
                Class<?> configClass = this.getAttribute().getGenerator().getConfigurationObjectClass();
                if (configClass != null) {
                    JsonElement configJson = JsonParser.parseString((String)configString);
                    Object config = GsonContext.INSTANCE.deserialize(configJson, configClass);
                    if (config instanceof PairAttributeGenerator.Config2) {
                        PairAttributeGenerator.Config2 cfg = (PairAttributeGenerator.Config2)config;
                        ConfigurableAttributeGenerator<T, ?> patt6631$temp = this.getAttribute().getGenerator();
                        if (patt6631$temp instanceof PairAttributeGenerator) {
                            PairAttributeGenerator pairGen = (PairAttributeGenerator)patt6631$temp;
                            cfg.init(pairGen);
                        }
                    }
                    if (config instanceof ThroupleAttributeGenerator.Config) {
                        ThroupleAttributeGenerator.Config cfg3 = (ThroupleAttributeGenerator.Config)config;
                        ConfigurableAttributeGenerator<T, ?> patt6890$temp = this.getAttribute().getGenerator();
                        if (patt6890$temp instanceof ThroupleAttributeGenerator) {
                            ThroupleAttributeGenerator thrGen = (ThroupleAttributeGenerator)patt6890$temp;
                            cfg3.init(thrGen);
                        }
                    }
                    if (config instanceof ConfigurableAttributeGenerator.CustomTierConfig) {
                        ConfigurableAttributeGenerator.CustomTierConfig custom = (ConfigurableAttributeGenerator.CustomTierConfig)config;
                        if (configJson instanceof JsonObject) {
                            JsonObject object = (JsonObject)configJson;
                            custom.deserializeAdditional(object, GsonContext.INSTANCE);
                        }
                    }
                    return config;
                }
                return null;
            }).orElse(null);
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.GEAR_ATTRIBUTE.writeBits(this.attribute, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.pool.size(), buffer);
            this.pool.forEach((tier, configString) -> {
                Adapters.INT_SEGMENTED_3.writeBits(tier, buffer);
                Adapters.UTF_8.writeBits((String)configString, buffer);
            });
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.attribute = Adapters.GEAR_ATTRIBUTE.readBits(buffer).orElseThrow();
            this.pool.clear();
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            for (int i = 0; i < size; ++i) {
                this.pool.put((Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow(), Adapters.UTF_8.readBits(buffer).orElseThrow());
            }
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.GEAR_ATTRIBUTE.writeNbt(this.attribute).ifPresent(tag -> nbt.m_128365_("attribute", tag));
                ListTag pool = new ListTag();
                this.pool.forEach((tier, configString) -> {
                    CompoundTag entry = new CompoundTag();
                    Adapters.UTF_8.writeNbt((String)configString).ifPresent(tag -> entry.m_128365_("config", tag));
                    Adapters.INT.writeNbt(tier).ifPresent(tag -> entry.m_128365_("tier", tag));
                    pool.add((Object)entry);
                });
                nbt.m_128365_("pool", (Tag)pool);
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.attribute = Adapters.GEAR_ATTRIBUTE.readNbt(nbt.m_128423_("attribute")).orElseThrow();
            this.pool.clear();
            ListTag pool = nbt.m_128437_("pool", 10);
            for (int i = 0; i < pool.size(); ++i) {
                CompoundTag entry = pool.m_128728_(i);
                this.pool.put((Integer)Adapters.INT.readNbt(entry.m_128423_("tier")).orElseThrow(), Adapters.UTF_8.readNbt(entry.m_128423_("config")).orElseThrow());
            }
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.GEAR_ATTRIBUTE.writeJson(this.attribute).ifPresent(tag -> json.add("attribute", tag));
                JsonArray pool = new JsonArray();
                this.pool.forEach((tier, configString) -> {
                    JsonObject entry = (JsonObject)JsonParser.parseString((String)configString);
                    Adapters.INT.writeJson(tier).ifPresent(tag -> entry.add("tier", tag));
                    pool.add((JsonElement)entry);
                });
                json.add("pool", (JsonElement)pool);
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.attribute = Adapters.GEAR_ATTRIBUTE.readJson(json.get("attribute")).orElseThrow();
            this.pool.clear();
            JsonElement jsonElement = json.get("pool");
            if (jsonElement instanceof JsonArray) {
                JsonArray pool = (JsonArray)jsonElement;
                for (int i = 0; i < pool.size(); ++i) {
                    JsonObject entry = pool.get(i).getAsJsonObject();
                    if (entry.has("config")) {
                        this.pool.put((Integer)Adapters.INT.readJson(entry.get("tier")).orElseThrow(), entry.get("config").toString());
                        continue;
                    }
                    int tier = (Integer)Adapters.INT.readJson(entry.get("tier")).orElseThrow();
                    entry.remove("tier");
                    this.pool.put(tier, entry.toString());
                }
            }
        }
    }

    private static class GsonContext
    implements JsonSerializationContext,
    JsonDeserializationContext {
        public static final GsonContext INSTANCE = new GsonContext();

        private GsonContext() {
        }

        public JsonElement serialize(Object src) {
            return iskallia.vault.config.Config.GSON.toJsonTree(src);
        }

        public JsonElement serialize(Object src, Type typeOfSrc) {
            return iskallia.vault.config.Config.GSON.toJsonTree(src, typeOfSrc);
        }

        public <R> R deserialize(JsonElement json, Type typeOfT) throws JsonParseException {
            return (R)iskallia.vault.config.Config.GSON.fromJson(json, typeOfT);
        }
    }
}

