/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card.modifier.card;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.modifier.card.CardModifier;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.loot.LootPool;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TargetTaskCounter;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.renderer.CardTaskRenderer;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.util.TaskProgress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TaskLootCardModifier
extends CardModifier<Config> {
    private UUID uuid;
    private Task task;
    private final Map<Integer, Integer> counts = new LinkedHashMap<Integer, Integer>();

    public TaskLootCardModifier() {
        super(new Config());
    }

    public TaskLootCardModifier(Config config) {
        super(config);
    }

    public Map<Integer, Integer> getCounts() {
        return this.counts;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }

    @Override
    public boolean onPopulate() {
        if (!super.onPopulate()) {
            return false;
        }
        this.uuid = Mth.m_14002_();
        JavaRandom random = JavaRandom.ofNanoTime();
        this.task = ModConfigs.CARD_TASKS.getRandom(((Config)this.getConfig()).task, random).map(task -> task.copy()).orElse(null);
        if (this.task != null) {
            this.task.streamSelfAndDescendants(ConfiguredTask.class).forEach(other -> {
                other.onPopulate(TaskContext.of(EntityTaskSource.ofUuids(random, new UUID[0]), ServerLifecycleHooks.getCurrentServer()));
                other.setPopulated(true);
                if (other instanceof ProgressConfiguredTask) {
                    ProgressConfiguredTask progressTask = (ProgressConfiguredTask)other;
                    progressTask.getCounter().setPopulated(true);
                }
            });
        }
        this.counts.clear();
        ((Config)this.getConfig()).count.forEach((tier, roll) -> this.counts.put((Integer)tier, roll.get(random)));
        return true;
    }

    @Override
    public void onInventoryTick(Level world, Entity entity, int slot, boolean selected, int tier) {
        super.onInventoryTick(world, entity, slot, selected, tier);
        this.task.streamSelfAndDescendants(ProgressConfiguredTask.class).forEach(task -> {
            TargetTaskCounter counter;
            TaskCounter patt3442$temp = task.getCounter();
            if (!(patt3442$temp instanceof TargetTaskCounter) || !(counter = (TargetTaskCounter)patt3442$temp).isPopulated()) {
                return;
            }
            counter.get("targetTierContribution", Adapters.DOUBLE).ifPresent(contribution -> {
                Object patt3660$temp = counter.getBaseTarget();
                if (patt3660$temp instanceof Integer) {
                    Integer base = (Integer)patt3660$temp;
                    counter.setTarget((int)((double)base.intValue() + (double)(tier - 1) * contribution * (double)base.intValue()));
                }
            });
        });
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getSnapshotAttributes(int tier) {
        return Collections.emptyList();
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time, int tier) {
        CardTaskRenderer renderer;
        super.addText(tooltip, minIndex, flag, time, tier);
        Component[] text = new Component[]{((Config)this.getConfig()).tooltip};
        Component component = this.task.getRenderer();
        if (component instanceof CardTaskRenderer && (component = (renderer = (CardTaskRenderer)component).getTooltip()) instanceof TextComponent) {
            TextComponent taskTooltip = (TextComponent)component;
            text[0] = this.replace(text[0], "${task}", taskTooltip);
        }
        text[0] = this.replace(text[0], "${count}", new TextComponent(String.valueOf(this.counts.get(tier))));
        this.task.streamSelfAndDescendants().filter(t -> t instanceof ProgressConfiguredTask).findFirst().ifPresent(task -> {
            TaskProgress progress = ((ProgressConfiguredTask)task).getCounter().getProgress();
            text[0] = this.replace(text[0], "${current}", new TextComponent(progress.getCurrent().toString()));
            text[0] = this.replace(text[0], "${target}", new TextComponent(progress.getTarget().toString()));
        });
        tooltip.add(text[0]);
    }

    public Component replace(Component component, String target, TextComponent replacement) {
        if (!(component instanceof TextComponent)) {
            return component;
        }
        TextComponent base = (TextComponent)component;
        List siblings = base.m_7360_();
        siblings.add(0, base.m_6879_().m_6270_(base.m_7383_()));
        for (int i = 0; i < siblings.size(); ++i) {
            Style styledReplacement;
            String text;
            Component sibling = (Component)siblings.get(i);
            if (!(sibling instanceof TextComponent) || (text = ((TextComponent)sibling).m_131292_()).isEmpty()) continue;
            ArrayList<MutableComponent> parts = new ArrayList<MutableComponent>();
            Style style = styledReplacement = replacement.m_7383_() == Style.f_131099_ ? sibling.m_7383_() : Style.f_131099_;
            if (text.equals(target)) {
                parts.add(replacement.m_6879_().m_130948_(styledReplacement));
            } else {
                for (String raw : text.split(Pattern.quote(target))) {
                    parts.add(new TextComponent(raw).m_6270_(sibling.m_7383_()));
                    parts.add(replacement.m_6879_().m_130948_(styledReplacement));
                }
                parts.remove(parts.size() - 1);
            }
            siblings.remove(i);
            for (int j = 0; j < parts.size(); ++j) {
                siblings.add(i, (Component)parts.get(parts.size() - j - 1));
            }
        }
        TextComponent result = new TextComponent("");
        result.m_6270_(base.m_7383_());
        for (Component sibling : siblings) {
            result.m_7220_(sibling);
        }
        return result;
    }

    @Override
    public int getHighlightColor() {
        return ((Config)this.getConfig()).highlightColor;
    }

    public List<ItemStack> generateLoot(int tier, RandomSource random) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        CardEntry.getForTier(this.counts, tier).ifPresent(count -> {
            for (int i = 0; i < count; ++i) {
                ((Config)this.getConfig()).loot.getRandom(random).ifPresent(entry -> items.addAll(entry.getStack(random)));
            }
        });
        return items;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        Adapters.UUID.writeBits(this.uuid, buffer);
        Adapters.TASK.writeBits(this.task, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.counts.size(), buffer);
        this.counts.forEach((tier, count) -> {
            Adapters.INT_SEGMENTED_3.writeBits(tier, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(count, buffer);
        });
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        this.uuid = Adapters.UUID.readBits(buffer).orElseThrow();
        this.task = (Task)Adapters.TASK.readBits(buffer).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.counts.clear();
        for (int i = 0; i < size; ++i) {
            this.counts.put((Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow(), (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow());
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (!this.isPopulated()) {
                return nbt;
            }
            Adapters.UUID.writeNbt(this.uuid).ifPresent(tag -> nbt.m_128365_("uuid", tag));
            Adapters.TASK.writeNbt(this.task).ifPresent(tag -> nbt.m_128365_("task", tag));
            ListTag counts = new ListTag();
            this.counts.forEach((tier, count) -> {
                CompoundTag entry = new CompoundTag();
                Adapters.INT_SEGMENTED_3.writeNbt(tier).ifPresent(tag -> entry.m_128365_("tier", tag));
                Adapters.INT_SEGMENTED_3.writeNbt(count).ifPresent(tag -> entry.m_128365_("count", tag));
                counts.add((Object)entry);
            });
            nbt.m_128365_("counts", (Tag)counts);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        if (!this.isPopulated()) {
            return;
        }
        this.uuid = Adapters.UUID.readNbt(nbt.m_128423_("uuid")).orElseThrow();
        this.task = (Task)Adapters.TASK.readNbt(nbt.m_128423_("task")).orElseThrow();
        ListTag count = nbt.m_128437_("counts", 10);
        this.counts.clear();
        for (int i = 0; i < count.size(); ++i) {
            this.counts.put((Integer)Adapters.INT_SEGMENTED_3.readNbt(count.m_128728_(i).m_128423_("tier")).orElseThrow(), (Integer)Adapters.INT_SEGMENTED_3.readNbt(count.m_128728_(i).m_128423_("count")).orElseThrow());
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            if (!this.isPopulated()) {
                return json;
            }
            Adapters.UUID.writeJson(this.uuid).ifPresent(tag -> json.add("uuid", tag));
            Adapters.TASK.writeJson(this.task).ifPresent(tag -> json.add("task", tag));
            JsonArray counts = new JsonArray();
            this.counts.forEach((tier, count) -> {
                JsonObject entry = new JsonObject();
                Adapters.INT_SEGMENTED_3.writeJson(tier).ifPresent(tag -> entry.add("tier", tag));
                Adapters.INT_SEGMENTED_3.writeJson(count).ifPresent(tag -> entry.add("count", tag));
                counts.add((JsonElement)entry);
            });
            json.add("counts", (JsonElement)counts);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        if (!this.isPopulated()) {
            return;
        }
        this.uuid = Adapters.UUID.readJson(json.get("uuid")).orElseThrow();
        this.task = (Task)Adapters.TASK.readJson(json.get("task")).orElseThrow();
        JsonArray counts = json.getAsJsonArray("counts");
        this.counts.clear();
        for (int i = 0; i < counts.size(); ++i) {
            JsonObject entry = counts.get(i).getAsJsonObject();
            this.counts.put((Integer)Adapters.INT_SEGMENTED_3.readJson(entry.get("tier")).orElseThrow(), (Integer)Adapters.INT_SEGMENTED_3.readJson(entry.get("count")).orElseThrow());
        }
    }

    public static class Config
    extends CardModifier.Config {
        private LootPool loot;
        private String task;
        private final Map<Integer, IntRoll> count = new LinkedHashMap<Integer, IntRoll>();
        private Component tooltip;
        private int highlightColor;

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.LOOT_POOL.writeBits(this.loot, buffer);
            Adapters.UTF_8.writeBits(this.task, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.count.size(), buffer);
            this.count.forEach((tier, roll) -> {
                Adapters.INT_SEGMENTED_3.writeBits(tier, buffer);
                Adapters.INT_ROLL.writeBits(roll, buffer);
            });
            Adapters.COMPONENT.writeBits(this.tooltip, buffer);
            Adapters.INT.writeBits(this.highlightColor, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.loot = (LootPool)Adapters.LOOT_POOL.readBits(buffer).orElseThrow();
            this.task = Adapters.UTF_8.readBits(buffer).orElseThrow();
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            this.count.clear();
            for (int i = 0; i < size; ++i) {
                this.count.put((Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow(), (IntRoll)Adapters.INT_ROLL.readBits(buffer).orElseThrow());
            }
            this.tooltip = Adapters.COMPONENT.readBits(buffer).orElseThrow();
            this.highlightColor = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.LOOT_POOL.writeNbt(this.loot).ifPresent(tag -> nbt.m_128365_("loot", (Tag)tag));
                Adapters.UTF_8.writeNbt(this.task).ifPresent(tag -> nbt.m_128365_("task", tag));
                ListTag count = new ListTag();
                this.count.forEach((tier, roll) -> {
                    CompoundTag entry = new CompoundTag();
                    Adapters.INT_SEGMENTED_3.writeNbt(tier).ifPresent(tag -> entry.m_128365_("tier", tag));
                    Adapters.INT_ROLL.writeNbt(roll).ifPresent(tag -> entry.m_128365_("roll", tag));
                    count.add((Object)entry);
                });
                nbt.m_128365_("count", (Tag)count);
                Adapters.COMPONENT.writeNbt(this.tooltip).ifPresent(tag -> nbt.m_128365_("tooltip", tag));
                Adapters.INT.writeNbt(this.highlightColor).ifPresent(tag -> nbt.m_128365_("highlightColor", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.loot = (LootPool)Adapters.LOOT_POOL.readNbt(nbt.m_128437_("loot", 10)).orElseThrow();
            this.task = Adapters.UTF_8.readNbt(nbt.m_128423_("task")).orElseThrow();
            ListTag count = nbt.m_128437_("count", 10);
            this.count.clear();
            for (int i = 0; i < count.size(); ++i) {
                this.count.put((Integer)Adapters.INT_SEGMENTED_3.readNbt(count.m_128728_(i).m_128423_("tier")).orElseThrow(), (IntRoll)Adapters.INT_ROLL.readNbt(count.m_128728_(i).m_128423_("roll")).orElseThrow());
            }
            this.tooltip = Adapters.COMPONENT.readNbt(nbt.m_128423_("tooltip")).orElseThrow();
            this.highlightColor = (Integer)Adapters.INT.readNbt(nbt.m_128423_("highlightColor")).orElseThrow();
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.LOOT_POOL.writeJson(this.loot).ifPresent(tag -> json.add("loot", (JsonElement)tag));
                Adapters.UTF_8.writeJson(this.task).ifPresent(tag -> json.add("task", tag));
                JsonArray count = new JsonArray();
                this.count.forEach((tier, roll) -> {
                    JsonObject entry = new JsonObject();
                    Adapters.INT_SEGMENTED_3.writeJson(tier).ifPresent(tag -> entry.add("tier", tag));
                    Adapters.INT_ROLL.writeJson(roll).ifPresent(tag -> entry.add("roll", tag));
                    count.add((JsonElement)entry);
                });
                json.add("count", (JsonElement)count);
                Adapters.COMPONENT.writeJson(this.tooltip).ifPresent(tag -> json.add("tooltip", tag));
                Adapters.INT.writeJson(this.highlightColor).ifPresent(tag -> json.add("highlightColor", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.loot = (LootPool)Adapters.LOOT_POOL.readJson(json.getAsJsonArray("loot")).orElseThrow();
            this.task = Adapters.UTF_8.readJson(json.get("task")).orElseThrow();
            JsonArray count = json.getAsJsonArray("count");
            this.count.clear();
            for (int i = 0; i < count.size(); ++i) {
                JsonObject entry = count.get(i).getAsJsonObject();
                this.count.put((Integer)Adapters.INT_SEGMENTED_3.readJson(entry.get("tier")).orElseThrow(), (IntRoll)Adapters.INT_ROLL.readJson(entry.get("roll")).orElseThrow());
            }
            this.tooltip = Adapters.COMPONENT.readJson(json.get("tooltip")).orElseThrow();
            this.highlightColor = (Integer)Adapters.INT.readJson(json.get("highlightColor")).orElseThrow();
        }
    }
}

