/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card.modifier.deck;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardDeck;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardPos;
import iskallia.vault.core.card.modifier.deck.DummyDeckModifier;
import iskallia.vault.core.card.modifier.deck.GlobalDeckModifier;
import iskallia.vault.core.card.modifier.deck.SlotDeckModifier;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.basic.SerializableAdapter;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.world.roll.FloatRoll;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;

public abstract class DeckModifier<C extends Config>
implements ISerializable<CompoundTag, JsonObject> {
    public static final Adapter ADAPTER = new Adapter();
    protected final C config;
    private float modifierValue = -1.0f;
    private boolean populated;

    public DeckModifier(C config) {
        this.config = config;
    }

    public C getConfig() {
        return this.config;
    }

    public float getModifierValue() {
        return this.modifierValue;
    }

    public abstract float getModifierValue(Card var1, CardPos var2, CardDeck var3);

    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void setPopulated(boolean populated) {
        this.populated = populated;
    }

    public boolean onPopulate(CardDeck deck) {
        boolean result = !this.isPopulated();
        this.setPopulated(true);
        this.modifierValue = ((Config)this.getConfig()).modifierRoll.get(JavaRandom.ofNanoTime());
        return result;
    }

    public abstract boolean voidConfigIfPopulated();

    public void onInventoryTick(CardDeck deck) {
        if (!this.populated) {
            this.onPopulate(deck);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.BOOLEAN.writeBits(this.populated, buffer);
        if (!this.voidConfigIfPopulated() || !this.populated) {
            ((Config)this.config).writeBits(buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.populated = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        if (!this.voidConfigIfPopulated() || !this.populated) {
            ((Config)this.config).readBits(buffer);
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            if (!this.populated) {
                CompoundTag other = ((Config)this.config).writeNbt().orElseThrow();
                other.m_128431_().forEach(key -> nbt.m_128365_(key, Objects.requireNonNull(other.m_128423_(key))));
            } else if (this.voidConfigIfPopulated()) {
                nbt.m_128365_("config", (Tag)new CompoundTag());
            } else {
                nbt.m_128365_("config", (Tag)((Config)this.config).writeNbt().orElseThrow());
                Adapters.FLOAT.writeNbt(Float.valueOf(this.modifierValue)).ifPresent(tag -> nbt.m_128350_("modifier_value", this.modifierValue));
            }
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        if (!nbt.m_128441_("config")) {
            ((Config)this.config).readNbt(nbt);
            this.populated = false;
            this.modifierValue = -1.0f;
        } else {
            ((Config)this.config).readNbt(nbt.m_128469_("config"));
            this.populated = true;
            if (nbt.m_128441_("modifier_value")) {
                this.modifierValue = Adapters.FLOAT.readNbt(nbt.m_128423_("modifier_value")).orElse(Float.valueOf(-1.0f)).floatValue();
            }
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(json -> {
            if (!this.populated) {
                ((Config)this.config).writeJson().orElseThrow().entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            } else {
                json.add("config", (JsonElement)((Config)this.config).writeJson().orElseThrow());
                Adapters.FLOAT.writeJson(Float.valueOf(this.modifierValue)).ifPresent(tag -> json.addProperty("modifier_value", (Number)Float.valueOf(this.modifierValue)));
            }
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        if (!json.has("config")) {
            ((Config)this.config).readJson(json);
            this.populated = false;
            this.modifierValue = -1.0f;
        } else {
            ((Config)this.config).readJson(json.getAsJsonObject("config"));
            this.populated = true;
            if (json.has("modifier_value")) {
                this.modifierValue = Adapters.FLOAT.readJson(json.get("modifier_value")).orElse(Float.valueOf(-1.0f)).floatValue();
            }
        }
    }

    public static class Config
    implements ISerializable<CompoundTag, JsonObject> {
        public static final SerializableAdapter<Config, CompoundTag, JsonObject> ADAPTER = Adapters.of(Config::new, false);
        public static final ArrayAdapter<CardEntry.Color> COLORS = Adapters.ofArray(CardEntry.Color[]::new, Adapters.ofEnum(CardEntry.Color.class, EnumAdapter.Mode.NAME));
        public static final ArrayAdapter<String> GROUPS = Adapters.ofArray(String[]::new, Adapters.UTF_8);
        public FloatRoll modifierRoll;

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.FLOAT_ROLL.writeBits(this.modifierRoll, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.modifierRoll = Adapters.FLOAT_ROLL.readBits(buffer).orElse(FloatRoll.ofConstant(0.0f));
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Adapters.FLOAT_ROLL.writeNbt(this.modifierRoll).ifPresent(tag -> nbt.m_128365_("modifierValue", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.modifierRoll = Adapters.FLOAT_ROLL.readNbt(nbt.m_128423_("modifierValue")).orElse(FloatRoll.ofConstant(0.0f));
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                Adapters.FLOAT_ROLL.writeJson(this.modifierRoll).ifPresent(tag -> json.add("modifierValue", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.modifierRoll = Adapters.FLOAT_ROLL.readJson(json.get("modifierValue")).orElse(FloatRoll.ofConstant(0.0f));
        }

        public Config copy() {
            Config config = new Config();
            this.writeJson().ifPresent(config::readJson);
            return config;
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<DeckModifier<?>> {
        public Adapter() {
            super("type", true);
            this.register("global", GlobalDeckModifier.class, GlobalDeckModifier::new);
            this.register("slot", SlotDeckModifier.class, SlotDeckModifier::new);
            this.register("dummy", DummyDeckModifier.class, DummyDeckModifier::new);
        }
    }
}

