/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card.modifier.deck;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardDeck;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardPos;
import iskallia.vault.core.card.modifier.deck.DeckModifier;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.SerializableAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class GlobalDeckModifier
extends DeckModifier<Config> {
    public GlobalDeckModifier(Config config) {
        super(config);
    }

    public GlobalDeckModifier() {
        this(new Config());
    }

    @Override
    public float getModifierValue(Card card, CardPos pos, CardDeck deck) {
        if (((Config)this.config).requiredGroups != null && !((Config)this.config).requiredGroups.isEmpty() && !card.hasAllGroups(((Config)this.config).requiredGroups)) {
            return 1.0f;
        }
        if (((Config)this.config).requiredColors != null && !((Config)this.config).requiredColors.isEmpty() && !((Config)this.config).requiredColors.contains((Object)card.getColor())) {
            return 1.0f;
        }
        return 1.0f + this.getModifierValue();
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        super.addText(tooltip, minIndex, flag, time);
        ArrayList<String> affectedCards = new ArrayList<String>(){
            {
                this.addAll(((Config)GlobalDeckModifier.this.getConfig()).requiredColors.stream().map(Enum::name).map(string -> string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase()).toList());
                this.addAll(((Config)GlobalDeckModifier.this.getConfig()).requiredGroups.stream().map(string -> string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase()).toList());
            }
        };
        tooltip.add((Component)new TextComponent("- All ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)affectedCards) + (affectedCards.isEmpty() ? "" : " ")).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent("cards ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent("will be ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(String.format("%.0f%%", Float.valueOf(this.getModifierValue() * 100.0f))).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent(" more efficient").m_130940_(ChatFormatting.GRAY)));
    }

    @Override
    public boolean voidConfigIfPopulated() {
        return false;
    }

    public static class Config
    extends DeckModifier.Config {
        public static final SerializableAdapter<Config, CompoundTag, JsonObject> ADAPTER = Adapters.of(Config::new, false);
        public Set<String> requiredGroups = new HashSet<String>();
        public Set<CardEntry.Color> requiredColors = new HashSet<CardEntry.Color>();

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.requiredGroups = Arrays.stream(GROUPS.readNbt(nbt.m_128423_("requiredGroups")).orElse(new String[0])).collect(Collectors.toSet());
            this.requiredColors = Arrays.stream(COLORS.readNbt(nbt.m_128423_("requiredColors")).orElse(new CardEntry.Color[0])).collect(Collectors.toSet());
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.requiredGroups = Arrays.stream(GROUPS.readJson(json.get("requiredGroups")).orElse(new String[0])).collect(Collectors.toSet());
            this.requiredColors = Arrays.stream(COLORS.readJson(json.get("requiredColors")).orElse(new CardEntry.Color[0])).collect(Collectors.toSet());
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                nbt.m_128365_("requiredGroups", (Tag)GROUPS.writeNbt((String[])this.requiredGroups.toArray(String[]::new)).orElseThrow());
                nbt.m_128365_("requiredColors", (Tag)COLORS.writeNbt((CardEntry.Color[])this.requiredColors.toArray(CardEntry.Color[]::new)).orElseThrow());
                return nbt;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(nbt -> {
                nbt.add("requiredGroups", (JsonElement)GROUPS.writeJson((String[])this.requiredGroups.toArray(String[]::new)).orElseThrow());
                nbt.add("requiredColors", (JsonElement)COLORS.writeJson((CardEntry.Color[])this.requiredColors.toArray(CardEntry.Color[]::new)).orElseThrow());
                return nbt;
            });
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            GROUPS.writeBits((String[])this.requiredGroups.toArray(String[]::new), buffer);
            COLORS.writeBits((CardEntry.Color[])this.requiredColors.toArray(CardEntry.Color[]::new), buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.requiredGroups = Arrays.stream(GROUPS.readBits(buffer).orElse(new String[0])).collect(Collectors.toSet());
            this.requiredColors = Arrays.stream(COLORS.readBits(buffer).orElse(new CardEntry.Color[0])).collect(Collectors.toSet());
        }
    }
}

