/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.card.modifier.deck;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardDeck;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardPos;
import iskallia.vault.core.card.modifier.deck.DeckModifier;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.SerializableAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.world.roll.IntRoll;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class SlotDeckModifier
extends DeckModifier<Config> {
    private List<CardPos> affectedSlots = new ArrayList<CardPos>();

    public SlotDeckModifier(Config config) {
        super(config);
    }

    public SlotDeckModifier() {
        this(new Config());
    }

    public List<CardPos> getAffectedSlots() {
        return this.affectedSlots;
    }

    @Override
    public float getModifierValue(Card card, CardPos pos, CardDeck deck) {
        if (this.affectedSlots.stream().noneMatch(cardPos -> cardPos.equals(pos))) {
            return 1.0f;
        }
        if (((Config)this.config).requiredGroups != null && !((Config)this.config).requiredGroups.isEmpty() && !card.hasAllGroups(((Config)this.config).requiredGroups)) {
            return 1.0f;
        }
        if (((Config)this.config).requiredColors != null && !((Config)this.config).requiredColors.isEmpty() && !((Config)this.config).requiredColors.contains((Object)card.getColor())) {
            return 1.0f;
        }
        return 1.0f + this.getModifierValue();
    }

    @Override
    public boolean onPopulate(CardDeck deck) {
        if (!super.onPopulate(deck)) {
            return false;
        }
        JavaRandom random = JavaRandom.ofNanoTime();
        this.affectedSlots = new ArrayList<CardPos>();
        int count = ((Config)this.config).slotRoll.get(random);
        ArrayList<CardPos> availablePositions = new ArrayList<CardPos>(deck.getSlots());
        for (int i = 0; i < count; ++i) {
            CardPos position;
            CardPos cardPos = position = availablePositions.isEmpty() ? null : (CardPos)availablePositions.get(random.nextInt(availablePositions.size()));
            if (position == null) continue;
            this.affectedSlots.add(position);
            availablePositions.remove(position);
        }
        return true;
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        super.addText(tooltip, minIndex, flag, time);
        if (this.affectedSlots.isEmpty()) {
            return;
        }
        ArrayList<String> affectedCards = new ArrayList<String>(){
            {
                this.addAll(((Config)SlotDeckModifier.this.getConfig()).requiredColors.stream().map(Enum::name).map(string -> string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase()).toList());
                this.addAll(((Config)SlotDeckModifier.this.getConfig()).requiredGroups.stream().map(string -> string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase()).toList());
            }
        };
        tooltip.add((Component)new TextComponent("- All ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)affectedCards) + (affectedCards.isEmpty() ? "" : " ")).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent("cards in ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent("selected slots").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(" will be ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(String.format("%.0f%%", Float.valueOf(this.getModifierValue() * 100.0f))).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent(" more efficient").m_130940_(ChatFormatting.GRAY)));
    }

    @Override
    public boolean voidConfigIfPopulated() {
        return false;
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (!this.isPopulated()) {
                return nbt;
            }
            ListTag listTag = new ListTag();
            for (CardPos cardPos : this.affectedSlots) {
                CompoundTag compoundTag = new CompoundTag();
                CardPos.ADAPTER.writeNbt(cardPos).ifPresent(tag -> compoundTag.m_128365_("pos", tag));
                listTag.add((Object)compoundTag);
            }
            nbt.m_128365_("affectedSlots", (Tag)listTag);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.affectedSlots.clear();
        if (nbt.m_128441_("affectedSlots")) {
            ListTag listTag = nbt.m_128437_("affectedSlots", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag entry = listTag.m_128728_(i);
                CardPos.ADAPTER.readNbt(entry.m_128423_("pos")).ifPresent(this.affectedSlots::add);
            }
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            if (!this.isPopulated()) {
                return json;
            }
            if (this.affectedSlots != null && !this.affectedSlots.isEmpty()) {
                JsonArray jsonElement = new JsonArray();
                for (CardPos cardPos : this.affectedSlots) {
                    CardPos.ADAPTER.writeJson(cardPos).ifPresent(arg_0 -> ((JsonArray)jsonElement).add(arg_0));
                }
                json.add("affectedSlots", (JsonElement)jsonElement);
            }
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.affectedSlots.clear();
        if (json.has("affectedSlots")) {
            JsonArray jsonElement = json.getAsJsonArray("affectedSlots");
            for (int i = 0; i < jsonElement.size(); ++i) {
                CardPos.ADAPTER.readJson((JsonElement)jsonElement.get(i).getAsJsonObject()).ifPresent(this.affectedSlots::add);
            }
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.affectedSlots.size(), buffer);
        for (CardPos pos : this.affectedSlots) {
            CardPos.ADAPTER.writeBits(pos, buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.affectedSlots.clear();
        int size = Adapters.INT_SEGMENTED_7.readBits(buffer).orElse(0);
        for (int i = 0; i < size; ++i) {
            CardPos.ADAPTER.readBits(buffer).ifPresent(pos -> this.affectedSlots.add((CardPos)pos));
        }
    }

    public static class Config
    extends DeckModifier.Config {
        public static final SerializableAdapter<Config, CompoundTag, JsonObject> ADAPTER = Adapters.of(Config::new, false);
        public Set<String> requiredGroups = new HashSet<String>();
        public Set<CardEntry.Color> requiredColors = new HashSet<CardEntry.Color>();
        public IntRoll slotRoll = IntRoll.ofConstant(1);

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            GROUPS.writeBits((String[])this.requiredGroups.toArray(String[]::new), buffer);
            COLORS.writeBits((CardEntry.Color[])this.requiredColors.toArray(CardEntry.Color[]::new), buffer);
            Adapters.INT_ROLL.writeBits(this.slotRoll, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.requiredGroups = Arrays.stream(GROUPS.readBits(buffer).orElse(new String[0])).collect(Collectors.toSet());
            this.requiredColors = Arrays.stream(COLORS.readBits(buffer).orElse(new CardEntry.Color[0])).collect(Collectors.toSet());
            this.slotRoll = Adapters.INT_ROLL.readBits(buffer).orElse(this.slotRoll);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.requiredGroups = Arrays.stream(GROUPS.readNbt(nbt.m_128423_("requiredGroups")).orElse(new String[0])).collect(Collectors.toSet());
            this.requiredColors = Arrays.stream(COLORS.readNbt(nbt.m_128423_("requiredColors")).orElse(new CardEntry.Color[0])).collect(Collectors.toSet());
            this.slotRoll = Adapters.INT_ROLL.readNbt(nbt.m_128423_("slotRoll")).orElse(this.slotRoll);
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.requiredGroups = Arrays.stream(GROUPS.readJson(json.get("requiredGroups")).orElse(new String[0])).collect(Collectors.toSet());
            this.requiredColors = Arrays.stream(COLORS.readJson(json.get("requiredColors")).orElse(new CardEntry.Color[0])).collect(Collectors.toSet());
            this.slotRoll = Adapters.INT_ROLL.readJson(json.get("slotRoll")).orElse(this.slotRoll);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                json.add("requiredGroups", (JsonElement)GROUPS.writeJson((String[])this.requiredGroups.toArray(String[]::new)).orElseThrow());
                json.add("requiredColors", (JsonElement)COLORS.writeJson((CardEntry.Color[])this.requiredColors.toArray(CardEntry.Color[]::new)).orElseThrow());
                json.add("slotRoll", Adapters.INT_ROLL.writeJson(this.slotRoll).orElseThrow());
                return json;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                nbt.m_128365_("requiredGroups", (Tag)GROUPS.writeNbt((String[])this.requiredGroups.toArray(String[]::new)).orElseThrow());
                nbt.m_128365_("requiredColors", (Tag)COLORS.writeNbt((CardEntry.Color[])this.requiredColors.toArray(CardEntry.Color[]::new)).orElseThrow());
                nbt.m_128365_("slotRoll", Adapters.INT_ROLL.writeNbt(this.slotRoll).orElseThrow());
                return nbt;
            });
        }
    }
}

