/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data;

import iskallia.vault.core.data.ICompound;
import iskallia.vault.core.data.action.ListAction;
import iskallia.vault.core.data.action.ListTracker;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public class DataList<D extends DataList<D, E>, E>
extends AbstractList<E>
implements ICompound<D> {
    private final List<E> delegate;
    private final IBitAdapter<E, SyncContext> adapter;
    private final Supplier<E> supplier;
    protected final ListTracker tracker = new ListTracker();

    public DataList(List<E> delegate, IBitAdapter<E, ?> adapter, Supplier<E> supplier) {
        this.delegate = delegate;
        this.adapter = adapter;
        this.supplier = supplier;
    }

    public DataList(List<E> delegate, IBitAdapter<E, ?> adapter) {
        this(delegate, adapter, () -> null);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(E element) {
        this.tracker.addAction(ListAction.ofAppend(this.delegate.size(), element));
        this.delegate.add(element);
        return true;
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public E set(int index, E element) {
        this.tracker.addAction(ListAction.ofSet(index, element, this.delegate.size()));
        return this.delegate.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.tracker.addAction(ListAction.ofAdd(index, element, this.delegate.size()));
        this.delegate.add(index, element);
    }

    @Override
    public E remove(int index) {
        this.tracker.addAction(ListAction.ofRemove(index, this.delegate.size()));
        return this.delegate.remove(index);
    }

    @Override
    public void clear() {
        this.tracker.addAction(ListAction.ofClear());
        this.delegate.clear();
    }

    @Override
    public D write(BitBuffer buffer, SyncContext context) {
        buffer.writeIntSegmented(this.delegate.size(), 4);
        for (E value : this.delegate) {
            this.adapter.writeBits(value, buffer, context);
        }
        return (D)this;
    }

    @Override
    public D read(BitBuffer buffer, SyncContext context) {
        int size = buffer.readIntSegmented(4);
        this.delegate.clear();
        for (int i = 0; i < size; ++i) {
            this.add(this.adapter.readBits(buffer, context).orElseGet(this.supplier));
        }
        this.resetDiff();
        return (D)this;
    }

    @Override
    public boolean isDirty(SyncContext context) {
        return !this.tracker.getActions().isEmpty();
    }

    @Override
    public D writeDiff(BitBuffer packet, SyncContext context) {
        int i;
        packet.writeBoolean(this.tracker.getActions().isEmpty());
        if (this.tracker.getActions().isEmpty()) {
            return (D)this;
        }
        boolean doClear = this.tracker.getActions().get((int)0).type == ListAction.Type.CLEAR;
        packet.writeBoolean(doClear);
        packet.writeIntSegmented(this.tracker.getActions().size() - (doClear ? 1 : 0), 4);
        int n = i = doClear ? 1 : 0;
        while (i < this.tracker.getActions().size()) {
            ListAction action = this.tracker.getActions().get(i);
            packet.writeIntBits(action.type.ordinal(), 2);
            if (action.type != ListAction.Type.APPEND) {
                packet.writeIntBounded(action.index, 0, action.size - 1);
            }
            if (action.type != ListAction.Type.REMOVE) {
                this.adapter.writeBits(action.value, packet, context);
            }
            ++i;
        }
        return (D)this;
    }

    @Override
    public D readDiff(BitBuffer packet, SyncContext context) {
        if (packet.readBoolean()) {
            return (D)this;
        }
        if (packet.readBoolean()) {
            this.delegate.clear();
        }
        int size = packet.readIntSegmented(4);
        for (int i = 0; i < size; ++i) {
            Action action = new Action(-1, null, ActionType.values()[packet.readIntBits(2)], -1);
            if (action.type != ActionType.APPEND) {
                action.index = packet.readIntBounded(0, this.delegate.size() - 1);
            }
            if (action.type != ActionType.REMOVE) {
                action.value = this.adapter.readBits(packet, context).orElseGet(this.supplier);
            }
            action.apply(this);
        }
        return (D)this;
    }

    @Override
    public D resetDiff() {
        this.tracker.getActions().clear();
        return (D)this;
    }

    @Override
    public boolean isDirtyTree(SyncContext context) {
        if (this.isDirty(context)) {
            return true;
        }
        for (E value : this.delegate) {
            if (!(value instanceof ICompound) || !((ICompound)value).isDirty(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public D writeDiffTree(BitBuffer packet, SyncContext context) {
        this.writeDiff(packet, context);
        for (E value : this.delegate) {
            if (!(value instanceof ICompound)) continue;
            ICompound compound = (ICompound)value;
            if (compound.isDirtyTree(context)) {
                packet.writeBoolean(true);
                compound.writeDiffTree(packet, context);
                continue;
            }
            packet.writeBoolean(false);
        }
        return (D)this;
    }

    @Override
    public D readDiffTree(BitBuffer packet, SyncContext context) {
        this.readDiff(packet, context);
        for (E value : this.delegate) {
            if (!(value instanceof ICompound)) continue;
            ICompound compound = (ICompound)value;
            if (!packet.readBoolean()) continue;
            compound.readDiffTree(packet, context);
        }
        return (D)this;
    }

    @Override
    public D resetDiffTree() {
        this.resetDiff();
        for (E value : this.delegate) {
            if (!(value instanceof ICompound)) continue;
            ((ICompound)value).resetDiffTree();
        }
        return (D)this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        Iterator<E> it = this.delegate.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("]").toString();
    }

    private static class Action {
        public int index;
        public Object value;
        public ActionType type;
        public int size;

        public Action(int index, Object value, ActionType type, int size) {
            this.index = index;
            this.value = value;
            this.type = type;
            this.size = size;
        }

        public static Action ofAppend(int size, Object value) {
            return new Action(size, value, ActionType.APPEND, -1);
        }

        public static Action ofAdd(int index, Object value, int size) {
            return new Action(index, value, ActionType.ADD, size);
        }

        public static Action ofSet(int index, Object value, int size) {
            return new Action(index, value, ActionType.SET, size);
        }

        public static Action ofRemove(int index, int size) {
            return new Action(index, null, ActionType.REMOVE, size);
        }

        public static Action ofClear() {
            return new Action(-1, null, ActionType.CLEAR, -1);
        }

        public void apply(List list) {
            switch (this.type) {
                case APPEND: {
                    list.add(this.value);
                    break;
                }
                case ADD: {
                    list.add(this.index, this.value);
                    break;
                }
                case SET: {
                    list.set(this.index, this.value);
                    break;
                }
                case REMOVE: {
                    list.remove(this.index);
                    break;
                }
                case CLEAR: {
                    list.clear();
                }
            }
        }
    }

    private static enum ActionType {
        APPEND,
        ADD,
        SET,
        REMOVE,
        CLEAR;

    }
}

