/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.adapter.IByteAdapter;
import iskallia.vault.core.data.adapter.IComplexAdapter;
import iskallia.vault.core.data.adapter.IDataAdapter;
import iskallia.vault.core.data.adapter.IJsonAdapter;
import iskallia.vault.core.data.adapter.INbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ArrayAdapter<T>
implements IComplexAdapter<T[], Tag, JsonElement, Object> {
    private final IntFunction<T[]> constructor;
    private final Object elementAdapter;
    private final Supplier<T> defaultValue;
    private final boolean nullable;

    public ArrayAdapter(IntFunction<T[]> constructor, Object elementAdapter, Supplier<T> defaultValue, boolean nullable) {
        this.constructor = constructor;
        this.elementAdapter = elementAdapter;
        this.defaultValue = defaultValue;
        this.nullable = nullable;
    }

    public IntFunction<T[]> getConstructor() {
        return this.constructor;
    }

    public Object getElementAdapter() {
        return this.elementAdapter;
    }

    public Supplier<T> getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ArrayAdapter<T> asNullable() {
        return new ArrayAdapter<T>(this.constructor, this.elementAdapter, this.defaultValue, true);
    }

    @Override
    public final void writeBits(@Nullable T[] value, BitBuffer buffer, Object context) {
        T[] TArray = this.elementAdapter;
        if (!(TArray instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)TArray;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_3.writeBits(value.length, buffer);
            for (T element : value) {
                adapter.writeBits(element, buffer, context);
            }
        }
    }

    @Override
    public final Optional<T[]> readBits(BitBuffer buffer, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        T[] value = this.constructor.apply((Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow());
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBits(buffer, context).orElseGet(this.defaultValue);
        }
        return Optional.of(value);
    }

    @Override
    public final void writeBytes(@Nullable T[] value, ByteBuf buffer, Object context) {
        T[] TArray = this.elementAdapter;
        if (!(TArray instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)TArray;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_3.writeBytes(value.length, buffer);
            for (T element : value) {
                adapter.writeBytes(element, buffer, context);
            }
        }
    }

    @Override
    public final Optional<T[]> readBytes(ByteBuf buffer, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        T[] value = this.constructor.apply((Integer)Adapters.INT_SEGMENTED_3.readBytes(buffer).orElseThrow());
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBytes(buffer, context).orElseGet(this.defaultValue);
        }
        return Optional.of(value);
    }

    @Override
    public void writeData(@Nullable T[] value, DataOutput data, Object context) throws IOException {
        T[] TArray = this.elementAdapter;
        if (!(TArray instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)TArray;
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_3.writeData(value.length, data);
            for (T element : value) {
                adapter.writeData(element, data, context);
            }
        }
    }

    @Override
    public Optional<T[]> readData(DataInput data, Object context) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        T[] value = this.constructor.apply((Integer)Adapters.INT_SEGMENTED_3.readData(data).orElseThrow());
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readData(data, context).orElseGet(this.defaultValue);
        }
        return Optional.of(value);
    }

    @Override
    public final Optional<Tag> writeNbt(@Nullable T[] value, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        ListTag list = new ListTag();
        for (T element : value) {
            list.add((Object)((Tag)adapter.writeNbt(element, context).orElseGet(() -> adapter.writeNbt(this.defaultValue.get(), context).orElseThrow())));
        }
        return Optional.of(list);
    }

    @Override
    public final Optional<T[]> readNbt(@Nullable Tag nbt, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (!(nbt instanceof ListTag)) {
            return Optional.empty();
        }
        ListTag list = (ListTag)nbt;
        T[] value = this.constructor.apply(list.size());
        for (int i = 0; i < list.size(); ++i) {
            value[i] = adapter.readNbt(list.get(i), context).orElseGet(this.defaultValue);
        }
        return Optional.of(value);
    }

    @Override
    public final Optional<JsonElement> writeJson(@Nullable T[] value, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        JsonArray array = new JsonArray();
        for (T element : value) {
            array.add((JsonElement)adapter.writeJson(element, context).orElseGet(() -> adapter.writeJson(this.defaultValue.get(), context).orElse(null)));
        }
        return Optional.of(array);
    }

    @Override
    public final Optional<T[]> readJson(@Nullable JsonElement json, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (json == null) {
            return Optional.empty();
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            T[] value = this.constructor.apply(array.size());
            for (int i = 0; i < array.size(); ++i) {
                value[i] = adapter.readJson(array.get(i), context).orElseGet(this.defaultValue);
            }
            return Optional.of(value);
        }
        T[] value = this.constructor.apply(1);
        value[0] = adapter.readJson(json, context).orElseGet(this.defaultValue);
        return Optional.of(value);
    }
}

