/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.array;

import com.google.gson.JsonArray;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;

public class BooleanArrayAdapter
implements ISimpleAdapter<boolean[], Tag, JsonArray> {
    private final boolean nullable;

    public BooleanArrayAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public BooleanArrayAdapter asNullable() {
        return new BooleanArrayAdapter(true);
    }

    @Override
    public final void writeBits(@Nullable boolean[] value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBits(value.length, buffer);
            for (boolean element : value) {
                Adapters.BOOLEAN.writeBits(element, buffer);
            }
        }
    }

    @Override
    public final Optional<boolean[]> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        boolean[] value = new boolean[((Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        }
        return Optional.of(value);
    }

    @Override
    public final void writeBytes(@Nullable boolean[] value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBytes(value.length, buffer);
            for (boolean element : value) {
                Adapters.BOOLEAN.writeBytes(element, buffer);
            }
        }
    }

    @Override
    public final Optional<boolean[]> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        boolean[] value = new boolean[((Integer)Adapters.INT_SEGMENTED_7.readBytes(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = Adapters.BOOLEAN.readBytes(buffer).orElseThrow();
        }
        return Optional.of(value);
    }

    @Override
    public void writeData(@Nullable boolean[] value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeData(value.length, data);
            for (boolean element : value) {
                Adapters.BOOLEAN.writeData(element, data);
            }
        }
    }

    @Override
    public Optional<boolean[]> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        boolean[] value = new boolean[((Integer)Adapters.INT_SEGMENTED_7.readData(data).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = Adapters.BOOLEAN.readData(data).orElseThrow();
        }
        return Optional.of(value);
    }

    @Override
    public final Optional<Tag> writeNbt(@Nullable boolean[] value) {
        if (value == null) {
            return Optional.empty();
        }
        int size = value.length * 2;
        if (size <= 64) {
            long compressed = 0L;
            for (int i = 0; i < value.length; ++i) {
                compressed |= (value[i] ? 11L : 10L) << i * 2;
            }
            if (size <= 8) {
                return Optional.of(ByteTag.m_128266_((byte)((byte)compressed)));
            }
            if (size <= 16) {
                return Optional.of(ShortTag.m_129258_((short)((short)compressed)));
            }
            if (size <= 32) {
                return Optional.of(IntTag.m_128679_((int)((int)compressed)));
            }
            return Optional.of(LongTag.m_128882_((long)compressed));
        }
        byte[] result = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i] ? (byte)1 : 0;
        }
        return Adapters.BYTE_ARRAY.writeNbt(result);
    }

    @Override
    public final Optional<boolean[]> readNbt(@Nullable Tag nbt) {
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            for (long compressed = numeric.m_7046_(); compressed != 0L; compressed >>>= 2) {
                list.add((compressed & 3L) == 3L);
            }
            boolean[] result = new boolean[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                result[i] = (Boolean)list.get(i);
            }
            return Optional.of(result);
        }
        if (nbt instanceof ByteArrayTag) {
            ByteArrayTag array = (ByteArrayTag)nbt;
            boolean[] value = new boolean[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                value[i] = array.get(i).m_7063_() == 1;
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public final Optional<JsonArray> writeJson(@Nullable boolean[] value) {
        if (value == null) {
            return Optional.empty();
        }
        JsonArray array = new JsonArray(value.length);
        for (boolean b : value) {
            array.add(Boolean.valueOf(b));
        }
        return Optional.of(array);
    }

    @Override
    public final Optional<boolean[]> readJson(@Nullable JsonArray json) {
        if (json == null) {
            return Optional.empty();
        }
        boolean[] value = new boolean[json.size()];
        for (int i = 0; i < json.size(); ++i) {
            value[i] = json.get(i).getAsBoolean();
        }
        return Optional.of(value);
    }
}

