/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.adapter.IByteAdapter;
import iskallia.vault.core.data.adapter.IDataAdapter;
import iskallia.vault.core.data.adapter.IJsonAdapter;
import iskallia.vault.core.data.adapter.INbtAdapter;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;

public class DoubleArrayAdapter
implements ISimpleAdapter<double[], Tag, JsonElement> {
    private final Object elementAdapter;
    private final boolean nullable;

    public DoubleArrayAdapter(Object elementAdapter, boolean nullable) {
        this.elementAdapter = elementAdapter;
        this.nullable = nullable;
    }

    public Object getElementAdapter() {
        return this.elementAdapter;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public DoubleArrayAdapter asNullable() {
        return new DoubleArrayAdapter(this.elementAdapter, true);
    }

    @Override
    public final void writeBits(@Nullable double[] value, BitBuffer buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBits(value.length, buffer);
            for (Object element : (Object)value) {
                adapter.writeBits((double)element, buffer, null);
            }
        }
    }

    @Override
    public final Optional<double[]> readBits(BitBuffer buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        double[] value = new double[((Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (Double)((Object)adapter.readBits(buffer, null).orElse(0));
        }
        return Optional.of(value);
    }

    @Override
    public final void writeBytes(@Nullable double[] value, ByteBuf buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeBytes(value.length, buffer);
            for (Object element : (Object)value) {
                adapter.writeBytes((double)element, buffer, null);
            }
        }
    }

    @Override
    public final Optional<double[]> readBytes(ByteBuf buffer) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        double[] value = new double[((Integer)Adapters.INT_SEGMENTED_7.readBytes(buffer).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (Double)((Object)adapter.readBytes(buffer, null).orElse(0));
        }
        return Optional.of(value);
    }

    @Override
    public void writeData(@Nullable double[] value, DataOutput data) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_7.writeData(value.length, data);
            for (Object element : (Object)value) {
                adapter.writeData((double)element, data, null);
            }
        }
    }

    @Override
    public Optional<double[]> readData(DataInput data) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        double[] value = new double[((Integer)Adapters.INT_SEGMENTED_7.readData(data).orElseThrow()).intValue()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (Double)((Object)adapter.readData(data, null).orElse(0));
        }
        return Optional.of(value);
    }

    @Override
    public final Optional<Tag> writeNbt(@Nullable double[] value) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        NumericTag[] tags = new NumericTag[value.length];
        for (int i = 0; i < value.length; ++i) {
            tags[i] = (NumericTag)adapter.writeNbt(value[i], null).orElseThrow();
        }
        if (Arrays.stream(tags).allMatch(element -> (double)element.m_7063_() == element.m_7061_())) {
            byte[] bytes = new byte[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                bytes[i] = tags[i].m_7063_();
            }
            return Optional.of(new ByteArrayTag(bytes));
        }
        if (Arrays.stream(tags).allMatch(element -> (double)element.m_7047_() == element.m_7061_())) {
            int[] bytes = new int[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                bytes[i] = tags[i].m_7047_();
            }
            return Optional.of(new IntArrayTag(bytes));
        }
        ListTag doubles = new ListTag();
        for (NumericTag tag : tags) {
            doubles.add((Object)DoubleTag.m_128500_((double)tag.m_7061_()));
        }
        return Optional.of(doubles);
    }

    @Override
    public final Optional<double[]> readNbt(@Nullable Tag nbt) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return Optional.of(new double[]{numeric.m_7061_()});
        }
        if (nbt instanceof CollectionTag) {
            CollectionTag array = (CollectionTag)nbt;
            double[] value = new double[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                value[i] = (Double)((Object)adapter.readNbt((Tag)array.get(i), null).orElse(0));
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public final Optional<JsonElement> writeJson(@Nullable double[] value) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        JsonPrimitive[] primitives = new JsonPrimitive[value.length];
        for (int i = 0; i < value.length; ++i) {
            primitives[i] = (JsonPrimitive)adapter.writeJson(value[i], null).orElseGet(() -> new JsonPrimitive((Number)0));
        }
        JsonArray doubles = new JsonArray(primitives.length);
        for (JsonPrimitive primitive : primitives) {
            doubles.add((Number)primitive.getAsDouble());
        }
        return Optional.of(doubles);
    }

    @Override
    public final Optional<double[]> readJson(@Nullable JsonElement json) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (json == null) {
            return Optional.empty();
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            double[] value = new double[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                value[i] = (Double)((Object)adapter.readJson(array.get(i), null).orElse(0));
            }
            return Optional.of(value);
        }
        return Optional.of(new double[]{json.getAsDouble()});
    }
}

