/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.basic;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;

public abstract class SupplierAdapter<T extends ISerializable<?, ?>>
implements ISimpleAdapter<T, Tag, JsonElement> {
    private final boolean nullable;

    public SupplierAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    protected abstract void writeSuppliedBits(T var1, BitBuffer var2);

    protected abstract T readSuppliedBits(BitBuffer var1);

    protected abstract void writeSuppliedBytes(T var1, ByteBuf var2);

    protected abstract T readSuppliedBytes(ByteBuf var1);

    protected abstract void writeSuppliedData(T var1, DataOutput var2) throws IOException;

    protected abstract T readSuppliedData(DataInput var1) throws IOException;

    @Nullable
    protected abstract Tag writeSuppliedNbt(T var1);

    @Nullable
    protected abstract T readSuppliedNbt(Tag var1);

    @Nullable
    protected abstract JsonElement writeSuppliedJson(T var1);

    @Nullable
    protected abstract T readSuppliedJson(JsonElement var1);

    @Override
    public void writeBits(@Nullable T value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeSuppliedBits(value, buffer);
        }
    }

    @Override
    public Optional<T> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedBits(buffer));
    }

    @Override
    public void writeBytes(@Nullable T value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeSuppliedBytes(value, buffer);
        }
    }

    @Override
    public Optional<T> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedBytes(buffer));
    }

    @Override
    public void writeData(@Nullable T value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeSuppliedData(value, data);
        }
    }

    @Override
    public Optional<T> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedData(data));
    }

    @Override
    public Optional<Tag> writeNbt(@Nullable T value) {
        return value == null ? Optional.empty() : Optional.ofNullable(this.writeSuppliedNbt(value));
    }

    @Override
    public Optional<T> readNbt(@Nullable Tag nbt) {
        if (nbt == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedNbt(nbt));
    }

    @Override
    public Optional<JsonElement> writeJson(@Nullable T value) {
        return value == null ? Optional.empty() : Optional.ofNullable(this.writeSuppliedJson(value));
    }

    @Override
    public Optional<T> readJson(@Nullable JsonElement json) {
        if (json == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.readSuppliedJson(json));
    }
}

