/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.basic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class UuidAdapter
implements ISimpleAdapter<UUID, Tag, JsonElement> {
    private final boolean nullable;

    public UuidAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public UuidAdapter asNullable() {
        return new UuidAdapter(true);
    }

    @Override
    public void writeBits(@Nullable UUID value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeLong(value.getMostSignificantBits());
            buffer.writeLong(value.getLeastSignificantBits());
        }
    }

    @Override
    public Optional<UUID> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new UUID(buffer.readLong(), buffer.readLong()));
    }

    @Override
    public void writeBytes(@Nullable UUID value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeLong(value.getMostSignificantBits());
            buffer.writeLong(value.getLeastSignificantBits());
        }
    }

    @Override
    public Optional<UUID> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new UUID(buffer.readLong(), buffer.readLong()));
    }

    @Override
    public void writeData(@Nullable UUID value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            data.writeLong(value.getMostSignificantBits());
            data.writeLong(value.getLeastSignificantBits());
        }
    }

    @Override
    public Optional<UUID> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new UUID(data.readLong(), data.readLong()));
    }

    @Override
    public Optional<Tag> writeNbt(@Nullable UUID value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new IntArrayTag(new int[]{(int)(value.getMostSignificantBits() >>> 32), (int)value.getMostSignificantBits(), (int)(value.getLeastSignificantBits() >>> 32), (int)value.getLeastSignificantBits()}));
    }

    @Override
    public Optional<UUID> readNbt(@Nullable Tag nbt) {
        CollectionTag array;
        CollectionTag array2;
        if (nbt instanceof CollectionTag && (array2 = (CollectionTag)nbt).size() == 4) {
            return Optional.of(new UUID((long)Adapters.INT.readNbt((Tag)array2.get(0)).orElse(0).intValue() << 32 | Integer.toUnsignedLong(Adapters.INT.readNbt((Tag)array2.get(1)).orElse(0)), (long)Adapters.INT.readNbt((Tag)array2.get(2)).orElse(0).intValue() << 32 | Integer.toUnsignedLong(Adapters.INT.readNbt((Tag)array2.get(3)).orElse(0))));
        }
        if (nbt instanceof CollectionTag && (array = (CollectionTag)nbt).size() == 2) {
            return Optional.of(new UUID(Adapters.LONG.readNbt((Tag)array.get(0)).orElse(0L), Adapters.LONG.readNbt((Tag)array.get(1)).orElse(0L)));
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            try {
                return Optional.of(UUID.fromString(string.m_7916_()));
            }
            catch (IllegalStateException exception) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<JsonElement> writeJson(@Nullable UUID value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive(value.toString()));
    }

    @Override
    public Optional<UUID> readJson(@Nullable JsonElement json) {
        JsonPrimitive primitive;
        JsonArray array;
        JsonArray array2;
        if (json instanceof JsonArray && (array2 = (JsonArray)json).size() == 4) {
            return Optional.of(new UUID((long)Adapters.INT.readJson(array2.get(0)).orElse(0).intValue() << 32 | Integer.toUnsignedLong(Adapters.INT.readJson(array2.get(1)).orElse(0)), (long)Adapters.INT.readJson(array2.get(2)).orElse(0).intValue() << 32 | Integer.toUnsignedLong(Adapters.INT.readJson(array2.get(3)).orElse(0))));
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 2) {
            return Optional.of(new UUID(Adapters.LONG.readJson(array.get(0)).orElse(0L), Adapters.LONG.readJson(array.get(1)).orElse(0L)));
        }
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            try {
                return Optional.of(UUID.fromString(primitive.getAsString()));
            }
            catch (IllegalStateException exception) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

