/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.list;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.adapter.IByteAdapter;
import iskallia.vault.core.data.adapter.IComplexAdapter;
import iskallia.vault.core.data.adapter.IDataAdapter;
import iskallia.vault.core.data.adapter.IJsonAdapter;
import iskallia.vault.core.data.adapter.INbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ListAdapter<T>
implements IComplexAdapter<List<T>, Tag, JsonElement, Object> {
    private final IntFunction<List<T>> constructor;
    private final Object elementAdapter;
    private final Supplier<T> defaultValue;
    private final boolean nullable;

    public ListAdapter(IntFunction<List<T>> constructor, Object elementAdapter, Supplier<T> defaultValue, boolean nullable) {
        this.constructor = constructor;
        this.elementAdapter = elementAdapter;
        this.defaultValue = defaultValue;
        this.nullable = nullable;
    }

    public IntFunction<List<T>> getConstructor() {
        return this.constructor;
    }

    public Object getElementAdapter() {
        return this.elementAdapter;
    }

    public Supplier<T> getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ListAdapter<T> asNullable() {
        return new ListAdapter<T>(this.constructor, this.elementAdapter, this.defaultValue, true);
    }

    @Override
    public void writeBits(@Nullable List<T> value, BitBuffer buffer, @Nullable Object context) {
        Iterator<T> iterator = this.elementAdapter;
        if (!(iterator instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)((Object)iterator);
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_3.writeBits(value.size(), buffer);
            for (T element : value) {
                adapter.writeBits(element, buffer, context);
            }
        }
    }

    @Override
    public Optional<List<T>> readBits(BitBuffer buffer, @Nullable Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        int listSize = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        List value = this.constructor.apply(listSize);
        for (int i = 0; i < listSize; ++i) {
            adapter.readBits(buffer, context).or(this.defaultValue).ifPresent(element -> value.add(element));
        }
        return Optional.of(value);
    }

    @Override
    public void writeBytes(@Nullable List<T> value, ByteBuf buffer, @Nullable Object context) {
        Iterator<T> iterator = this.elementAdapter;
        if (!(iterator instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)((Object)iterator);
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_3.writeBytes(value.size(), buffer);
            for (T element : value) {
                adapter.writeBytes(element, buffer, context);
            }
        }
    }

    @Override
    public Optional<List<T>> readBytes(ByteBuf buffer, @Nullable Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        int listSize = (Integer)Adapters.INT_SEGMENTED_3.readBytes(buffer).orElseThrow();
        List value = this.constructor.apply(listSize);
        for (int i = 0; i < listSize; ++i) {
            adapter.readBytes(buffer, context).or(this.defaultValue).ifPresent(element -> value.add(element));
        }
        return Optional.of(value);
    }

    @Override
    public void writeData(@Nullable List<T> value, DataOutput data, @Nullable Object context) throws IOException {
        Iterator<T> iterator = this.elementAdapter;
        if (!(iterator instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)((Object)iterator);
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_3.writeData(value.size(), data);
            for (T element : value) {
                adapter.writeData(element, data, context);
            }
        }
    }

    @Override
    public Optional<List<T>> readData(DataInput data, @Nullable Object context) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        int listSize = (Integer)Adapters.INT_SEGMENTED_3.readData(data).orElseThrow();
        List value = this.constructor.apply(listSize);
        for (int i = 0; i < listSize; ++i) {
            adapter.readData(data, context).or(this.defaultValue).ifPresent(element -> value.add(element));
        }
        return Optional.of(value);
    }

    @Override
    public Optional<Tag> writeNbt(@Nullable List<T> value, @Nullable Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        ListTag list = new ListTag();
        for (T element : value) {
            list.add((Object)((Tag)adapter.writeNbt(element, context).orElseGet(() -> adapter.writeNbt(this.defaultValue.get(), context).orElseThrow())));
        }
        return Optional.of(list);
    }

    @Override
    public Optional<List<T>> readNbt(@Nullable Tag nbt, @Nullable Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (!(nbt instanceof ListTag)) {
            return Optional.empty();
        }
        ListTag listTag = (ListTag)nbt;
        List value = this.constructor.apply(listTag.size());
        for (int i = 0; i < listTag.size(); ++i) {
            adapter.readNbt(listTag.get(i), context).or(this.defaultValue).ifPresent(element -> value.add(element));
        }
        return Optional.of(value);
    }

    @Override
    public Optional<JsonElement> writeJson(@Nullable List<T> value, @Nullable Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        JsonArray array = new JsonArray();
        for (T element : value) {
            array.add((JsonElement)adapter.writeJson(element, context).orElseGet(() -> adapter.writeJson(this.defaultValue.get(), context).orElse(null)));
        }
        return Optional.of(array);
    }

    @Override
    public Optional<List<T>> readJson(@Nullable JsonElement json, @Nullable Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (!(json instanceof JsonArray)) {
            return Optional.empty();
        }
        JsonArray array = (JsonArray)json;
        List value = this.constructor.apply(array.size());
        for (int i = 0; i < array.size(); ++i) {
            adapter.readJson(array.get(i), context).or(this.defaultValue).ifPresent(element -> value.add(element));
        }
        return Optional.of(value);
    }
}

