/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class ByteArrayNbtAdapter
extends NbtAdapter<ByteArrayTag> {
    public ByteArrayNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public ByteArrayNbtAdapter asNullable() {
        return new ByteArrayNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(ByteArrayTag value, BitBuffer buffer) {
        Adapters.BYTE_ARRAY.writeBits(value.m_128227_(), buffer);
    }

    @Override
    protected ByteArrayTag readTagBits(BitBuffer buffer) {
        return new ByteArrayTag(Adapters.BYTE_ARRAY.readBits(buffer).orElseThrow());
    }

    @Override
    protected void writeTagBytes(ByteArrayTag value, ByteBuf buffer) {
        Adapters.BYTE_ARRAY.writeBytes(value.m_128227_(), buffer);
    }

    @Override
    protected ByteArrayTag readTagBytes(ByteBuf buffer) {
        return new ByteArrayTag(Adapters.BYTE_ARRAY.readBytes(buffer).orElseThrow());
    }

    @Override
    protected void writeTagData(ByteArrayTag value, DataOutput data) throws IOException {
        Adapters.BYTE_ARRAY.writeData(value.m_128227_(), data);
    }

    @Override
    protected ByteArrayTag readTagData(DataInput data) throws IOException {
        return new ByteArrayTag(Adapters.BYTE_ARRAY.readData(data).orElseThrow());
    }

    @Override
    protected Tag writeTagNbt(ByteArrayTag value) {
        return value.m_6426_();
    }

    @Override
    @Nullable
    protected ByteArrayTag readTagNbt(Tag nbt) {
        ByteArrayTag byteArrayTag;
        if (nbt instanceof ByteArrayTag) {
            ByteArrayTag tag = (ByteArrayTag)nbt;
            byteArrayTag = (ByteArrayTag)tag.m_6426_();
        } else {
            byteArrayTag = null;
        }
        return byteArrayTag;
    }

    @Override
    protected JsonElement writeTagJson(ByteArrayTag value) {
        return Adapters.BYTE_ARRAY.writeJson(value.m_128227_()).map(array -> {
            JsonArray copy = new JsonArray();
            copy.add("B");
            for (int i = 1; i < array.size(); ++i) {
                copy.add(array.get(i));
            }
            return copy;
        }).orElse(null);
    }

    @Override
    @Nullable
    protected ByteArrayTag readTagJson(JsonElement json) {
        if (json instanceof JsonArray) {
            JsonPrimitive primitive;
            JsonElement jsonElement;
            JsonArray array = (JsonArray)json;
            if (array.size() > 0 && (jsonElement = array.get(0)) instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).getAsString().equals("B")) {
                JsonArray copy = new JsonArray();
                for (int i = 1; i < array.size(); ++i) {
                    copy.add(array.get(i));
                }
                array = copy;
            }
            return Adapters.BYTE_ARRAY.readJson(array).map(ByteArrayTag::new).orElse(null);
        }
        return null;
    }
}

