/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class DoubleNbtAdapter
extends NbtAdapter<DoubleTag> {
    public DoubleNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public DoubleNbtAdapter asNullable() {
        return new DoubleNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(DoubleTag value, BitBuffer buffer) {
        Adapters.DOUBLE.writeBits(value.m_7061_(), buffer);
    }

    @Override
    protected DoubleTag readTagBits(BitBuffer buffer) {
        return DoubleTag.m_128500_((double)((Double)Adapters.DOUBLE.readBits(buffer).orElseThrow()));
    }

    @Override
    protected void writeTagBytes(DoubleTag value, ByteBuf buffer) {
        Adapters.DOUBLE.writeBytes(value.m_7061_(), buffer);
    }

    @Override
    protected DoubleTag readTagBytes(ByteBuf buffer) {
        return DoubleTag.m_128500_((double)((Double)Adapters.DOUBLE.readBytes(buffer).orElseThrow()));
    }

    @Override
    protected void writeTagData(DoubleTag value, DataOutput data) throws IOException {
        Adapters.DOUBLE.writeData(value.m_7061_(), data);
    }

    @Override
    protected DoubleTag readTagData(DataInput data) throws IOException {
        return DoubleTag.m_128500_((double)((Double)Adapters.DOUBLE.readData(data).orElseThrow()));
    }

    @Override
    protected Tag writeTagNbt(DoubleTag value) {
        return value;
    }

    @Override
    @Nullable
    protected DoubleTag readTagNbt(Tag nbt) {
        DoubleTag tag;
        return nbt instanceof DoubleTag ? (tag = (DoubleTag)nbt) : null;
    }

    @Override
    protected JsonElement writeTagJson(DoubleTag value) {
        return Adapters.DOUBLE.writeJson(value.m_7061_()).orElseThrow();
    }

    @Override
    @Nullable
    protected DoubleTag readTagJson(JsonElement json) {
        return Adapters.DOUBLE.readJson(json).map(DoubleTag::m_128500_).orElse(null);
    }
}

