/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class FloatNbtAdapter
extends NbtAdapter<FloatTag> {
    public FloatNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public FloatNbtAdapter asNullable() {
        return new FloatNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(FloatTag value, BitBuffer buffer) {
        Adapters.FLOAT.writeBits(Float.valueOf(value.m_7057_()), buffer);
    }

    @Override
    protected FloatTag readTagBits(BitBuffer buffer) {
        return FloatTag.m_128566_((float)((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue());
    }

    @Override
    protected void writeTagBytes(FloatTag value, ByteBuf buffer) {
        Adapters.FLOAT.writeBytes(Float.valueOf(value.m_7057_()), buffer);
    }

    @Override
    protected FloatTag readTagBytes(ByteBuf buffer) {
        return FloatTag.m_128566_((float)((Float)Adapters.FLOAT.readBytes(buffer).orElseThrow()).floatValue());
    }

    @Override
    protected void writeTagData(FloatTag value, DataOutput data) throws IOException {
        Adapters.FLOAT.writeData(Float.valueOf(value.m_7057_()), data);
    }

    @Override
    protected FloatTag readTagData(DataInput data) throws IOException {
        return FloatTag.m_128566_((float)((Float)Adapters.FLOAT.readData(data).orElseThrow()).floatValue());
    }

    @Override
    protected Tag writeTagNbt(FloatTag value) {
        return value;
    }

    @Override
    @Nullable
    protected FloatTag readTagNbt(Tag nbt) {
        FloatTag tag;
        return nbt instanceof FloatTag ? (tag = (FloatTag)nbt) : null;
    }

    @Override
    protected JsonElement writeTagJson(FloatTag value) {
        return Adapters.FLOAT.writeJson(Float.valueOf(value.m_7057_())).orElseThrow();
    }

    @Override
    @Nullable
    protected FloatTag readTagJson(JsonElement json) {
        return Adapters.FLOAT.readJson(json).map(FloatTag::m_128566_).orElse(null);
    }
}

